select
	EXTRACT (MONTH FROM B.DATA_INCL) as mes
	,sum(case when 
		EXTRACT (YEAR FROM B.DATA_INCL) = $anoAtual 
		THEN 1 else 0 end) as anoatual
	,sum(case when 
		EXTRACT (YEAR FROM B.DATA_INCL) = $anoAtual-1
		THEN 1 else 0 end) as anomenos1
	,sum(case when 
		EXTRACT (YEAR FROM B.DATA_INCL) = $anoAtual-2
		THEN 1 else 0 end) as anomenos2
from VER_NTL_PERM_BENEF B
inner join VER_NTL_BEN_PROD_ANS A on 
	A.COD_BENEFICIARIO = B.COD_BENEFICIARIO
	AND A.COD_EMPRESA = B.COD_EMPRESA
	AND A.COD_FAMILIA = B.COD_FAMILIA
	AND A.COD_CONTRATO = B.COD_CONTRATO
WHERE
	A.PF_PJ = 'F'
	AND (B.DATA_EXCL is null OR B.DATA_EXCL > CURRENT_DATE)
	AND EXTRACT (YEAR FROM B.DATA_INCL) IN ($anoAtual,$anoAtual-1,$anoAtual-2)
group by 
EXTRACT (MONTH FROM B.DATA_INCL)
order by 
1