
SELECT EXTRACT(year FROM DATA_VENCIMENTO) as YEAR, 
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (1,2,3) THEN AVG(T.DATA_PGTO - T.DATA_VENCIMENTO) ELSE 0 END AS PRIMEIRO_TRIMESTRE,
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (4,5,6) THEN AVG(T.DATA_PGTO - T.DATA_VENCIMENTO) ELSE 0 END AS SEGUNDO_TRIMESTRE,
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (7,8,9) THEN AVG(T.DATA_PGTO - T.DATA_VENCIMENTO) ELSE 0 END AS TERCEIRO_TRIMESTRE,
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (10,11,12) THEN AVG(T.DATA_PGTO - T.DATA_VENCIMENTO) ELSE 0 END AS QUARTO_TRIMESTRE
	FROM VER_NTL_TITULOS_PF T
where T.NUM_DOC IN (
	select 
		R.NUM_DOC 
	from VER_NTL_RESUMO_RECEITA R
	WHERE
	R.COD_BENEFICIARIO = $codbeneficiario
)
and T.DATA_PGTO > T.DATA_VENCIMENTO
AND EXTRACT ( year FROM T.DATA_VENCIMENTO) >= 2010
GROUP BY EXTRACT(year FROM DATA_VENCIMENTO), EXTRACT(month FROM DATA_VENCIMENTO)
