SELECT A.YEAR,
AVG(A.PRIMEIRO_TRIMESTRE) AS PRIMEIRO_TRIMESTRE, 
AVG(A.SEGUNDO_TRIMESTRE) AS SEGUNDO_TRIMESTRE,
AVG(A.TERCEIRO_TRIMESTRE) AS TERCEIRO_TRIMESTRE,
AVG(A.QUARTO_TRIMESTRE) AS QUARTO_TRIMESTRE FROM (
SELECT EXTRACT(year FROM DATA_VENCIMENTO) as YEAR, 
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (1,2,3) THEN (T.DATA_PGTO - T.DATA_VENCIMENTO) END AS PRIMEIRO_TRIMESTRE,
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (4,5,6) THEN (T.DATA_PGTO - T.DATA_VENCIMENTO) END AS SEGUNDO_TRIMESTRE,
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (7,8,9) THEN (T.DATA_PGTO - T.DATA_VENCIMENTO) END AS TERCEIRO_TRIMESTRE,
	CASE WHEN EXTRACT(month FROM DATA_VENCIMENTO) IN (10,11,12) THEN (T.DATA_PGTO - T.DATA_VENCIMENTO) END AS QUARTO_TRIMESTRE
	FROM VER_NTL_TITULOS_PF T
where T.NUM_DOC IN (
	select 
		R.NUM_DOC 
	from VER_NTL_RESUMO_RECEITA R
	WHERE
	R.COD_BENEFICIARIO = $codbeneficiario
)
and T.DATA_PGTO > T.DATA_VENCIMENTO
AND EXTRACT ( year FROM T.DATA_VENCIMENTO) >= 2010
GROUP BY EXTRACT(year FROM DATA_VENCIMENTO), EXTRACT(month FROM DATA_VENCIMENTO), (T.DATA_PGTO - T.DATA_VENCIMENTO)
) A GROUP BY A.YEAR ORDER BY A.YEAR