SELECT SUM(R.VALOR_CC) AS VALOR_TOTAL, EXTRACT(year FROM T.DATA_PGTO) as ANO, TO_CHAR(T.DATA_PGTO, 'MM') as MES 
	FROM VER_NTL_RESUMO_RECEITA R 
	INNER JOIN 
		( (SELECT NUM_DOC, DATA_PGTO FROM VER_NTL_TITULOS_PF WHERE NUM_DOC IN (SELECT NUM_DOC FROM VER_NTL_RESUMO_RECEITA WHERE COD_BENEFICIARIO = $codbeneficiario)) 
		UNION ALL (SELECT NUM_DOC, DATA_PGTO FROM VER_NTL_TITULOS_PJ WHERE NUM_DOC IN (SELECT NUM_DOC FROM VER_NTL_RESUMO_RECEITA WHERE COD_BENEFICIARIO = $codbeneficiario) )
		) T
	ON (R.NUM_DOC = T.NUM_DOC) 
	WHERE R.COD_BENEFICIARIO = $codbeneficiario GROUP BY EXTRACT(year FROM T.DATA_PGTO), TO_CHAR(T.DATA_PGTO, 'MM')
 