/*select
count(1) as total
,sum(T.VALOR_TOTAL) as valortotal
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then 1 else 0 end) as aberto
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then T.VALOR_TOTAL else 0 end) as valoraberto
,sum(case when T.DATA_PGTO = T.DATA_VENCIMENTO then 1 else 0 end) as emdia
,sum(case when T.DATA_PGTO = T.DATA_VENCIMENTO then T.VALOR_PAGO else 0 end) as valoremdia
,sum(case when T.DATA_PGTO > T.DATA_VENCIMENTO then 1 else 0 end) as atrasado
,sum(case when T.DATA_PGTO > T.DATA_VENCIMENTO then T.VALOR_PAGO else 0 end) as valoratrasado
,sum(case when T.DATA_PGTO < T.DATA_VENCIMENTO then 1 else 0 end) as antecipado
,sum(case when T.DATA_PGTO < T.DATA_VENCIMENTO then T.VALOR_PAGO else 0 end) as valorantecipado
from VER_NTL_TITULOS_PF T
where T.NUM_DOC IN (
	select  DISTINCT
		R.NUM_DOC 
	from VER_NTL_RESUMO_RECEITA R
	WHERE
	R.COD_BENEFICIARIO = $codbeneficiario
)

*/

SELECT
count(1) as total
,sum(R.VALOR_CC) as valortotal
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then 1 else 0 end) as aberto
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then R.VALOR_CC else 0 end) as valoraberto
,sum(case when T.DATA_PGTO = T.DATA_VENCIMENTO then 1 else 0 end) as emdia
,sum(case when T.DATA_PGTO = T.DATA_VENCIMENTO then R.VALOR_CC else 0 end) as valoremdia
,sum(case when T.DATA_PGTO > T.DATA_VENCIMENTO then 1 else 0 end) as atrasado
,sum(case when T.DATA_PGTO > T.DATA_VENCIMENTO then R.VALOR_CC else 0 end) as valoratrasado
,sum(case when T.DATA_PGTO < T.DATA_VENCIMENTO then 1 else 0 end) as antecipado
,sum(case when T.DATA_PGTO < T.DATA_VENCIMENTO then R.VALOR_CC else 0 end) as valorantecipado
 FROM VER_NTL_TITULOS_PF T 
		INNER JOIN VER_NTL_RESUMO_RECEITA R ON (T.NUM_DOC = R.NUM_DOC)
		WHERE  R.COD_BENEFICIARIO = $codbeneficiario
		GROUP BY R.COD_BENEFICIARIO
