select
	count(distinct case when 
		B.DATA_EXCL is null OR B.DATA_EXCL > CURRENT_DATE then B.COD_BENEFICIARIO end ) as total
	,sum(case when 
		EXTRACT (YEAR FROM B.DATA_INCL) = $anoAtual 
		AND EXTRACT (MONTH FROM B.DATA_INCL) = $mesAtual
		THEN 1 else 0 end) as ativosmes
	,sum(case when 
		EXTRACT (YEAR FROM B.DATA_EXCL) = $anoAtual 
		AND EXTRACT (MONTH FROM B.DATA_EXCL) = $mesAtual
		THEN 1 else 0 end) as inativosmes
	,sum(case when 
		EXTRACT (YEAR FROM B.DATA_INCL) = $anoAtual 
		THEN 1 else 0 end) as ativosano
	,sum(case when 
		EXTRACT (YEAR FROM B.DATA_EXCL) = $anoAtual
		THEN 1 else 0 end) as inativosano
from VER_NTL_PERM_BENEF B
inner join VER_NTL_BEN_PROD_ANS A on 
	A.COD_BENEFICIARIO = B.COD_BENEFICIARIO
	AND A.COD_EMPRESA = B.COD_EMPRESA
	AND A.COD_FAMILIA = B.COD_FAMILIA
	AND A.COD_CONTRATO = B.COD_CONTRATO
WHERE
	A.PF_PJ = 'F'
	