select
	A.NOME_PERFIL as produto
	,count(distinct B.COD_BENEFICIARIO) as beneficiarios
	,sum(case when A.SEXO = 'M' THEN 1 ELSE 0 END) as masculino 
	,sum(case when A.SEXO = 'F' THEN 1 ELSE 0 END) as feminino 
	,sum((CURRENT_DATE - DATA_NASCIMENTO)/365) as anos 
from VER_NTL_BEN_PROD_ANS A
inner join VER_NTL_PERM_BENEF B
	on B.COD_BENEFICIARIO = A.COD_BENEFICIARIO
	AND B.COD_EMPRESA = A.COD_EMPRESA
	AND B.COD_FAMILIA = A.COD_FAMILIA
	AND B.COD_CONTRATO= A.COD_CONTRATO
WHERE
	(B.DATA_EXCL IS NULL OR B.DATA_EXCL > CURRENT_DATE)
	AND A.PF_PJ = 'F'
group by
	A.NOME_PERFIL
order by 
2