select
count(1) as total
,sum(T.VALOR_TOTAL) as valortotal
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then 1 else 0 end) as aberto
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then T.VALOR_TOTAL else 0 end) as valoraberto
,sum(case when T.DATA_PGTO = T.DATA_VENCIMENTO then 1 else 0 end) as emdia
,sum(case when T.DATA_PGTO = T.DATA_VENCIMENTO then T.VALOR_TOTAL else 0 end) as valoremdia
,sum(case when T.DATA_PGTO > T.DATA_VENCIMENTO then 1 else 0 end) as atrasado
,sum(case when T.DATA_PGTO > T.DATA_VENCIMENTO then T.VALOR_TOTAL else 0 end) as valoratrasado
,sum(case when T.DATA_PGTO < T.DATA_VENCIMENTO then 1 else 0 end) as antecipado
,sum(case when T.DATA_PGTO < T.DATA_VENCIMENTO then T.VALOR_TOTAL else 0 end) as valorantecipado
from VER_NTL_TITULOS_PF T
where 
	EXTRACT(YEAR from T.DATA_VENCIMENTO) = $anoAtual
	and ($mesAtual = -1 OR EXTRACT(MONTH from T.DATA_VENCIMENTO) = $mesAtual)