SELECT 
	SUBSTR(PERIODO, 1,4) AS ANO, SUBSTR(PERIODO, 5,2) AS MES
	,  VALOR_TOTAL
FROM VER_NTL_RESUMO_DESPESA R 
WHERE 
	CONCAT(R.COD_BENEFICIARIO
		, CONCAT(R.COD_CONTRATO
		, CONCAT(R.COD_EMPRESA
		, CONCAT(R.COD_FAMILIA
		, CONCAT(R.COD_UNIMED) 
	))))
IN 
(SELECT 
	CONCAT(B.COD_BENEFICIARIO
	, B.COD_CONTRATO
	, B.COD_EMPRESA
	, B.COD_FAMILIA
	, B.COD_UNIMED) 
	
	FROM VER_NTL_PERM_BENEF B 
		LEFT JOIN VER_NTL_BEN_PROD_ANS P ON (
			B.COD_BENEFICIARIO = P.COD_BENEFICIARIO 
			AND B.COD_UNIMED = P.COD_UNIMED 
			AND B.COD_EMPRESA = P.COD_EMPRESA 
			AND B.COD_FAMILIA = P.COD_FAMILIA 
			AND B.COD_CONTRATO = P.COD_CONTRATO)
	WHERE 
		B.DATA_EXCL > CURRENT_DATE 
		OR B.DATA_EXCL IS NULL
		AND P.PF_PJ = 'F'
)