SELECT
  P.COD_CONTRATO,
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 0 AND 18 THEN 1 ELSE 0 END) "0-18",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 19 AND 23 THEN 1 ELSE 0 END) "19-23",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 24 AND 28 THEN 1 ELSE 0 END) "24-28",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 29 AND 33 THEN 1 ELSE 0 END) "29-33",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 34 AND 38 THEN 1 ELSE 0 END) "34-38",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 39 AND 43 THEN 1 ELSE 0 END) "39-43",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 44 AND 48 THEN 1 ELSE 0 END) "44-48",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 49 AND 53 THEN 1 ELSE 0 END) "49-53",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 54 AND 58 THEN 1 ELSE 0 END) "54-58",
  SUM(CASE
	WHEN TRUNC(months_between(sysdate, P.DATA_NASCIMENTO) / 12) BETWEEN 59 AND 200 THEN 1 ELSE 0 END) "59-200"
	FROM (SELECT DISTINCT COD_BENEFICIARIO, COD_UNIMED, COD_CONTRATO, COD_EMPRESA, COD_FAMILIA, DATA_NASCIMENTO FROM VER_NTL_BEN_PROD_ANS) P
	INNER JOIN ( SELECT DISTINCT COD_BENEFICIARIO, COD_EMPRESA, COD_UNIMED, COD_FAMILIA, COD_CONTRATO FROM VER_NTL_PERM_BENEF WHERE DATA_EXCL IS NULL OR DATA_EXCL > CURRENT_DATE) ATIVOS
	ON (ATIVOS.COD_BENEFICIARIO = P.COD_BENEFICIARIO AND ATIVOS.COD_UNIMED = P.COD_UNIMED AND ATIVOS.COD_FAMILIA = P.COD_FAMILIA AND ATIVOS.COD_CONTRATO = P.COD_CONTRATO 
		AND ATIVOS.COD_EMPRESA = P.COD_EMPRESA)
GROUP BY P.COD_CONTRATO
	