select
count(1) as total
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then 1 else 0 end) as vencido
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO < CURRENT_DATE then T.VALOR_TOTAL else 0 end) as valorvencido
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO = CURRENT_DATE then 1 else 0 end) as receberhoje
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO = CURRENT_DATE then T.VALOR_TOTAL else 0 end) as valorreceberhoje
,sum(case when T.DATA_PGTO is not null then 1 else 0 end) as recebido
,sum(case when T.DATA_PGTO is not null then T.VALOR_TOTAL else 0 end) as valorrecebido
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO >= CURRENT_DATE then 1 else 0 end) as receber
,sum(case when T.DATA_PGTO is null AND T.DATA_VENCIMENTO >= CURRENT_DATE then T.VALOR_TOTAL else 0 end) as valorreceber
from VER_NTL_TITULOS_PF T
where 
	EXTRACT(YEAR from T.DATA_VENCIMENTO) = $anoAtual
	and ($mesAtual = -1 OR EXTRACT(MONTH from T.DATA_VENCIMENTO) = $mesAtual)