SELECT A.*, B.ATIVOS FROM (
SELECT
	C.COD_EQUIPE
	,C.NOME_FANTASIA AS equipe
	,COUNT(DISTINCT C.COD_AGENTE) AS agentes
	,COUNT(1) AS beneficiarios
	,COUNT(DISTINCT C.COD_BENEFICIARIO) AS beneficiariosdistintos
	,SUM(C.TOTAL) AS comissao
FROM 
(
SELECT COD_BENEFICIARIO, COD_FAMILIA, COD_EMPRESA, COD_CONTRATO, COD_AGENTE, NOME_FANTASIA, COD_EQUIPE, SUM(VALOR_COMISS) AS TOTAL 
FROM VER_NTL_RESUMO_COMISS C
GROUP BY COD_BENEFICIARIO, COD_FAMILIA, COD_EMPRESA, COD_CONTRATO, COD_AGENTE, NOME_FANTASIA, COD_EQUIPE
) C
GROUP BY
C.COD_EQUIPE
,C.NOME_FANTASIA
ORDER BY
5 DESC
) A LEFT JOIN 
(
SELECT C.NOME_FANTASIA, COUNT(DISTINCT C.COD_BENEFICIARIO) AS ATIVOS FROM VER_NTL_RESUMO_COMISS C INNER JOIN VER_NTL_PERM_BENEF B 
	ON B.COD_EMPRESA = C.COD_EMPRESA
	AND B.COD_BENEFICIARIO = C.COD_BENEFICIARIO
	AND B.COD_FAMILIA = C.COD_FAMILIA
	AND B.COD_CONTRATO = C.COD_CONTRATO
WHERE
	(B.DATA_EXCL is null OR B.DATA_EXCL > CURRENT_DATE )
GROUP BY NOME_FANTASIA	) B ON (B.NOME_FANTASIA = A.equipe)