<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
/**
 * Auditoria Controller
 *
 *
 * @method \App\Model\Entity\Auditoria[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class AuditoriaController extends AppController
{
    public function beforeRender(Event $event) {
		$session = $this->request->session();
		$count = 0;
		foreach ($session->read('login.modulos') as $modulo) {
			if ($modulo->chave == 'auditoria'){
				$count = 1;
				break;
			} 
		}
		if ($count == 0) {
			return $this->redirect($this->referer());	
		}
    }

    public function index($hospital = null) {
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        if ($hospital != "todos" && $hospital != null) {
            $hospitalquery = "= ".$hospital;   
        }
        $hospitais = $this->getAllTableWhere('Hospital',['hospitalid '.$hospitalquery]);
        $this->set(compact([
            'pacientes'
            ,'hospitais'
        ]));
    }

    public function tabelaauditoria($hospital, $tipo, $local, $periodo = null) {
        if ($periodo == null) {
            $datainicio = Date("2020-10-01");
            $datafim = Date("Y-m-d");
        } else {
            $datainicio = explode(' - ', $periodo)[0];
            $datafim    = explode(' - ', $periodo)[1];
            $arrdate = explode('a', $datainicio);
            $d = $arrdate[0];
            $m = $arrdate[1];
            $y = $arrdate[2];
            $datainicio = "$y-$m-$d";
    
            $arrdate = explode('a', $datafim);
            $d = $arrdate[0];
            $m = $arrdate[1];
            $y = $arrdate[2];
            $datafim = "$y-$m-$d";
        }

        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        if ($hospital != "todos" && $hospital != null) {
            $hospitalquery = "= ".$hospital;   
        }
        if ($local == 'todos') {
            $localquery = "LIKE '%'";
        } else {
            $localquery = "= '$local'";
        }
        $hoje = Date('Y-m-d');
        switch ($tipo) {
            case 'hospital':
                $pacientes = $this->query(
                    " SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, pa.data_alta, pa.data_obito, ep.observacao, pa.data_entrada AS datacadastro, ep.auditado, ep.usuariocadastronome FROM prontuarioatendimento pa
                      LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
                      LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
                      WHERE pa.hospitalid $hospitalquery AND pa.local $localquery AND DATE_FORMAT(pa.data_entrada, '%Y-%m-%d') BETWEEN '$datainicio' AND '$datafim'
                      GROUP BY pa.prontuarioatendimentoid
                    "
                );
                break;
            case 'hoje':
                $pacientes = $this->query(
                    " SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, pa.data_alta, pa.data_obito, ep.observacao, pa.data_entrada AS datacadastro, ep.auditado, ep.usuariocadastronome FROM prontuarioatendimento pa
                    LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
                    LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
                    WHERE pa.hospitalid $hospitalquery AND pa.local $localquery AND CAST(pa.data_entrada AS DATE) = '$hoje'
                    GROUP BY pa.prontuarioatendimentoid
                    "
                );
                break;
            case 'auditado':
                $pacientes = $this->query(
                    " SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, pa.data_alta, pa.data_obito, ep.observacao, pa.data_entrada AS datacadastro, ep.auditado, ep.usuariocadastronome FROM prontuarioatendimento pa
                    LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
                    LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
                    WHERE pa.hospitalid $hospitalquery AND pa.local $localquery AND DATE_FORMAT(pa.data_entrada, '%Y-%m-%d') BETWEEN '$datainicio' AND '$datafim' AND ep.auditado = 1
                    GROUP BY pa.prontuarioatendimentoid
                    "
                );
                break;
            case 'naoauditado':
                $pacientes = $this->query(
                    " SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, pa.data_alta, pa.data_obito, ep.observacao, pa.data_entrada AS datacadastro, ep.auditado, ep.usuariocadastronome FROM prontuarioatendimento pa
                    LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
                    LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
                    WHERE pa.hospitalid $hospitalquery AND pa.local $localquery AND DATE_FORMAT(pa.data_entrada, '%Y-%m-%d') BETWEEN '$datainicio' AND '$datafim' AND ep.auditado = 0
                    GROUP BY pa.prontuarioatendimentoid
                    "
                );
                break;
            case 'ventilacao':
                $pacientes = $this->query(
                    " SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, pa.data_alta, pa.data_obito, ep.observacao, pa.data_entrada AS datacadastro, ep.auditado, ep.usuariocadastronome FROM prontuarioatendimento pa
                    LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
                    LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
                    WHERE pa.hospitalid $hospitalquery AND pa.local $localquery AND DATE_FORMAT(pa.data_entrada, '%Y-%m-%d') BETWEEN '$datainicio' AND '$datafim' AND pa.ventilacao = 1
                    GROUP BY pa.prontuarioatendimentoid
                    "
                );
                break;
            case 'alta':
                $pacientes = $this->query(
                    " SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, pa.data_alta, pa.data_obito, ep.observacao, pa.data_entrada AS datacadastro, ep.auditado, ep.usuariocadastronome FROM prontuarioatendimento pa
                    LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
                    LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
                    WHERE pa.hospitalid $hospitalquery AND pa.local $localquery AND DATE_FORMAT(pa.data_entrada, '%Y-%m-%d') BETWEEN '$datainicio' AND '$datafim' AND (pa.alta = 1 OR pa.obito = 1)
                    GROUP BY pa.prontuarioatendimentoid
                    "
                );
                break;
            case 'total':
                $pacientes = $this->query(
                    "SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, pa.data_alta, pa.data_obito, ep.observacao, pa.data_entrada AS datacadastro, ep.auditado, ep.usuariocadastronome FROM prontuarioatendimento pa
                    LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
                    LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
                    WHERE pa.alta = 0 AND pa.obito = 0 AND pa.hospitalid $hospitalquery AND pa.local $localquery
                    GROUP BY pa.prontuarioatendimentoid
                    "
                );
                break;
        }

        $hoje = Date("Y-m-d");
        $pacienteshoje = $this->query("SELECT COUNT(1) AS total FROM prontuarioatendimento pa WHERE CAST(data_entrada AS DATE) = '$hoje' AND pa.hospitalid $hospitalquery AND pa.local $localquery");
        $auditados = $this->query("SELECT COUNT(1) AS total FROM prontuarioatendimento pa INNER JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco) WHERE ep.auditado = 1 AND pa.hospitalid $hospitalquery AND pa.local $localquery AND CAST(pa.data_entrada AS DATE) BETWEEN '$datainicio' AND '$datafim'");
        $naoauditados = $this->query("SELECT COUNT(1) AS total FROM prontuarioatendimento pa INNER JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco) WHERE ep.auditado = 0 AND pa.hospitalid $hospitalquery AND pa.local $localquery AND CAST(pa.data_entrada AS DATE) BETWEEN '$datainicio' AND '$datafim'");
        $ventilacaomec = $this->query("SELECT COUNT(1) AS total FROM prontuarioatendimento pa WHERE ventilacao = 1 AND pa.hospitalid $hospitalquery AND pa.local $localquery AND CAST(pa.data_entrada AS DATE) BETWEEN '$datainicio' AND '$datafim'");
        $altas = $this->query("SELECT COUNT(1) AS total FROM prontuarioatendimento pa WHERE (alta = 1 OR obito = 1) AND pa.hospitalid $hospitalquery AND pa.local $localquery AND CAST(pa.data_entrada AS DATE) BETWEEN '$datainicio' AND '$datafim'");
        $geral = $this->query("SELECT COUNT(1) AS total FROM prontuarioatendimento pa WHERE alta = 0 AND obito = 0 AND pa.hospitalid $hospitalquery AND pa.local $localquery");

        $this->set(compact([
            'pacientes'
            ,'pacienteshoje'
            ,'auditados'
            ,'naoauditados'
            ,'ventilacaomec'
            ,'altas'
            ,'geral'
        ]));
    }

    public function modalauditoria($id) {
        $prontuario = $this->get('Prontuarioatendimento','prontuarioatendimentoid',$id);
        $prontuarioatendimentoid = $prontuario->prontuarioatendimentoid;
        $ultimaentrada = $this->get('Entradapacientes','entradapacientesid',$prontuario->entradapacienteid_gruporisco);
        $carteiracpf = $ultimaentrada->carteiracpf;
        $resumo = $this->getAllTableWhere('Entradapacientes',['prontuarioatendimentoid'=>$prontuario->prontuarioatendimentoid],['datacadastro DESC'])->all();
        $usuario = $this->sessionread('login.usuario');

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $auditoriaobservacoesTable = TableRegistry::get('Auditoriaobservacao');
            $auditoriaobservacao = $auditoriaobservacoesTable->newEntity();
            $auditoriaobservacao->entradapacientesid = $ultimaentrada->entradapacientesid;
            $auditoriaobservacao->observacao = $data['observacaoauditoria'];
            $auditoriaobservacao->usuarioidcadastro = $usuario->idusuario;
            $auditoriaobservacao->usuarionomecadastro = $usuario->nome;
            if ($auditoriaobservacoesTable->save($auditoriaobservacao)) {
                $this->Flash->success("Observação Cadastrada com Sucesso!");
                return $this->redirect(['action'=>'index']);
            }
        }
        $this->set(compact([
            'resumo'
            ,'carteiracpf'
            ,'prontuarioatendimentoid'
            ,'id'
        ]));
    }

    public function entradapacienteauditoria ($modal = null, $prontuarioatendimentoid = null, $edicao = null) {
        $modulos = $this->sessionread('login.modulos');
        $modulosuser = [];
        foreach ($modulos as $modulo) {
            array_push($modulosuser,$modulo->chave);
        }
        if (!in_array('hospital',$modulosuser)) {
            return $this->redirect($this->referer());
        }
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        $hospitais = $this->getAllTableWhere('Hospital',['hospitalid '.$hospitalquery]);
        $atendimento = TableRegistry::get('Prontuarioatendimento')->newEntity();
        $prontuario = TableRegistry::get('Prontuarioatendimento')->newEntity();
        $grupo_risco = [];
        $data_alta = '';
        $data_obito = '';
        $data_nascimento = '';
        $datacoleta = '';
        if ($prontuarioatendimentoid != null) {
            $prontuario = $this->get('Prontuarioatendimento','prontuarioatendimentoid',$prontuarioatendimentoid);
            $atendimento = $this->get('Entradapacientes', 'entradapacientesid', $prontuario->entradapacienteid_gruporisco);
            $grupo_risco2 = $this->getAllTableWhere('Paciente_gruporisco',['entradapacientesid'=>$atendimento->entradapacientesid],[]);
            foreach ($grupo_risco2 as $item) {
                array_push($grupo_risco, $item->gruporisco);
            }
            if ($atendimento->dataalta != null) {
                $data_alta = (get_object_vars($atendimento->dataalta)['date']);
                $data_alta = explode(" ", $data_alta);
                $data_alta = $data_alta[0];
            }
            if ($atendimento->datacoleta != null) {
                $datacoleta = (get_object_vars($atendimento->datacoleta)['date']);
                $datacoleta = explode(" ", $datacoleta);
                $datacoleta = $datacoleta[0];
            }
            if ($atendimento->dataobito != null) {
                $data_obito = (get_object_vars($atendimento->dataobito)['date']);
                $data_obito = explode(" ", $data_obito);
                $data_obito = $data_obito[0];
            }
            if ($prontuario->data_nascimento != null) {
                $data_nascimento = (get_object_vars($prontuario->data_nascimento)['date']);
                $data_nascimento = explode(" ", $data_nascimento);
                $data_nascimento = $data_nascimento[0];
            }
        }
        $this->set(compact([
            'perfil'
            ,'hospitais'
            ,'modal'
            ,'atendimento'
            ,'grupo_risco'
            ,'data_alta'
            ,'data_obito'
            ,'data_nascimento'
            ,'prontuario'
            ,'edicao'
            ,'datacoleta'
        ]));
    }
    
    public function relatorios() {
        
    }

}