<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use \stdClass;

/**
 * Dashboard Controller
 *
 *
 * @method \App\Model\Entity\Dashboard[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class BeneficiarioController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {      
        $listabeneficiarios = $this->queryjson('adm.beneficiario.listabeneficiarios',[]);
        /*
        $count = 0;
        foreach ($listabeneficiarios as $item) {
            if ($count > 80){
                $id = $item->COD_BENEFICIARIO;
                $diassempagarpormes = $this->queryjson('adm.beneficiario.pessoa.diassempagarpormes', [
                    'codbeneficiario'=>$id
                ]);           
                $graficolinha = $this->queryjson('adm.beneficiario.pessoa.mediatrimestral', [
                    'codbeneficiario'=>$id
                ]);
                $despesas = $this->queryjson('adm.beneficiario.pessoa.despesa', [
                    'codbeneficiario'=>$id
                ]);
                $pagos = $this->queryjson('adm.beneficiario.pessoa.pago', [
                    'codbeneficiario'=>$id
                ]);
                $resumo = $this->queryjson('adm.beneficiario.pessoa.resumotitulos',[
                        'codbeneficiario'=>$id
                ]);
                $endbeneficiario = $this->queryjson('adm.beneficiario.pessoa.enderecobeneficiario',[
                    'codbeneficiario'=>$id
                ]);
                $familias = $this->queryjson('adm.beneficiario.pessoa.familias',[
                    'codbeneficiario'=>$id
                ]);
                $permanencia = $this->queryjson('adm.beneficiario.pessoa.permanencia',[
                    'codbeneficiario'=>$id
                ]);
                $totalpago = $this->queryjson('adm.beneficiario.pessoa.totalpago',[
                    'codbeneficiario'=>$id
                ]);
                $totalgasto = $this->queryjson('adm.beneficiario.pessoa.totalgasto',[
                    'codbeneficiario'=>$id
                ]);
                $totalconsumido = $this->queryjson('adm.beneficiario.pessoa.consumototal',[
                    'codbeneficiario'=>$id
                ]);
            } $count++;
        }
        $this->d("executou?!");*/
        $mesAtual = -1;
        if(isset($_REQUEST['mes']) && $_REQUEST['mes'] !=-1){
            $mesAtual = $this->getMes();
        }
        
        if(!isset($_REQUEST['mes'])){
            $mesAtual = $this->getMes();
        }
        
        $anoAtual = $this->getAno();
        
        $resumoativospj = $this->queryjson('adm.beneficiario.resumoativospj',[
            'anoAtual'=>$anoAtual
            ,'mesAtual'=>$mesAtual
        ]);
        $resumoativospj = $resumoativospj[0];
        
        $teste_de_velocidade = $this->queryjson('adm.beneficiario.resumoativospj',[
            'anoAtual'=>$anoAtual
            ,'mesAtual'=>$mesAtual
        ]);
        
        $resumoativos = $this->queryjson('adm.beneficiario.resumoativospf',[
            'anoAtual'=>$anoAtual
            ,'mesAtual'=>$mesAtual
        ]);
        $resumoativos = $resumoativos[0];
        $resumoativos2 = $this->queryjson('adm.beneficiario.resumoativospf2',[
            'anoAtual'=>$anoAtual
            ,'mesAtual'=>$mesAtual
        ]);
        $resumoativos2 = $resumoativos2[0];
        
        $resumotitulos = $this->queryjson('adm.beneficiario.resumotitulos',[
            'anoAtual'=>$anoAtual
            ,'mesAtual'=>$mesAtual
        ]);
        $resumotitulos = $resumotitulos[0];
        
        //grafico de linha por ano
        $linhaativosporano = $this->queryjson('adm.beneficiario.ativosporano',[
            'anoAtual'=>$anoAtual
        ]);
        
        $serielinhaativosporano = $this->arrtoserie($linhaativosporano,['MES','ANOATUAL','ANOMENOS1','ANOMENOS2']);
        $mediaporano = 0;
        $mediaAnoAtual = 0;
        $mediaAnoMenos1 = 0;
        $mediaAnoMenos2 = 0;
        for($i=0;$i<=11;$i++){
            $mediaporano = $mediaporano + ($serielinhaativosporano['ANOATUAL'][$i]
                + $serielinhaativosporano['ANOMENOS1'][$i]
                + $serielinhaativosporano['ANOMENOS2'][$i]);
                
            $mediaAnoAtual  = $mediaAnoAtual + $serielinhaativosporano['ANOATUAL'][$i];
            $mediaAnoMenos1 = $mediaAnoMenos1 + $serielinhaativosporano['ANOMENOS1'][$i];
            $mediaAnoMenos2 = $mediaAnoMenos2 + $serielinhaativosporano['ANOMENOS2'][$i];
        }
        $mediaporano = round($mediaporano/36,2);
        $mediaporano = [$mediaporano,$mediaporano,$mediaporano,$mediaporano,$mediaporano,$mediaporano
                        ,$mediaporano,$mediaporano,$mediaporano,$mediaporano,$mediaporano,$mediaporano];
        
        $totalAnoAtual =$mediaAnoAtual ;
        $totalAnoMenos1=$mediaAnoMenos1;
        $totalAnoMenos2=$mediaAnoMenos2;
        
        $mediaAnoAtual = $mediaAnoAtual/12;
        $mediaAnoMenos1 = $mediaAnoMenos1/12;
        $mediaAnoMenos2 = $mediaAnoMenos2/12;
        
        $serielinhaativosporano['MEDIA'] = $mediaporano;
        $jsonlinhaativosporano = json_encode($serielinhaativosporano);
        
        
        //produto
        $resumoprodutos = $this->queryjson('adm.beneficiario.resumoprodutos',[
            'anoAtual'=>$anoAtual
            ,'mesAtual'=>$mesAtual
        ]);
        
        $this->set(compact(
        'resumotitulos'
        ,'resumoativos'
        ,'resumoativospj'
        ,'mesAtual'
        ,'anoAtual'
        ,'jsonlinhaativosporano'
        ,'mediaporano'
        ,'mediaAnoAtual' 
        ,'mediaAnoMenos1'
        ,'mediaAnoMenos2'
        ,'totalAnoAtual'
        ,'totalAnoMenos1'
        ,'totalAnoMenos2'
        ,'resumoprodutos'
        ,'resumoativos2'
        ));
    }
    
    public function buscar()
    {
        $busca = isset($_GET['busca'])?$_GET['busca']:null;
        $this->redirect(['action'=>'pessoa',$busca]);
    }



    public function graficos($id){
        $diassempagarpormes = $this->queryjson('adm.beneficiario.pessoa.diassempagarpormes', [
            'codbeneficiario'=>$id
        ]);
        //$diassempagarpormes2 = $this->arrtoserie($diassempagarpormes,['PRIMEIRO_TRIMESTRE','SEGUNDO_TRIMESTRE','TERCEIRO_TRIMESTRE','QUARTO_TRIMESTRE', 'YEAR']);
       
        $graficolinha = $this->queryjson('adm.beneficiario.pessoa.mediatrimestral', [
            'codbeneficiario'=>$id
        ]);
        $despesas = $this->queryjson('adm.beneficiario.pessoa.despesa', [
            'codbeneficiario'=>$id
        ]);
        $pagos = $this->queryjson('adm.beneficiario.pessoa.pago', [
            'codbeneficiario'=>$id
        ]);
        $periodos = [];
        for ($i = 0; $i < 3; $i++) {
            for ($j = 0; $j<12; $j++){
                $data = new stdClass();
                $data->ano = DATE('Y') - 2 + $i;
                $data->mes = $j+1;
                array_push($periodos,$data);
            }
        }
        $graficoanom2 = [];
        $graficoanom1 = [];
        $graficoanoatual = [];
        $acumanom2 = [];
        $acumanom1 = [];
        $acumanoatual = [];
        $somaanom2 = 0;
        $somaanom1 = 0;
        $somaanoatual = 0;
        $somatorio = 0;
        foreach ($periodos as $periodo){
            $FLAG = 0;
            $custo = 0;
            $receita = 0;
            foreach($despesas as $despesa){
                if($periodo->ano == $despesa->ANO && $periodo->mes == $despesa->MES){
                    $custo = $despesa->VALOR_TOTAL; break;
                } 
            }
            foreach($pagos as $pago){
                if($periodo->ano == $pago->ANO && $periodo->mes == $pago->MES){
                    $receita = $pago->VALOR_TOTAL; break;
                }
            }
            $obj = new stdClass();
            $obj2 = new stdClass();
            $obj->ano = $periodo->ano;
            $obj->mes = $periodo->mes;
            $obj->diff = $receita - $custo;
            $obj2->ano = $periodo->ano;
            $obj2->mes = $periodo->mes;
            $obj2->diff = $receita - $custo;
            if($periodo->ano == Date('Y')-2){
                $somaanom2 += $receita - $custo;
                array_push($graficoanom2,$obj);
                $obj2->diff = $somaanom2;
                array_push($acumanom2,$obj2);
            } else if ($periodo->ano == Date('Y')-1){
                $somaanom1 += $receita - $custo;
                array_push($graficoanom1,$obj);
                $obj2->diff = $somaanom1;
                array_push($acumanom1,$obj2);
            } else {
                $somaanoatual += $receita - $custo;
                array_push($graficoanoatual,$obj);
                $obj2->diff = $somaanoatual;
                array_push($acumanoatual,$obj2);
            }
            $somatorio += $receita - $custo;
        }
        $acummedia = [(($acumanoatual[0]->diff+$acumanom1[0]->diff+$acumanom2[0]->diff)/3),(($acumanoatual[1]->diff+$acumanom1[1]->diff+$acumanom2[1]->diff)/3),(($acumanoatual[2]->diff+$acumanom1[2]->diff+$acumanom2[2]->diff)/3),(($acumanoatual[3]->diff+$acumanom1[3]->diff+$acumanom2[3]->diff)/3),(($acumanoatual[4]->diff+$acumanom1[4]->diff+$acumanom2[4]->diff)/3),(($acumanoatual[5]->diff+$acumanom1[5]->diff+$acumanom2[5]->diff)/3),(($acumanoatual[6]->diff+$acumanom1[6]->diff+$acumanom2[6]->diff)/3),(($acumanoatual[7]->diff+$acumanom1[7]->diff+$acumanom2[7]->diff)/3),(($acumanoatual[8]->diff+$acumanom1[8]->diff+$acumanom2[8]->diff)/3),(($acumanoatual[9]->diff+$acumanom1[9]->diff+$acumanom2[9]->diff)/3),(($acumanoatual[10]->diff+$acumanom1[10]->diff+$acumanom2[10]->diff)/3),(($acumanoatual[11]->diff+$acumanom1[11]->diff+$acumanom2[11]->diff)/3)];
        $media = [round((($graficoanoatual[0]->diff+$graficoanom1[0]->diff+$graficoanom2[0]->diff)/3),2),round((($graficoanoatual[1]->diff+$graficoanom1[1]->diff+$graficoanom2[1]->diff)/3),2),round((($graficoanoatual[2]->diff+$graficoanom1[2]->diff+$graficoanom2[2]->diff)/3),2),round((($graficoanoatual[3]->diff+$graficoanom1[3]->diff+$graficoanom2[3]->diff)/3),2),round((($graficoanoatual[4]->diff+$graficoanom1[4]->diff+$graficoanom2[4]->diff)/3),2),round((($graficoanoatual[5]->diff+$graficoanom1[5]->diff+$graficoanom2[5]->diff)/3),2),round((($graficoanoatual[6]->diff+$graficoanom1[6]->diff+$graficoanom2[6]->diff)/3),2),round((($graficoanoatual[7]->diff+$graficoanom1[7]->diff+$graficoanom2[7]->diff)/3),2),round((($graficoanoatual[8]->diff+$graficoanom1[8]->diff+$graficoanom2[8]->diff)/3),2),round((($graficoanoatual[9]->diff+$graficoanom1[9]->diff+$graficoanom2[9]->diff)/3),2),round((($graficoanoatual[10]->diff+$graficoanom1[10]->diff+$graficoanom2[10]->diff)/3),2),round((($graficoanoatual[11]->diff+$graficoanom1[11]->diff+$graficoanom2[11]->diff)/3),2)];
        $this->set(compact('diassempagarpormes','acummedia','graficolinha','graficoanoatual','graficoanom1','graficoanom2','acumanoatual','acumanom1','acumanom2','media'));
    }

    public function pessoa($id=null)
    {   
        $resumo = $this->queryjson('adm.beneficiario.pessoa.resumotitulos',[
                'codbeneficiario'=>$id
            ]);
        $resumo = $resumo[0];
        $endbeneficiario = $this->queryjson('adm.beneficiario.pessoa.enderecobeneficiario',[
            'codbeneficiario'=>$id
        ]);
        $endbeneficiario = $endbeneficiario[0];
        $familias = $this->queryjson('adm.beneficiario.pessoa.familias',[
            'codbeneficiario'=>$id
        ]);
        $permanencia = $this->queryjson('adm.beneficiario.pessoa.permanencia',[
            'codbeneficiario'=>$id
        ]);
        $totalpago = $this->queryjson('adm.beneficiario.pessoa.totalpago',[
            'codbeneficiario'=>$id
        ]);
        foreach ($permanencia as $item){
            $item->PAGO = '-';
            $item->GASTO =  '-';
            $item->SINISTRALIDADE = '-';
            foreach ($totalpago as $resumopagamento){
                if($resumopagamento->COD_BENEFICIARIO == $item->COD_BENEFICIARIO && $resumopagamento->COD_CONTRATO == $item->COD_CONTRATO && $resumopagamento->COD_EMPRESA == $item->COD_EMPRESA 
                && $resumopagamento->COD_UNIMED == $item->COD_UNIMED && $resumopagamento->COD_FAMILIA == $item->COD_FAMILIA){
                    $item->PAGO = ($resumopagamento->TOTAL_PAGO) ? $resumopagamento->TOTAL_PAGO : '-';
                    $item->GASTO = ($resumopagamento->TOTAL_GASTO) ? $resumopagamento->TOTAL_GASTO : '-';
                    $item->SINISTRALIDADE = ($resumopagamento->TOTAL_GASTO) ? $resumopagamento->TOTAL_GASTO *100/ $resumopagamento->TOTAL_PAGO : '-';
                    break;
                }
            }
        }
        $totalgasto = $this->queryjson('adm.beneficiario.pessoa.totalgasto',[
            'codbeneficiario'=>$id
        ]);
        $totalconsumido = $this->queryjson('adm.beneficiario.pessoa.consumototal',[
            'codbeneficiario'=>$id
        ]);
        $this->set(compact('id','resumo','endbeneficiario','familias','permanencia','totalconsumido','totalpago'));
    }

    public function pessoaresumotitulo($num_doc){
        $resumo = $this->queryjson('adm.beneficiario.titulodetalhado',[
            'num_doc'=>$num_doc
        ]);
        $this->set([
            'resumo' => $resumo,
            '_serialize' => ['resumo'],
        ]);
        $this->RequestHandler->renderAs($this, 'json');
    }

    public function pessoatitulo($id=null)
    {
        $condicao = $_GET['tipo'];
        $media = 0;
        $count = 0;
        $sumdias = 0;
        $sumpag = 0;
        $sumconta = 0;
        $diff=0;
        if($condicao == 'aberto'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosemaberto',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumdias += round($item->DIAS);
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
            }
            $condicao2 = "em Aberto";

        } else if($condicao == 'atrasado'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosatrasados',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumdias += round($item->DIAS);
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
                $diff = $item->VALOR_PAGO - $item->VALOR_TOTAL;
            }
            $condicao2 = "Atrasados";

        } else if ($condicao == 'emdia'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosemdia',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
                $diff = $item->VALOR_PAGO - $item->VALOR_TOTAL;
            }
            $condicao2 = "em dia";

        } else if ($condicao == 'antecipado'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosantecipados',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumdias += round($item->DIAS);
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
                $diff = $item->VALOR_PAGO - $item->VALOR_TOTAL;
            }
            $condicao2 = "Antecipados";
        }
        $count = ($count == 0) ? 1 : $count;
        $media = $sumdias/$count;
        $mediapag = $sumpag/$count;
        $mediaconta = $sumconta/$count;
        foreach ($resumo as $item){
            $this->queryjson('adm.beneficiario.titulodetalhado',[
                'num_doc'=>$item->NUM_DOC
            ]);
        }
        $this->set(compact('id','resumo','condicao','condicao2','media','mediapag','mediaconta', 'diff'));
    }
}
