<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use \stdClass;
use Cake\Event\Event;

/**
 * Dashboard Controller
 *
 *
 * @method \App\Model\Entity\Dashboard[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class CarteiraController extends AppController
{
    public function beforeRender(Event $event) {
		$session = $this->request->session();
		$count = 0;
		foreach ($session->read('login.modulos') as $modulo) {
			if ($modulo->chave == 'carteira'){
				$count = 1;
				break;
			} 
		}
		if ($count == 0) {
			return $this->redirect($this->referer());	
		}
    }

    public function uploaddados(){
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            if (empty($data['File'][0]['name'])) {
                $this->Flash->error("Insira um arquivo para a importação.");
                return $this->redirect(['action'=>'uploaddados']);
            }
            if (explode('.',$data['File'][0]['name'])[1] != 'csv' && explode('.',$data['File'][0]['name'])[1    ] != 'CSV') {
                $this->Flash->error('Formato não suportado! Certifique-se de que o arquivo está no formato .csv');
                return $this->redirect(['action'=>'uploaddados']);
            }
            //upload:
            $nomearquivo = $data['File'][0]['name'];
            $this->upload($nomearquivo);
            $path = $this->getuploaddir().$nomearquivo;
			$conn = mysqli_connect('www.corpstek.com.br' 
				,'corpstek_tauamed'
				,'X;Ppj.2#9g46'
				,'corpstek_flymed_unimednatal') or die ("servidor não responde");
            $sql = "TRUNCATE TABLE carteiraconta3;";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));
            
            $sql = "ALTER TABLE carteiraconta3 CHANGE data_vencimento data_vencimento VARCHAR(40) NULL DEFAULT NULL; ";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $sql = "ALTER TABLE carteiraconta3 CHANGE data_recebimento data_recebimento VARCHAR(40) NULL DEFAULT NULL; ";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $sql = "
            LOAD DATA LOCAL INFILE \"$path\" 
            INTO TABLE carteiraconta3 FIELDS TERMINATED BY ';' OPTIONALLY ENCLOSED BY '\"'
            LINES TERMINATED BY '\r\n' IGNORE 1 LINES
            (`ano_fatura`, `mes_fatura`, `numero_fatura`, `cod_empresa`, `nome_fantasia`, `cgc_empresa`, `data_vencimento`, @faturado,`data_recebimento`,@recebido,`cod_local_receb`, `desc_local_pgto`)
            
            SET valor_faturado =  REPLACE(REPLACE(@faturado,'.',''), ',','.'),
            valor_recebido = REPLACE(REPLACE(@recebido,'.',''), ',','.');
            ";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $sql = "UPDATE carteiraconta3 SET data_vencimento = STR_TO_DATE(data_vencimento,'%d/%m/%y');";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $sql = "UPDATE carteiraconta3 SET data_recebimento = STR_TO_DATE(data_recebimento,'%d/%m/%y');";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $sql = "ALTER TABLE `carteiraconta3` CHANGE `data_recebimento` `data_recebimento` DATE NULL DEFAULT NULL; ";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

            $sql = "ALTER TABLE `carteiraconta3` CHANGE `data_vencimento` `data_vencimento` DATE NULL DEFAULT NULL;";
            $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));
            

			try{$this->query($sql);}catch(\Exception $ex){}
        }

        $ultimaimportacao = $this->get('Parametro', 'chave', 'atualizacao_carteira');
        
        $this->set(compact([
            'ultimaimportacao'
        ]));
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $pf = $this->query("SELECT COUNT(1) AS total FROM (SELECT * FROM `carteiraconta2` WHERE LENGTH(cgc_empresa) < 12) dummy");
        $pj = $this->query("SELECT COUNT(1) AS total FROM (SELECT cgc_empresa FROM `carteiraconta2` WHERE LENGTH(cgc_empresa) >= 12 GROUP BY 1) dummy");
        $pf = $pf[0]->total;
        $pj = $pj[0]->total;
        $sql = "SELECT DISTINCT cgc_empresa
        FROM empresacarteira";
        $sql5 = "SELECT DISTINCT cgc_empresa, cod_contrato
        FROM carteiraconta WHERE status_contrato = 'ATIVO'";
        $anoAtual = Date('Y');
        $mesAtual = Date('m');
        $sql3 = "SELECT SUM(qtde_vidas_contrato) AS benef FROM (SELECT cgc_empresa, SUM(qtde_vidas_contrato) AS qtde_vidas_contrato FROM (SELECT * FROM carteiraconta WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cgc_empresa, cod_contrato) A GROUP BY cgc_empresa) A";

        $empresas_ativas = count($this->query($sql));
        $totalativo = count($this->query($sql5));
        $benef_ativos = $this->query($sql3)[0]->benef;
        $ticket_medio = $this->query("SELECT SUM(total)/count(1) AS ticket_medio FROM (SELECT cod_empresa, SUM(valor) AS total FROM `carteiraconta` WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(`periodo_faturamento`, '%Y/%m') = '$anoAtual/$mesAtual'
        GROUP BY 1) A")[0]->ticket_medio;
        $media_pessoas = $benef_ativos/$empresas_ativas;

        $graficoempresa_secao = $this->query("SELECT cd.nm_secao, COUNT(DISTINCT cod_empresa) AS qtdempresa FROM empresacarteira ec INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = ec.cgc_empresa) INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal) GROUP BY cd.cod_secao ORDER BY 2 DESC");
        $graficobenef_secao = $this->query("SELECT cd.nm_secao, SUM(qtd.qtde_vidas_contrato) AS pessoas_plano FROM (SELECT cgc_empresa, SUM(qtde_vidas_contrato) AS qtde_vidas_contrato FROM (SELECT * FROM carteiraconta WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cgc_empresa, cod_contrato) A GROUP BY cgc_empresa) qtd INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = qtd.cgc_empresa) INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal) GROUP BY cd.cod_secao ORDER BY 2 DESC");
        $graficofatu_secao = $this->query("SELECT cd.nm_secao, SUM(cc.valor) AS faturamento FROM carteiraconta cc INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = cc.cgc_empresa) INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal) WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cd.cod_secao ORDER BY 2 DESC");
        $array_secaoemp = [];
        $array_secaobenef = [];
        $array_secaofatu = [];
        $qtdempresasecao = [];
        $pessoasplanosecao = [];
        $faturamentosecao = [];
        foreach ($graficoempresa_secao as $item) {
            array_push($array_secaoemp,$item->nm_secao);
            array_push($qtdempresasecao,$item->qtdempresa);
        }
        foreach ($graficobenef_secao as $item) {
            array_push($array_secaobenef,$item->nm_secao);
            array_push($pessoasplanosecao,$item->pessoas_plano);
        }
        foreach ($graficofatu_secao as $item) {
            array_push($array_secaofatu,$item->nm_secao);
            array_push($faturamentosecao,$item->faturamento);
        }

        $graficoempresa_setor = $this->query("SELECT c.setor, COUNT(DISTINCT cgc_empresa) AS qtdempresa FROM empresacarteira ec INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = ec.cgc_empresa) INNER JOIN setor_cnae sc ON (sc.cnae_fiscal = ecnae.cnae_fiscal) INNER JOIN carteira c ON (c.cnae_fiscal = sc.cnae_fiscal) GROUP BY c.setor ORDER BY 2 DESC");
        $graficobenef_setor = $this->query("SELECT c.setor, 0 AS pessoas_plano FROM (SELECT cgc_empresa, 0 AS qtde_vidas_contrato FROM (SELECT * FROM carteiraconta WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cgc_empresa, cod_contrato) A GROUP BY cgc_empresa) qtd INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = qtd.cgc_empresa) INNER JOIN setor_cnae sc ON (sc.cnae_fiscal = ecnae.cnae_fiscal) INNER JOIN carteira c ON (c.cnae_fiscal = sc.cnae_fiscal) GROUP BY c.setor ORDER BY 2 DESC");
        $graficofatu_setor = $this->query("SELECT c.setor, SUM(cc.valor) AS faturamento FROM carteiraconta cc INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = cc.cgc_empresa) INNER JOIN (SELECT cnae_fiscal, setor FROM carteira GROUP BY 1) c ON (c.cnae_fiscal = ecnae.cnae_fiscal) WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '2020-06' GROUP BY c.setor ORDER BY 2 DESC");        
        $array_setor = [];
        
        $qtdempresasetor = [];
        $pessoasplanosetor = [];
        $faturamentosetor = [];
        $array_setoremp = [];
        $array_setorbenef = [];
        $array_setorfatu = [];
        foreach ($graficoempresa_setor as $item) {
            array_push($array_setoremp,$item->setor);
            array_push($qtdempresasetor,[$item->qtdempresa, $item->setor]);
        }
        foreach ($graficobenef_setor as $item) {
            array_push($array_setorbenef,$item->setor);
            array_push($pessoasplanosetor,[$item->pessoas_plano, $item->setor]);
        }
        foreach ($graficofatu_setor as $item) {
            array_push($array_setorfatu,$item->setor);
            array_push($faturamentosetor,[$item->faturamento, $item->setor]);
        }

        $cores = ['Baixo'=>'#ca8622','ND'=>'#c4ccd3','Alto'=>'#2f4554','Médio'=>'#6e7074'];

        $secoes = $this->query("SELECT nm_secao, cod_secao FROM cnae_dados GROUP BY 1,2");

        $contasportador = $this->query("SELECT desc_local_pgto, SUM(valor_faturado) AS valor_faturado, SUM(valor_recebido) AS recebido, COUNT(DISTINCT cgc_empresa) AS interessados, COUNT(1) AS contas FROM (SELECT desc_local_pgto, valor_faturado, SUM(valor_recebido) AS valor_recebido, cgc_empresa FROM carteiraconta2 GROUP BY numero_fatura, desc_local_pgto) A GROUP BY 1 ");

        $contasmes = $this->query("SELECT CASE WHEN a.valor_faturado > a.recebido AND a.recebido > 0 THEN 'Pago Parcial' WHEN a.valor_faturado = a.recebido THEN 'Pago Integral' WHEN a.valor_faturado < a.recebido THEN 'Pago com Juros' WHEN a.recebido = 0 THEN 'Não Pago' ELSE 'ERRO' END AS situacao, 

        SUM(CASE WHEN a.recebido = 0 AND a.mes_fatura = 1 THEN a.valor_faturado WHEN a.recebido > 0 AND a.mes_fatura = 1 THEN a.recebido ELSE 0 END) AS jan, 
        
        SUM(CASE WHEN a.recebido = 0 AND a.mes_fatura = 2 THEN a.valor_faturado WHEN a.recebido > 0 AND a.mes_fatura = 2 THEN a.recebido ELSE 0 END) AS fev, 
        
        SUM(CASE WHEN a.recebido = 0 AND a.mes_fatura = 3 THEN a.valor_faturado WHEN a.recebido > 0 AND a.mes_fatura = 3 THEN a.recebido ELSE 0 END) AS mar, 
        
        SUM(CASE WHEN a.recebido = 0 AND a.mes_fatura = 4 THEN a.valor_faturado WHEN a.recebido > 0 AND a.mes_fatura = 4 THEN a.recebido ELSE 0 END) AS abr, 
        
        SUM(CASE WHEN a.recebido = 0 AND a.mes_fatura = 5 THEN a.valor_faturado WHEN a.recebido > 0 AND a.mes_fatura = 5 THEN a.recebido ELSE 0 END) AS mai, 
        
        SUM(CASE WHEN a.recebido = 0 AND a.mes_fatura = 6 THEN a.valor_faturado WHEN a.recebido > 0 AND a.mes_fatura = 6 THEN a.recebido ELSE 0 END) AS jun,

        SUM(CASE WHEN a.recebido = 0 AND a.mes_fatura = 7 THEN a.valor_faturado WHEN a.recebido > 0 AND a.mes_fatura = 7 THEN a.recebido ELSE 0 END) AS jul
        
        FROM ( 
        SELECT `ano_fatura`, `mes_fatura`, `numero_fatura`, `valor_faturado`, SUM(`valor_recebido`) AS recebido FROM carteiraconta2 WHERE ano_fatura = 2020 GROUP BY numero_fatura, mes_fatura) 
        
        a GROUP BY 1 ");

        $contasnomemes = $this->query("SELECT nome_fantasia,

        SUM(CASE WHEN a.mes_fatura = 1 THEN a.recebido ELSE 0 END) AS jan, 
        
        SUM(CASE WHEN a.mes_fatura = 2 THEN a.recebido ELSE 0 END) AS fev, 
        
        SUM(CASE WHEN a.mes_fatura = 3 THEN a.recebido ELSE 0 END) AS mar, 
        
        SUM(CASE WHEN a.mes_fatura = 4 THEN a.recebido ELSE 0 END) AS abr, 
        
        SUM(CASE WHEN a.mes_fatura = 5 THEN a.recebido ELSE 0 END) AS mai, 
        
        SUM(CASE WHEN a.mes_fatura = 6 THEN a.recebido ELSE 0 END) AS jun,

        SUM(CASE WHEN a.mes_fatura = 7 THEN a.recebido ELSE 0 END) AS jul
        
        FROM ( 
        SELECT nome_fantasia, `ano_fatura`, `mes_fatura`, `numero_fatura`, `valor_faturado`, SUM(`valor_recebido`) AS recebido FROM carteiraconta2 WHERE ano_fatura = 2020 GROUP BY numero_fatura, mes_fatura, nome_fantasia) 
        
        a GROUP BY 1");

$empresa0 = $this->query("SELECT COUNT(1) AS boletos, COUNT(DISTINCT cgc_empresa) AS empresas, SUM(recebido) AS total FROM (SELECT cc.nome_fantasia, cc.cgc_empresa, cc.numero_fatura, cc.desc_local_pgto,
cc.data_vencimento, cc.data_recebimento, DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento) AS diasatraso, cc.valor_faturado, SUM(cc.valor_recebido) AS recebido, COALESCE(boletos.boletos_atrasados,0)AS boletos_atrasados

FROM carteiraconta2 cc

LEFT JOIN (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados 

FROM carteiraconta2 

WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                
GROUP BY 1) boletos ON (boletos.cgc_empresa = cc.cgc_empresa)
                
WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados IS NULL
                
GROUP BY 1,2
) A");

$empresa1a2 = $this->query("SELECT COUNT(DISTINCT cgc_empresa) AS empresas, SUM(boletos_atrasados) AS boletos, SUM(valor) AS total FROM (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados, SUM(valor_faturado) AS valor 
        
FROM carteiraconta2 

WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE 
GROUP BY 1
HAVING count(1) <= 2 AND count(1) > 0) A");
$empresa2a4 = $this->query("SELECT COUNT(DISTINCT cgc_empresa) AS empresas, SUM(boletos_atrasados) AS boletos, SUM(valor) AS total FROM (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados, SUM(valor_faturado) AS valor 
        
FROM carteiraconta2 

WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE 
GROUP BY 1
HAVING COUNT(1) > 2 AND COUNT(1) <= 4) A");
$empresa4p = $this->query("SELECT COUNT(DISTINCT cgc_empresa) AS empresas, SUM(boletos_atrasados) AS boletos, SUM(valor) AS total FROM (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados, SUM(valor_faturado) AS valor 
        
FROM carteiraconta2 

WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE 
GROUP BY 1
HAVING count(1) > 4) A");
        $this->set(compact(
            'mesAtual'
            ,'secoes'
            ,'anoAtual'
            ,'setorescovid'
            ,'empresas_ativas'
            ,'benef_ativos'
            ,'ticket_medio'
            ,'media_pessoas'
            ,'graficonm_secao'
            ,'array_secaoemp'
            ,'array_secaobenef'
            ,'array_secaofatu'
            ,'qtdempresasecao'
            ,'pessoasplanosecao'
            ,'faturamentosecao'
            ,'array_setor'
            ,'qtdempresasetor'
            ,'pessoasplanosetor'
            ,'faturamentosetor'
            ,'totalativo'
            ,'cores'
            ,'array_setoremp'
            ,'array_setorbenef'
            ,'array_setorfatu'
            ,'contasportador'
            ,'contasempresa'
            ,'contasmes'
            ,'contasnomemes'
            ,'empresa1a2'
            ,'empresa2a4'
            ,'empresa4p'
            ,'empresa0'
            ,'pf'
            ,'pj'
        ));
    }

    public function empresamodal($key) {
        $error = false;
        switch ($key) {
            case 0:
                $contasempresa = $this->query("SELECT cc.nome_fantasia, cc.numero_fatura, cc.cgc_empresa, cc.desc_local_pgto,
                cc.data_vencimento, cc.data_recebimento, DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento) AS diasatraso, cc.valor_faturado, SUM(cc.valor_recebido) AS recebido, COALESCE(boletos.boletos_atrasados,0)AS boletos_atrasados
                
                FROM carteiraconta2 cc
                
                LEFT JOIN (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                                
                GROUP BY 1) boletos ON (boletos.cgc_empresa = cc.cgc_empresa)
                                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados IS NULL
                                
                GROUP BY 1,2
                ORDER BY 1");
                $contasempresaagrupado = $this->query("SELECT cc.cgc_empresa, cc.nome_fantasia,
                MAX(DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento)) AS diasatraso, SUM(cc.valor_faturado) AS valor_faturado, SUM(cc.valor_recebido) AS recebido, SUM(COALESCE(boletos.boletos_atrasados,0)) AS boletos_atrasados
                
                FROM carteiraconta2 cc
                
                LEFT JOIN (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                                
                GROUP BY 1) boletos ON (boletos.cgc_empresa = cc.cgc_empresa)
                                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados IS NULL
                                
                GROUP BY 1
                ORDER BY 1");
                $title = "Empresas de 2020 com Nenhum Boleto em Aberto (Agrupado)";
                $title2 = "Empresas de 2020 com Nenhum Boleto em Aberto";
                break;
            case 1:
                $contasempresa = $this->query("SELECT cc.nome_fantasia, cc.numero_fatura, cc.cgc_empresa, cc.desc_local_pgto,
                cc.data_vencimento, cc.data_recebimento, DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento) AS diasatraso, 
                cc.valor_faturado, SUM(cc.valor_recebido) AS recebido

                FROM carteiraconta2 cc
                
                INNER JOIN (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1) boletos ON (boletos.cgc_empresa = cc.cgc_empresa)
                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados <= 2 AND cc.valor_recebido = 0 AND CAST(cc.data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1,2
                
                ORDER BY 1");
                $contasempresaagrupado = $this->query("SELECT cc.cgc_empresa, cc.nome_fantasia,
                MAX(DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento)) AS diasatraso, 
                SUM(cc.valor_faturado) AS valor_faturado, SUM(cc.valor_recebido) AS recebido

                FROM carteiraconta2 cc
                
                INNER JOIN (SELECT cgc_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1) boletos ON (boletos.cgc_empresa = cc.cgc_empresa)
                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados <= 2 AND cc.valor_recebido = 0 AND CAST(cc.data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1
                
                ORDER BY 1");
                $title = "Empresas de 2020 1 ou 2 Boletos em Aberto (Agrupado)";
                $title2 = "Empresas de 2020 1 ou 2 Boletos em Aberto";
                break;
            case 2:
                $contasempresa = $this->query("SELECT cc.nome_fantasia, cc.numero_fatura, cc.cgc_empresa, cc.desc_local_pgto,cc.data_vencimento, cc.data_recebimento, DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento) AS diasatraso, cc.valor_faturado, SUM(cc.valor_recebido) AS recebido

                FROM carteiraconta2 cc
                
                INNER JOIN (SELECT cod_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1) boletos ON (boletos.cod_empresa = cc.cod_empresa)
                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados <= 4 AND boletos.boletos_atrasados > 2 AND cc.valor_recebido = 0 AND CAST(cc.data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1,2
                
                ORDER BY 1");
                $contasempresaagrupado = $this->query("SELECT cc.cgc_empresa, cc.nome_fantasia, 
                MAX(DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento)) AS diasatraso,
                SUM(cc.valor_faturado) AS valor_faturado, SUM(cc.valor_recebido) AS recebido

                FROM carteiraconta2 cc
                
                INNER JOIN (SELECT cod_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1) boletos ON (boletos.cod_empresa = cc.cod_empresa)
                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados <= 4 AND boletos.boletos_atrasados > 2 AND cc.valor_recebido = 0 AND CAST(cc.data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1
                
                ORDER BY 1");
                $title = "Empresas de 2020 Entre 2 e 4 Boletos em Aberto (Agrupado)";
                $title2 = "Empresas de 2020 Entre 2 e 4 Boletos em Aberto";
                break;
            case 3:
                $contasempresa = $this->query("SELECT cc.cgc_empresa, cc.numero_fatura, cc.nome_fantasia, cc.desc_local_pgto,cc.data_vencimento, cc.data_recebimento, DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento) AS diasatraso, cc.valor_faturado, SUM(cc.valor_recebido) AS recebido

                FROM carteiraconta2 cc
                
                INNER JOIN (SELECT cod_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1) boletos ON (boletos.cod_empresa = cc.cod_empresa)
                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados > 4 AND cc.valor_recebido = 0 AND CAST(cc.data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1,2
                
                ORDER BY 1");
                $contasempresaagrupado = $this->query("SELECT cc.cgc_empresa, cc.nome_fantasia, 
                MAX(DATEDIFF(COALESCE(cc.data_recebimento, CURRENT_DATE),cc.data_vencimento)) AS diasatraso,
                SUM(cc.valor_faturado) AS valor_faturado, SUM(cc.valor_recebido) AS recebido

                FROM carteiraconta2 cc
                
                INNER JOIN (SELECT cod_empresa, COUNT(1) AS boletos_atrasados 
                
                FROM carteiraconta2 
                
                WHERE ano_fatura = 2020 AND valor_recebido = 0 AND CAST(data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1) boletos ON (boletos.cod_empresa = cc.cod_empresa)
                
                WHERE cc.ano_fatura = 2020 AND boletos.boletos_atrasados > 4 AND cc.valor_recebido = 0 AND CAST(cc.data_vencimento AS DATE) < CURRENT_DATE
                
                GROUP BY 1
                
                ORDER BY 1");
                $title = "Empresas de 2020 com Mais de 4 Boletos em Aberto (Agrupado)";
                $title2 = "Empresas de 2020 com Mais de 4 Boletos em Aberto";
                break;
            default:
                $error = true;
        }
        $this->set(compact([
            'contasempresa'
            ,'contasempresaagrupado'
            ,'title'
            ,'title2'
        ]));
    }

    public function tabelasecao($cod_secao) {
        $arraysecoes = explode(',',$cod_secao);
        $secoes = implode("','",$arraysecoes);
        $anoAtual = Date('Y');
        $mesAtual = '07';
        if (in_array('todas',$arraysecoes)) {
            $sql = "SELECT 
            cd.cod_secao, cd.nm_secao, COUNT(DISTINCT cc.cgc_empresa) AS responsavel_financeiro, 0 AS qtd_pessoas_plano, 
            SUM(cc.valor)/COUNT(DISTINCT cc.cgc_empresa) AS ticket_medio_empresa,0 AS ticket_medio_beneficiario, SUM(cc.valor) AS valor_total
                                   
            FROM (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual GROUP BY cc.cgc_empresa) cc
            
            INNER JOIN empresa_cnae ecnae ON (cc.cgc_empresa = ecnae.cnpj)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
    
            GROUP BY cd.cod_secao";
            $tabelasecao = $this->query($sql);
            $sql = "SELECT 
            ec.cgc_empresa, ec.razao_social, cd.cod_divisao, cd.nm_divisao, 0 AS qtd_pessoas_plano, 
            0 AS ticket_medio_beneficiario, cc.valor AS valor_total
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
                        
            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ec.cgc_empresa = ecnae.cnpj)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
    
            GROUP BY 1";
            $tabelaempresas = $this->query($sql);
            $secao = 'todos';
        } else {
            $sql = "SELECT 
            cd.cod_secao, cd.nm_secao, COUNT(DISTINCT ec.cgc_empresa) AS responsavel_financeiro, 0 AS qtd_pessoas_plano, 
            0 AS ticket_medio_empresa, 0 AS ticket_medio_beneficiario, SUM(cc.valor) AS valor_total
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
                        
            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ec.cgc_empresa = ecnae.cnpj)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
    
            WHERE cd.cod_secao IN ('$secoes')
    
            GROUP BY cd.cod_secao";
            $tabelasecao = $this->query($sql);

            $sql = "SELECT 
            ec.cgc_empresa, ec.razao_social, cd.cod_divisao, cd.nm_divisao, 0 AS qtd_pessoas_plano, 
            0 AS ticket_medio_beneficiario, cc.valor AS valor_total
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
                        
            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ec.cgc_empresa = ecnae.cnpj)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
    
            WHERE cd.cod_secao IN ('$secoes')
    
            GROUP BY 1";
            $tabelaempresas = $this->query($sql);
        }

        $totalvalor = 0;
        foreach ($tabelasecao as $item) {
            $totalvalor += $item->valor_total;
        }
        $usuario = $this->sessionread('login.usuario');
        $empresa = $this->sessionread('login.empresa');
        $usuario = $usuario->nome;
        $this->set(compact([
            'tabelasecao'
            ,'totalvalor'
            ,'empresa'
            ,'usuario'
            ,'cod_secao'
            ,'tabelaempresas'
        ]));
    }

    public function filtrosmodaldivisao($cod_secao, $cod_divisao, $cod_grupo = null) {
        $cod_divisao = explode(',', $cod_divisao);
        if (in_array('todas',$cod_divisao)) {
            $divisaoquery = "LIKE '%'";
        } else {
            $divisaoquery = "IN ('".implode("','", $cod_grupo)."')";
        }
        if ($cod_grupo == null) {
            $cod_grupo = explode(',', $cod_grupo);
            if (in_array('todos',$cod_grupo)) {
                $grupoquery = "LIKE '%'";
            } else {
                $grupoquery = "IN ('".implode("','", $cod_grupo)."')";
            }
        } else {
            $grupoquery = "LIKE '%'";
        }
        $grupos = $this->query("SELECT DISTINCT cod_grupo, nm_grupo FROM cnae_dados WHERE cod_secao = '$cod_secao' AND cod_divisao $divisaoquery");
        $classes = $this->query("SELECT DISTINCT cod_classe, nm_classe FROM cnae_dados WHERE cod_secao = '$cod_secao' AND cod_divisao $divisaoquery AND cod_grupo $grupoquery");
       
        $this->set(compact([
            'grupos'
            ,'classes'
        ]));
    }

    public function tabelamodaldivisao($cod_secao, $cod_divisao, $cod_grupo, $cod_classe, $impacto) {
        $cod_divisao = explode(',',$cod_divisao);
        $cod_grupo = explode(',',$cod_grupo);
        $cod_classe = explode(',',$cod_classe);
        $impacto = explode(',',$impacto);
        $anoAtual = Date('Y');
        $mesAtual = '07';
        $divisaoquery = (in_array('todas', $cod_divisao)) ? '' : 'AND cd.cod_divisao IN (\''.implode("','",$cod_divisao).'\')';
        $grupoquery = (in_array('todos', $cod_grupo)) ? '' : 'AND cd.cod_grupo IN (\''.implode("','",$cod_grupo).'\')';
        $classequery = (in_array('todas', $cod_classe)) ? '' : 'AND cd.cod_classe IN (\''.implode("','",$cod_classe).'\')';
        $impactoquery = (in_array('todas', $impacto)) ? '' : 'AND c.setor IN (\''.implode("','",$impacto).'\')';
        $sql = "SELECT 
            cd.cod_divisao, cd.nm_divisao, COUNT(DISTINCT ec.cgc_empresa) AS responsavel_financeiro, 0 AS qtd_pessoas_plano, 
            SUM(cc.valor)/COUNT(DISTINCT ec.cgc_empresa) AS ticket_medio_empresa, SUM(COALESCE(cca.boletos_atrasados,0)) AS boletos_atrasados, 0 AS ticket_medio_beneficiario, SUM(cc.valor) AS valor_total, SUM(cca.valor) AS valor_aberto, SUM(cc.boletos) AS boletos
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
            
            LEFT JOIN (SELECT TRIM(LEADING 0 FROM responsavel_financeiro) AS cnpj, setor FROM carteira GROUP BY 1) c ON (c.cnpj = TRIM(LEADING 0 FROM ec.cgc_empresa))

            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor, COUNT(DISTINCT numero_fatura) AS boletos FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)

            LEFT JOIN (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor, COUNT(DISTINCT numero_fatura) AS boletos_atrasados FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual AND (cc.valor_recebido = 0 AND cc.data_vencimento < CURRENT_DATE) GROUP BY cc.cgc_empresa) cca ON (cca.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ec.cgc_empresa = ecnae.cnpj)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)

            WHERE cd.cod_secao = '$cod_secao' $divisaoquery $grupoquery $classequery $impactoquery

            GROUP BY cd.cod_divisao
        ";
        $modaldivisao = $this->query($sql);
        $sql = "SELECT 
        COALESCE(c.setor, 'ND') AS setor, ec.cgc_empresa, ec.razao_social, COALESCE(cca.boletos_atrasados,0) AS boletos_atrasados, cd.nm_divisao, cd.nm_grupo, cd.nm_classe, cd.nm_cnae, 0 AS qtd_pessoas_plano, 0 AS ticket_medio, SUM(cc.valor) AS valor_total, SUM(cca.valor) AS valor_aberto, SUM(cc.boletos) AS boletos
        
        FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec

        LEFT JOIN (SELECT TRIM(LEADING 0 FROM responsavel_financeiro) AS cnpj, setor FROM carteira GROUP BY 1) c ON (c.cnpj = TRIM(LEADING 0 FROM ec.cgc_empresa))

        INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor, COUNT(DISTINCT numero_fatura) AS boletos FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)

        LEFT JOIN (SELECT cc.cgc_empresa, SUM(cc.valor_faturado) AS valor, COUNT(DISTINCT numero_fatura) AS boletos_atrasados FROM carteiraconta2 cc WHERE ano_fatura = $anoAtual AND mes_fatura = $mesAtual AND (cc.valor_recebido = 0 AND cc.data_vencimento < CURRENT_DATE) GROUP BY cc.cgc_empresa) cca ON (cca.cgc_empresa = ec.cgc_empresa)
        
        INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = ec.cgc_empresa)
        
        INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
        
        WHERE cod_secao = '$cod_secao' $divisaoquery $grupoquery $classequery $impactoquery
        
        GROUP BY ec.cgc_empresa
        ";
        $modalempresadivisao = $this->query($sql);
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $usuario = $usuario->nome;
        $ticket_medio = 0;
        $sum_ticketmedio = 0;
        $qtd_empresas = 0;
        $qtd_individuos = 0;
        $total = 0;
        $totalvalor = 0;
        foreach ($modalempresadivisao as $item) {
            $total += $item->valor_total;
            $sum_ticketmedio += $item->ticket_medio;
            $qtd_empresas += 1;
            $qtd_individuos += $item->qtd_pessoas_plano;
            $totalvalor += $item->valor_total;
        }
        $ticket_medio = ($qtd_individuos == 0) ? 0 : $totalvalor/$qtd_individuos;
        $ticket_medioemp = ($qtd_empresas == 0) ? 0 : $totalvalor/$qtd_empresas;
        $secao = $this->get("Cnae_dados",'cod_secao',$cod_secao)->nm_secao;
        
        $this->set(compact(
            'modaldivisao'
            ,'cod_secao'
            ,'modalempresadivisao'
            ,'secao'
            ,'qtd_empresas'
            ,'qtd_individuos'
            ,'total'
            ,'ticket_medio'
            ,'usuario'
            ,'totalvalor'
            ,'empresa'
            ,'ticket_medioemp'
        ));
    }

    public function modaldivisao($cod_secao) {
        $divisoes = $this->query("SELECT DISTINCT cod_divisao, nm_divisao FROM cnae_dados WHERE cod_secao = '$cod_secao'");
        $grupos = $this->query("SELECT DISTINCT cod_grupo, nm_grupo FROM cnae_dados WHERE cod_secao = '$cod_secao'");
        $classes = $this->query("SELECT DISTINCT cod_classe, nm_classe FROM cnae_dados WHERE cod_secao = '$cod_secao'");
        $secao = $this->get("Cnae_dados",'cod_secao',$cod_secao)->nm_secao;

        $this->set(compact(
            'cod_secao'
            ,'secao'
            ,'divisoes'
            ,'grupos'
            ,'classes'
        ));
    }

    public function tabelacores($cor) {
        $anoAtual = Date('Y');
        $mesAtual = Date('m');
        if ($cor == 'GERAL') {
            $sql = "SELECT 
            cod_secao, nm_secao, COUNT(DISTINCT ec.cgc_empresa) AS responsavel_financeiro, SUM(qtd.qtde_vidas_contrato) AS qtd_pessoas_plano, 
            SUM(cc.valor)/COUNT(DISTINCT ec.cgc_empresa) AS ticket_medio_empresa, SUM(cc.valor)/SUM(qtd.qtde_vidas_contrato) AS ticket_medio_beneficiario, SUM(cc.valor) AS valor_total
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
            
            INNER JOIN (SELECT cgc_empresa, SUM(qtde_vidas_contrato) AS qtde_vidas_contrato FROM (SELECT * FROM carteiraconta WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cgc_empresa, cod_contrato) A GROUP BY cgc_empresa) qtd ON (qtd.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor) AS valor FROM carteiraconta cc WHERE cc.status_contrato = 'ATIVO' AND DATE_FORMAT(cc.periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ec.cgc_empresa = ecnae.cnpj)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)

            GROUP by cod_secao";
            $setorescovid = $this->query($sql);
        } else {
            $sql = "SELECT 
            cod_secao, nm_secao, COUNT(DISTINCT ec.cgc_empresa) AS responsavel_financeiro, SUM(qtd.qtde_vidas_contrato) AS qtd_pessoas_plano, 
            SUM(cc.valor)/COUNT(DISTINCT ec.cgc_empresa) AS ticket_medio_empresa, SUM(cc.valor)/SUM(qtd.qtde_vidas_contrato) AS ticket_medio_beneficiario, SUM(cc.valor) AS valor_total
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
            
            INNER JOIN (SELECT cgc_empresa, SUM(qtde_vidas_contrato) AS qtde_vidas_contrato FROM (SELECT * FROM carteiraconta WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cgc_empresa, cod_contrato) A GROUP BY cgc_empresa) qtd ON (qtd.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor) AS valor FROM carteiraconta cc WHERE cc.status_contrato = 'ATIVO' AND DATE_FORMAT(cc.periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ec.cgc_empresa = ecnae.cnpj)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
            
            INNER JOIN setor_cnae sc ON (sc.cnae_fiscal = cd.cod_cnae)

            WHERE upper(setor) = UPPER('$cor') 

            GROUP by cod_secao";
            $setorescovid = $this->query($sql);
        }
        $totalvalor = 0;
        foreach ($setorescovid as $item) {
            $totalvalor += $item->valor_total;
        }
        $usuario = $this->sessionread('login.usuario');
        $empresa = $this->sessionread('login.empresa');
        $usuario = $usuario->nome;
        $this->set(compact([
            'setorescovid'
            ,'cor'
            ,'totalvalor'
            ,'usuario'
            ,'empresa'
        ]));
    }

    public function modalcarteira($id, $setor){
        $anoAtual = Date('Y');
        $mesAtual = Date('m');
        if ($setor == 'GERAL') {
            $sql = "SELECT 
            ec.cgc_empresa, ec.razao_social, SUM(qtd.qtde_vidas_contrato) AS qtd_pessoas_plano, SUM(cc.valor)/SUM(qtd.qtde_vidas_contrato) AS ticket_medio, SUM(cc.valor) AS valor_total 
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
            
            INNER JOIN (SELECT cgc_empresa, SUM(qtde_vidas_contrato) AS qtde_vidas_contrato FROM (SELECT * FROM carteiraconta WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cgc_empresa, cod_contrato) A GROUP BY cgc_empresa) qtd ON (qtd.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor) AS valor FROM carteiraconta cc WHERE cc.status_contrato = 'ATIVO' AND DATE_FORMAT(cc.periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = ec.cgc_empresa)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
            
            WHERE cod_secao = '$id'
            
            GROUP BY ec.cgc_empresa
            ";
        } else {
            $sql = "SELECT 
            ec.cgc_empresa, ec.razao_social, SUM(qtd.qtde_vidas_contrato) AS qtd_pessoas_plano, SUM(cc.valor)/SUM(qtd.qtde_vidas_contrato) AS ticket_medio, SUM(cc.valor) AS valor_total 
            
            FROM (SELECT * FROM empresacarteira GROUP BY cgc_empresa) ec
            
            INNER JOIN (SELECT cgc_empresa, SUM(qtde_vidas_contrato) AS qtde_vidas_contrato FROM (SELECT * FROM carteiraconta WHERE status_contrato = 'ATIVO' AND DATE_FORMAT(periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cgc_empresa, cod_contrato) A GROUP BY cgc_empresa) qtd ON (qtd.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN (SELECT cc.cgc_empresa, SUM(cc.valor) AS valor FROM carteiraconta cc WHERE cc.status_contrato = 'ATIVO' AND DATE_FORMAT(cc.periodo_faturamento, '%Y-%m') = '$anoAtual-$mesAtual' GROUP BY cc.cgc_empresa) cc ON (cc.cgc_empresa = ec.cgc_empresa)
            
            INNER JOIN empresa_cnae ecnae ON (ecnae.cnpj = ec.cgc_empresa)
            
            INNER JOIN cnae_dados cd ON (cd.cod_cnae = ecnae.cnae_fiscal)
            
            INNER JOIN setor_cnae sc ON (sc.cnae_fiscal = ecnae.cnae_fiscal)
            
            WHERE cod_secao = '$id' AND UPPER(sc.setor) = UPPER('$setor')
            
            GROUP BY ec.cgc_empresa";
        }
        $modalcarteira = $this->query($sql);
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $usuario = $usuario->nome;
        $ticket_medio = 0;
        $sum_ticketmedio = 0;
        $qtd_empresas = 0;
        $qtd_individuos = 0;
        $total = 0;
        $totalvalor = 0;
        foreach ($modalcarteira as $item) {
            $total += $item->valor_total;
            $sum_ticketmedio += $item->ticket_medio;
            $qtd_empresas += 1;
            $qtd_individuos += $item->qtd_pessoas_plano;
            $totalvalor += $item->valor_total;
        }
        $ticket_medio = $totalvalor/$qtd_individuos;
        $ticket_medioemp = $totalvalor/$qtd_empresas;
        $setor_atividade = $this->get("Cnae_dados",'cod_secao',$id)->nm_secao;
        $this->set(compact(
            'modalcarteira'
            ,'setor_atividade'
            ,'qtd_empresas'
            ,'qtd_individuos'
            ,'total'
            ,'ticket_medio'
            ,'usuario'
            ,'totalvalor'
            ,'empresa'
            ,'ticket_medioemp'
        ));
    }
    
    public function buscar()
    {
        $busca = isset($_GET['busca'])?$_GET['busca']:null;
        $this->redirect(['action'=>'pessoa',$busca]);
    }

    public function graficos($id){
        $diassempagarpormes = $this->queryjson('adm.beneficiario.pessoa.diassempagarpormes', [
            'codbeneficiario'=>$id
        ]);
        //$diassempagarpormes2 = $this->arrtoserie($diassempagarpormes,['PRIMEIRO_TRIMESTRE','SEGUNDO_TRIMESTRE','TERCEIRO_TRIMESTRE','QUARTO_TRIMESTRE', 'YEAR']);
       
        $graficolinha = $this->queryjson('adm.beneficiario.pessoa.mediatrimestral', [
            'codbeneficiario'=>$id
        ]);
        $despesas = $this->queryjson('adm.beneficiario.pessoa.despesa', [
            'codbeneficiario'=>$id
        ]);
        $pagos = $this->queryjson('adm.beneficiario.pessoa.pago', [
            'codbeneficiario'=>$id
        ]);
        $periodos = [];
        for ($i = 0; $i < 3; $i++) {
            for ($j = 0; $j<12; $j++){
                $data = new stdClass();
                $data->ano = DATE('Y') - 2 + $i;
                $data->mes = $j+1;
                array_push($periodos,$data);
            }
        }
        $graficoanom2 = [];
        $graficoanom1 = [];
        $graficoanoatual = [];
        $acumanom2 = [];
        $acumanom1 = [];
        $acumanoatual = [];
        $somaanom2 = 0;
        $somaanom1 = 0;
        $somaanoatual = 0;
        $somatorio = 0;
        foreach ($periodos as $periodo){
            $FLAG = 0;
            $custo = 0;
            $receita = 0;
            foreach($despesas as $despesa){
                if($periodo->ano == $despesa->ANO && $periodo->mes == $despesa->MES){
                    $custo = $despesa->VALOR_TOTAL; break;
                } 
            }
            foreach($pagos as $pago){
                if($periodo->ano == $pago->ANO && $periodo->mes == $pago->MES){
                    $receita = $pago->VALOR_TOTAL; break;
                }
            }
            $obj = new stdClass();
            $obj2 = new stdClass();
            $obj->ano = $periodo->ano;
            $obj->mes = $periodo->mes;
            $obj->diff = $receita - $custo;
            $obj2->ano = $periodo->ano;
            $obj2->mes = $periodo->mes;
            $obj2->diff = $receita - $custo;
            if($periodo->ano == Date('Y')-2){
                $somaanom2 += $receita - $custo;
                array_push($graficoanom2,$obj);
                $obj2->diff = $somaanom2;
                array_push($acumanom2,$obj2);
            } else if ($periodo->ano == Date('Y')-1){
                $somaanom1 += $receita - $custo;
                array_push($graficoanom1,$obj);
                $obj2->diff = $somaanom1;
                array_push($acumanom1,$obj2);
            } else {
                $somaanoatual += $receita - $custo;
                array_push($graficoanoatual,$obj);
                $obj2->diff = $somaanoatual;
                array_push($acumanoatual,$obj2);
            }
            $somatorio += $receita - $custo;
        }
        $acummedia = [(($acumanoatual[0]->diff+$acumanom1[0]->diff+$acumanom2[0]->diff)/3),(($acumanoatual[1]->diff+$acumanom1[1]->diff+$acumanom2[1]->diff)/3),(($acumanoatual[2]->diff+$acumanom1[2]->diff+$acumanom2[2]->diff)/3),(($acumanoatual[3]->diff+$acumanom1[3]->diff+$acumanom2[3]->diff)/3),(($acumanoatual[4]->diff+$acumanom1[4]->diff+$acumanom2[4]->diff)/3),(($acumanoatual[5]->diff+$acumanom1[5]->diff+$acumanom2[5]->diff)/3),(($acumanoatual[6]->diff+$acumanom1[6]->diff+$acumanom2[6]->diff)/3),(($acumanoatual[7]->diff+$acumanom1[7]->diff+$acumanom2[7]->diff)/3),(($acumanoatual[8]->diff+$acumanom1[8]->diff+$acumanom2[8]->diff)/3),(($acumanoatual[9]->diff+$acumanom1[9]->diff+$acumanom2[9]->diff)/3),(($acumanoatual[10]->diff+$acumanom1[10]->diff+$acumanom2[10]->diff)/3),(($acumanoatual[11]->diff+$acumanom1[11]->diff+$acumanom2[11]->diff)/3)];
        $media = [round((($graficoanoatual[0]->diff+$graficoanom1[0]->diff+$graficoanom2[0]->diff)/3),2),round((($graficoanoatual[1]->diff+$graficoanom1[1]->diff+$graficoanom2[1]->diff)/3),2),round((($graficoanoatual[2]->diff+$graficoanom1[2]->diff+$graficoanom2[2]->diff)/3),2),round((($graficoanoatual[3]->diff+$graficoanom1[3]->diff+$graficoanom2[3]->diff)/3),2),round((($graficoanoatual[4]->diff+$graficoanom1[4]->diff+$graficoanom2[4]->diff)/3),2),round((($graficoanoatual[5]->diff+$graficoanom1[5]->diff+$graficoanom2[5]->diff)/3),2),round((($graficoanoatual[6]->diff+$graficoanom1[6]->diff+$graficoanom2[6]->diff)/3),2),round((($graficoanoatual[7]->diff+$graficoanom1[7]->diff+$graficoanom2[7]->diff)/3),2),round((($graficoanoatual[8]->diff+$graficoanom1[8]->diff+$graficoanom2[8]->diff)/3),2),round((($graficoanoatual[9]->diff+$graficoanom1[9]->diff+$graficoanom2[9]->diff)/3),2),round((($graficoanoatual[10]->diff+$graficoanom1[10]->diff+$graficoanom2[10]->diff)/3),2),round((($graficoanoatual[11]->diff+$graficoanom1[11]->diff+$graficoanom2[11]->diff)/3),2)];
        $this->set(compact('diassempagarpormes','acummedia','graficolinha','graficoanoatual','graficoanom1','graficoanom2','acumanoatual','acumanom1','acumanom2','media'));
    }

    public function pessoa($id=null)
    {   
        $resumo = $this->queryjson('adm.beneficiario.pessoa.resumotitulos',[
                'codbeneficiario'=>$id
            ]);
        $resumo = $resumo[0];
        $endbeneficiario = $this->queryjson('adm.beneficiario.pessoa.enderecobeneficiario',[
            'codbeneficiario'=>$id
        ]);
        $endbeneficiario = $endbeneficiario[0];
        $familias = $this->queryjson('adm.beneficiario.pessoa.familias',[
            'codbeneficiario'=>$id
        ]);
        $permanencia = $this->queryjson('adm.beneficiario.pessoa.permanencia',[
            'codbeneficiario'=>$id
        ]);
        $totalpago = $this->queryjson('adm.beneficiario.pessoa.totalpago',[
            'codbeneficiario'=>$id
        ]);
        foreach ($permanencia as $item){
            $item->PAGO = '-';
            $item->GASTO =  '-';
            $item->SINISTRALIDADE = '-';
            foreach ($totalpago as $resumopagamento){
                if($resumopagamento->COD_BENEFICIARIO == $item->COD_BENEFICIARIO && $resumopagamento->COD_CONTRATO == $item->COD_CONTRATO && $resumopagamento->COD_EMPRESA == $item->COD_EMPRESA 
                && $resumopagamento->COD_UNIMED == $item->COD_UNIMED && $resumopagamento->COD_FAMILIA == $item->COD_FAMILIA){
                    $item->PAGO = ($resumopagamento->TOTAL_PAGO) ? $resumopagamento->TOTAL_PAGO : '-';
                    $item->GASTO = ($resumopagamento->TOTAL_GASTO) ? $resumopagamento->TOTAL_GASTO : '-';
                    $item->SINISTRALIDADE = ($resumopagamento->TOTAL_GASTO) ? $resumopagamento->TOTAL_GASTO *100/ $resumopagamento->TOTAL_PAGO : '-';
                    break;
                }
            }
        }
        $totalgasto = $this->queryjson('adm.beneficiario.pessoa.totalgasto',[
            'codbeneficiario'=>$id
        ]);
        $totalconsumido = $this->queryjson('adm.beneficiario.pessoa.consumototal',[
            'codbeneficiario'=>$id
        ]);
        $this->set(compact('id','resumo','endbeneficiario','familias','permanencia','totalconsumido','totalpago'));
    }

    public function pessoaresumotitulo($num_doc){
        $resumo = $this->queryjson('adm.beneficiario.titulodetalhado',[
            'num_doc'=>$num_doc
        ]);
        $this->set([
            'resumo' => $resumo,
            '_serialize' => ['resumo'],
        ]);
        $this->RequestHandler->renderAs($this, 'json');
    }

    public function pessoatitulo($id=null)
    {
        $condicao = $_GET['tipo'];
        $media = 0;
        $count = 0;
        $sumdias = 0;
        $sumpag = 0;
        $sumconta = 0;
        $diff=0;
        if($condicao == 'aberto'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosemaberto',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumdias += round($item->DIAS);
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
            }
            $condicao2 = "em Aberto";

        } else if($condicao == 'atrasado'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosatrasados',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumdias += round($item->DIAS);
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
                $diff = $item->VALOR_PAGO - $item->VALOR_TOTAL;
            }
            $condicao2 = "Atrasados";

        } else if ($condicao == 'emdia'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosemdia',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
                $diff = $item->VALOR_PAGO - $item->VALOR_TOTAL;
            }
            $condicao2 = "em dia";

        } else if ($condicao == 'antecipado'){
            $resumo = $this->queryjson('adm.beneficiario.pessoa.titulosantecipados',[
                'codbeneficiario'=>$id
            ]);
            foreach($resumo as $item){
                $count ++;
                $sumdias += round($item->DIAS);
                $sumpag += $item->VALOR_PAGO;
                $sumconta += $item->VALOR_TOTAL;
                $diff = $item->VALOR_PAGO - $item->VALOR_TOTAL;
            }
            $condicao2 = "Antecipados";
        }
        $count = ($count == 0) ? 1 : $count;
        $media = $sumdias/$count;
        $mediapag = $sumpag/$count;
        $mediaconta = $sumconta/$count;
        foreach ($resumo as $item){
            $this->queryjson('adm.beneficiario.titulodetalhado',[
                'num_doc'=>$item->NUM_DOC
            ]);
        }
        $this->set(compact('id','resumo','condicao','condicao2','media','mediapag','mediaconta', 'diff'));
    }
}
