<?php
namespace App\Controller\Adm;

use App\Controller\AppController;

/**
 * Contatoanexo Controller
 *
 * @property \App\Model\Table\ContatoanexoTable $Contatoanexo
 *
 * @method \App\Model\Entity\Contatoanexo[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ContatoanexoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $contatoanexo = $this->paginate($this->Contatoanexo);

        $this->set(compact('contatoanexo'));
    }

    /**
     * View method
     *
     * @param string|null $id Contatoanexo id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $contatoanexo = $this->Contatoanexo->get($id, [
            'contain' => []
        ]);

        $this->set('contatoanexo', $contatoanexo);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $contatoanexo = $this->Contatoanexo->newEntity();
        if ($this->request->is('post')) {
            $contatoanexo = $this->Contatoanexo->patchEntity($contatoanexo, $this->request->getData());
            if ($this->Contatoanexo->save($contatoanexo)) {
                $this->Flash->success(__('The contatoanexo has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The contatoanexo could not be saved. Please, try again.'));
        }
        $this->set(compact('contatoanexo'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Contatoanexo id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $contatoanexo = $this->Contatoanexo->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $contatoanexo = $this->Contatoanexo->patchEntity($contatoanexo, $this->request->getData());
            if ($this->Contatoanexo->save($contatoanexo)) {
                $this->Flash->success(__('The contatoanexo has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The contatoanexo could not be saved. Please, try again.'));
        }
        $this->set(compact('contatoanexo'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Contatoanexo id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $contatoanexo = $this->Contatoanexo->get($id);
        if ($this->Contatoanexo->delete($contatoanexo)) {
            $this->Flash->success(__('The contatoanexo has been deleted.'));
        } else {
            $this->Flash->error(__('The contatoanexo could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
