<?php
namespace App\Controller\Adm;

use App\Controller\AppController;

/**
 * Dashboard Controller
 *
 *
 * @method \App\Model\Entity\Dashboard[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class DashboardController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $mesAtual = -1;
        if(isset($_REQUEST['mes']) && $_REQUEST['mes'] !=-1){
            $mesAtual = $this->getMes();
        }
        
        if(!isset($_REQUEST['mes'])){
            $mesAtual = $this->getMes();
        }
        
        $anoAtual = $this->getAno(); 
        
        $sql = "SELECT
            count(1) as total
            ,case when GRUPO = 1 Then 1 else 0 end as grupo1
            ,case when GRUPO = 2 Then 1 else 0 end as grupo2
            ,case when GRUPO = 3 Then 1 else 0 end as grupo3
            ,case when GRUPO = 4 Then 1 else 0 end as grupo4
            ,case when GRUPO = 5 Then 1 else 0 end as grupo5
            from beneficiario
        ";
        
        $resumogrupos = $this->query($sql);
        if(count($resumogrupos)==0){
            $obj = (object)[];
            $obj->grupo1 = 0;
            $obj->grupo2 = 0;
            $obj->grupo3 = 0;
            $obj->grupo4 = 0;
            $obj->grupo5 = 0;
            $resumogrupos = [$obj];
        }
        $resumogrupos = $resumogrupos[0];
        $resumotitulos = $this->queryjson('adm.dashboard.resumotitulos',[
            'mesAtual'=>$mesAtual
            ,'anoAtual'=>$anoAtual
        ]);
        $resumotitulos = $resumotitulos[0];
        
        $this->set(compact('resumogrupos','resumotitulos','mesAtual','anoAtual'));
    }
}
