<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * DashboardCorona Controller
 *
 *
 * @method \App\Model\Entity\DashboardCorona[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class DashboardCoronaController extends AppController
{

    public function teste() {
        
    }

     public function index() {
        $estado = $this->sessionread('login.empresa')->estado;
        $empresa = $this->sessionread('login.empresa');
        $modulos = $this->sessionread('login.modulos');
        $hospitaisid = $this->sessionread('login.hospitais');
        $modulosuser = [];
        foreach ($modulos as $modulo) {
            array_push($modulosuser,$modulo->chave);
        }
        if (!in_array('corona',$modulosuser)) {
            return $this->redirect($this->referer());
        }
        $hospitaisidimplode = implode(",",$hospitaisid);
        $codestado = $this->get('Estado','uf',$estado)->id;
        
        $internacoesGerais = $this->query("SELECT dummy._date, COUNT(DISTINCT dummy.prontuarioatendimentoid) AS soma,
        COUNT(dummy.prontuarioatendimentoid) AS testesoma, SUM(CASE WHEN dummy.local = 'UTI' THEN 1 ELSE 0 END) AS uti,
        SUM(CASE WHEN dummy.tipo = 'Diag. Confirmado' THEN 1 ELSE 0 END) AS conf,
        SUM(CASE WHEN dummy.tipo = 'Descartado' THEN 1 ELSE 0 END) AS descartado,
        SUM(CASE WHEN dummy.tipo = 'Diag. Suspeito' THEN 1 ELSE 0 END) AS susp,
        SUM(CASE WHEN dummy.local = 'UCI' THEN 1 ELSE 0 END) AS uci,
        SUM(CASE WHEN dummy.local = 'Enfermaria' THEN 1 ELSE 0 END) AS enfermaria,
        SUM(dummy.ventilacao) AS ventilacao
            FROM ( 
                SELECT d._date, pa.prontuarioatendimentoid, ep.local, ep.tipo, ep.ventilacao
                -- (SELECT local FROM entradapacientes WHERE entradapacientesid = MAX(ep.entradapacientesid)) AS local, 
                -- (SELECT ventilacao FROM entradapacientes WHERE entradapacientesid = MAX(ep.entradapacientesid) AND (ep.tiposuporte IS NULL OR ep.tiposuporte = 'Ventilação Mecânica')) AS ventilacao,
                -- (SELECT tipo FROM entradapacientes WHERE entradapacientesid = MAX(ep.entradapacientesid)) AS tipo
                FROM datetable d 
                INNER JOIN (SELECT * FROM prontuarioatendimento) pa ON
                    (d._date >= CAST(COALESCE(pa.data_entrada,CURRENT_TIME) AS DATE) 
                        AND ( (d._date <= CAST(COALESCE(pa.data_alta,CURRENT_TIME) AS DATE) OR pa.data_alta = '0000-00-00 00:00:00') OR (pa.alta = 0 AND pa.data_alta IS NOT NULL))
                        AND ( (d._date <= CAST(COALESCE(pa.data_obito,CURRENT_TIME) AS DATE) OR pa.data_obito = '0000-00-00 00:00:00') OR (pa.obito = 0 AND pa.data_obito IS NOT NULL))
                        AND (d._date <= CAST(COALESCE(pa.data_saida,CURRENT_TIME) AS DATE) OR pa.data_saida = '0000-00-00 00:00:00')
                    )
                LEFT JOIN entradapacientes ep ON ep.entradapacientesid = (SELECT MAX(ep2.entradapacientesid) FROM entradapacientes ep2 WHERE CAST(ep2.datacadastro AS DATE) <= d._date AND pa.prontuarioatendimentoid = ep2.prontuarioatendimentoid)
                -- LEFT JOIN entradapacientes ep_aux ON (epl.entradapacientesid = MAX(ep.entradapacientesid))
                -- LEFT JOIN entradapacientes epv ON (epv.entradapacientesid = MAX(ep.entradapacientesid) AND (ep.tiposuporte IS NULL OR ep.tiposuporte = 'Ventilação Mecânica'))
                -- LEFT JOIN entradapacientes ept ON (ept.entradapacientesid = MAX(ep.entradapacientesid))
            ) dummy
        GROUP BY 1 
        ORDER BY 1 ASC");
        $internacoesgeral = [];
        $utigeral = [];
        $enfermariageral = [];
        $ucigeral = [];
        $confgeral = [];
        $suspgeral = [];
        $descgeral = [];
        $ventilacaogeral = [];
        $datas = [];
        foreach ($internacoesGerais as $item) {
            array_push($internacoesgeral,$item->soma);
            array_push($utigeral,$item->uti);
            array_push($enfermariageral,$item->enfermaria);
            array_push($ucigeral,$item->uci);
            array_push($confgeral,$item->conf);
            array_push($suspgeral,$item->susp);
            array_push($descgeral,$item->descartado);
            array_push($ventilacaogeral,$item->ventilacao);
            array_push($datas,$this->formatData($item->_date));
        }
        $arrayhospitais = [];
        foreach ($hospitaisid as $hospitalid) {
            $arraydummy = [];
            $internacoes = $this->query(
                "SELECT dummy._date, COUNT(DISTINCT dummy.prontuarioatendimentoid) AS soma,
                COUNT(dummy.prontuarioatendimentoid) AS testesoma, SUM(CASE WHEN dummy.local = 'UTI' THEN 1 ELSE 0 END) AS uti,
                SUM(CASE WHEN dummy.tipo = 'Diag. Confirmado' THEN 1 ELSE 0 END) AS conf,
                SUM(CASE WHEN dummy.tipo = 'Descartado' THEN 1 ELSE 0 END) AS descartado,
                SUM(CASE WHEN dummy.tipo = 'Diag. Suspeito' THEN 1 ELSE 0 END) AS susp,
                SUM(CASE WHEN dummy.local = 'UCI' THEN 1 ELSE 0 END) AS uci,
                SUM(CASE WHEN dummy.local = 'Enfermaria' THEN 1 ELSE 0 END) AS enfermaria,
                SUM(dummy.ventilacao) AS ventilacao
                    FROM ( 
                        SELECT d._date, pa.prontuarioatendimentoid, ep.local, ep.tipo, ep.ventilacao, pa.hospitalid
                        -- (SELECT local FROM entradapacientes WHERE entradapacientesid = MAX(ep.entradapacientesid)) AS local, 
                        -- (SELECT ventilacao FROM entradapacientes WHERE entradapacientesid = MAX(ep.entradapacientesid) AND (ep.tiposuporte IS NULL OR ep.tiposuporte = 'Ventilação Mecânica')) AS ventilacao,
                        -- (SELECT tipo FROM entradapacientes WHERE entradapacientesid = MAX(ep.entradapacientesid)) AS tipo
                        FROM datetable d 
                        INNER JOIN (SELECT * FROM prontuarioatendimento) pa ON
                            (d._date >= CAST(COALESCE(pa.data_entrada,CURRENT_TIME) AS DATE) 
                                AND ( (d._date <= CAST(COALESCE(pa.data_alta,CURRENT_TIME) AS DATE) OR pa.data_alta = '0000-00-00 00:00:00') OR (pa.alta = 0 AND pa.data_alta IS NOT NULL))
                                AND ( (d._date <= CAST(COALESCE(pa.data_obito,CURRENT_TIME) AS DATE) OR pa.data_obito = '0000-00-00 00:00:00') OR (pa.obito = 0 AND pa.data_obito IS NOT NULL))
                                AND (d._date <= CAST(COALESCE(pa.data_saida,CURRENT_TIME) AS DATE) OR pa.data_saida = '0000-00-00 00:00:00')
                            )
                        LEFT JOIN entradapacientes ep ON ep.entradapacientesid = (SELECT MAX(ep2.entradapacientesid) FROM entradapacientes ep2 WHERE CAST(ep2.datacadastro AS DATE) <= d._date AND pa.prontuarioatendimentoid = ep2.prontuarioatendimentoid)
                        -- LEFT JOIN entradapacientes ep_aux ON (epl.entradapacientesid = MAX(ep.entradapacientesid))
                        -- LEFT JOIN entradapacientes epv ON (epv.entradapacientesid = MAX(ep.entradapacientesid) AND (ep.tiposuporte IS NULL OR ep.tiposuporte = 'Ventilação Mecânica'))
                        -- LEFT JOIN entradapacientes ept ON (ept.entradapacientesid = MAX(ep.entradapacientesid))
                    ) dummy
                WHERE dummy.hospitalid = $hospitalid
                GROUP BY 1 
                ORDER BY 1 ASC
                
                ");
            foreach ($internacoes as $item) {
                array_push($arraydummy,[$item->soma,$item->uti,$item->uci,$item->enfermaria,$item->ventilacao,$this->formatData($item->_date),$hospitalid]);
            }   
            array_push($arrayhospitais,$arraydummy);
        }
        $municipios = $this->getAllTableWhere('Cidade',['estado'=>$codestado],[]);
        $this->set(compact([
            'estado'
            ,'municipios'
            ,'arrayhospitais'
            ,'empresa'
            ,'modulosuser'
            ,'internacoesgeral'
            ,'datas'
            ,'hospitaisid'
            ,'utigeral'
            ,'enfermariageral'
            ,'ucigeral'
            ,'ventilacaogeral'
            ,'confgeral'
            ,'suspgeral'
            ,'confgeral'
            ,'suspgeral'
            ,'descgeral'
        ]));
    }

    public function gpad() {
        $empresa = $this->sessionread('login.empresa');
        $modulos = $this->sessionread('login.modulos');
        $modulosuser = [];
        foreach ($modulos as $modulo) {
            array_push($modulosuser,$modulo->chave);
        }
        if (!in_array('homecare',$modulosuser)) {
            return $this->redirect($this->referer());
        }
        $graficogpad = $this->query(
            "SELECT d._date AS datacadastro, COALESCE(visitas.qtdvisitas, 0) AS qtdvisitas
            FROM datetable d 
            LEFT JOIN (
                SELECT COUNT(DISTINCT ultimododia.carteiracpf) AS qtdvisitas, DATE_FORMAT(datacadastro, '%Y-%m-%d') AS datacadastro
                 FROM (
                    SELECT e.* FROM pacientes_homecare e 
                    INNER JOIN (
                    SELECT MAX(pacientes_homecareid) as pacientes_homecareid FROM pacientes_homecare GROUP BY DATE_FORMAT(`datacadastro`, '%Y-%m-%d'), carteiracpf) a ON (a.pacientes_homecareid = e.pacientes_homecareid)  
                    ) ultimododia 
                GROUP BY 2 ) visitas ON (d._date = visitas.datacadastro)
            WHERE COALESCE(visitas.qtdvisitas, 0) <> 0
            ORDER BY 1"
        );
        $acumuladovisitas = 0;
        $mediadiariavalor = 0;
        $totalvisitas = 0;
        $mediadiaria = [];
        $arrayacumuladovisitas = [];
        $arrayvisitas = [];
        $datasvisita = [];
        foreach ($graficogpad as $item) {
            array_push($datasvisita,$this->formatData($item->datacadastro));
            $acumuladovisitas += $item->qtdvisitas;
            array_push($arrayacumuladovisitas,$acumuladovisitas);
            array_push($arrayvisitas,$item->qtdvisitas);
            $mediadiariavalor += $item->qtdvisitas;
        }
        foreach ($graficogpad as $item) {
            array_push($mediadiaria,$mediadiariavalor/count($graficogpad));
        }
        
        $pacientes = $this->query(
            "SELECT
            SUM(CASE WHEN o.tipo LIKE '%Suspeito%' THEN 1 ELSE 0 END) AS SUSPEITO,
            SUM(CASE WHEN o.tipo LIKE '%Confirmado%' THEN  1 ELSE 0 END) AS CONFIRMADO,
            SUM(CASE WHEN o.tipo LIKE '%Descartado%' THEN  1 ELSE 0 END) AS DESCARTADO,
            SUM(CASE WHEN o.tipo LIKE '%Confirmado%' AND o.tipoprograma = 'PAD' THEN  1 ELSE 0 END) AS CONFIRMADOPAD,
            SUM(CASE WHEN o.tipo LIKE '%Confirmado%' AND o.tipoprograma = 'PID' THEN  1 ELSE 0 END) AS CONFIRMADOPID,
            SUM(CASE WHEN o.tipo LIKE '%Confirmado%' AND o.tipoprograma = 'Rota' THEN  1 ELSE 0 END) AS CONFIRMADOROTA,
            SUM(CASE WHEN o.tipo LIKE '%Suspeito%' AND o.tipoprograma = 'PAD' THEN  1 ELSE 0 END) AS SUSPEITOPAD,
            SUM(CASE WHEN o.tipo LIKE '%Suspeito%' AND o.tipoprograma = 'PID' THEN  1 ELSE 0 END) AS SUSPEITOPID,
            SUM(CASE WHEN o.tipo LIKE '%Suspeito%' AND o.tipoprograma = 'Rota' THEN  1 ELSE 0 END) AS SUSPEITOROTA,
            SUM(CASE WHEN o.tipo LIKE '%Descartado%' AND o.tipoprograma = 'PAD' THEN  1 ELSE 0 END) AS DESCARTADOPAD,
            SUM(CASE WHEN o.tipo LIKE '%Descartado%' AND o.tipoprograma = 'PID' THEN  1 ELSE 0 END) AS DESCARTADOPID,
            SUM(CASE WHEN o.tipo LIKE '%Descartado%' AND o.tipoprograma = 'Rota' THEN  1 ELSE 0 END) AS DESCARTADOROTA,
            SUM(CASE WHEN o.tipoprograma = 'PID' THEN  1 ELSE 0 END) AS TOTALPID,
            SUM(CASE WHEN o.ventilacao = 1 AND o.tipoprograma = 'PAD' THEN  1 ELSE 0 END) AS VENTPAD,
            SUM(CASE WHEN o.ventilacao = 1 AND o.tipoprograma = 'PID' THEN  1 ELSE 0 END) AS VENTPID,
            SUM(CASE WHEN o.ventilacao = 1 AND o.tipoprograma = 'Rota' THEN  1 ELSE 0 END) AS VENTROTA,
            SUM(CASE WHEN o.tipoprograma = 'PID' THEN  1 ELSE 0 END) AS TOTALPID,
            SUM(CASE WHEN o.tipoprograma = 'PAD' THEN  1 ELSE 0 END) AS TOTALPAD,
            SUM(CASE WHEN o.tipoprograma = 'Rota' THEN  1 ELSE 0 END) AS TOTALROTA,
            COUNT(*) AS TOTAL,
            MAX(o.datacadastro) AS atu
            FROM `pacientes_homecare` o           
            LEFT JOIN `pacientes_homecare` b     
                ON o.carteiracpf = b.carteiracpf AND o.datacadastro < b.datacadastro
            WHERE b.datacadastro is NULL
            and o.alta <> 1
            and o.obito <> 1"
        );
        $this->set(compact([
            'graficogpad'
            ,'datasvisita'
            ,'arrayacumuladovisitas'
            ,'arrayvisitas'
            ,'mediadiaria'
            ,'mediadiariavalor'
            ,'pacientes'
        ]));
    }

    public function modalhospital($hospitalid) {
        $hospitaisid = $this->sessionread('login.hospitais');
        if ($hospitalid == 'todos') {
            $hospitalquery = "LIKE '%'";
            $hospital = "Visão Geral";
            $hospitalquery2 = 'LIKE \'%\'';
        } else {
            $hospitalquery = "= $hospitalid";
            $hospital = $this->get('Hospital','hospitalid',$hospitalid)->nomefantasia;
            $hospitalquery2 = '= '.$hospitalid;
        }
        $pacientes = $this->query(
            "SELECT pa.*, h.nomefantasia, GROUP_CONCAT(pg.gruporisco) AS gruporisco, ep.observacao, ep.datacadastro
         FROM `prontuarioatendimento` pa
           INNER JOIN `hospital` h ON pa.hospitalid = h.hospitalid
           LEFT JOIN paciente_gruporisco pg ON (pg.entradapacientesid = pa.entradapacienteid_gruporisco)
           INNER JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
         WHERE pa.hospitalid $hospitalquery
         AND pa.alta <> 1
         AND pa.obito <> 1
         AND pa.fimprontuario <> 1
         GROUP BY pa.prontuarioatendimentoid
         ");

        $hospital2 = $this->query("SELECT SUM(CASE WHEN pa.local LIKE '%UTI%' THEN 1 ELSE 0 END) AS UTI,
        SUM(CASE WHEN pa.tipo LIKE '%Suspeito%'  AND (pa.local LIKE '%UTI%' OR pa.local LIKE '%UCI%' OR pa.local LIKE '%Enfermaria%')  THEN 1 ELSE 0 END) AS SUSPEITO,
        SUM(CASE WHEN pa.tipo LIKE '%Confirmado%'  AND (pa.local LIKE '%UTI%' OR pa.local LIKE '%UCI%' OR pa.local LIKE '%Enfermaria%')  THEN  1 ELSE 0 END) AS CONFIRMADO,
        SUM(CASE WHEN pa.local LIKE '%UTI%' OR pa.local LIKE '%Enfermaria%' OR pa.local LIKE '%UCI%' THEN 1 ELSE 0 END) AS INTERNADO,
        SUM(CASE WHEN pa.tipo LIKE '%Confirmado%' AND pa.local LIKE '%UTI%' THEN 1 ELSE 0 END) AS UTICONF,
        SUM(CASE WHEN pa.tipo LIKE '%Suspeito%' AND pa.local LIKE '%UTI%' THEN 1 ELSE 0 END) AS UTISUSP,
        COUNT(*) AS TOTAL
         FROM `prontuarioatendimento` pa  
         WHERE pa.hospitalid $hospitalquery2
         AND pa.alta <> 1
         AND pa.obito <> 1 
         AND pa.fimprontuario <> 1 
         ");
         $this->set(compact([
             'pacientes'
             ,'hospital'
             ,'hospital2'
         ]));
    }

    public function unimeddetalhamento() {
        $empresa = $this->sessionread('login.empresa');
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        $estado = $empresa->estado;
        $codestado = $this->get('estado','uf',$estado)->id;
        $pacientes = $this->query("SELECT SUM(CASE WHEN pa.local LIKE '%UTI%' THEN 1 ELSE 0 END) AS UTI,
        SUM(CASE WHEN pa.local LIKE '%UCI%' THEN 1 ELSE 0 END) AS UCI,
        SUM(CASE WHEN pa.local LIKE '%Enfermaria%' THEN 1 ELSE 0 END) AS ENFERMARIA,
        SUM(CASE WHEN pa.tipo LIKE '%Suspeito%' AND (pa.local LIKE '%UTI%' OR pa.local LIKE '%UCI%' OR pa.local LIKE '%Enfermaria%')  THEN 1 ELSE 0 END) AS SUSPEITO,
        SUM(CASE WHEN pa.tipo LIKE '%Confirmado%' AND (pa.local LIKE '%UTI%' OR pa.local LIKE '%UCI%' OR pa.local LIKE '%Enfermaria%') THEN  1 ELSE 0 END) AS CONFIRMADO,
        SUM(CASE WHEN pa.local LIKE '%UTI%' OR pa.local LIKE '%UCI%' OR pa.local LIKE '%Enfermaria%' THEN 1 ELSE 0 END) AS INTERNADO,
        SUM(CASE WHEN pa.tipo LIKE '%Confirmado%' AND pa.local LIKE '%UCI%' THEN 1 ELSE 0 END) AS UCICONF,
        SUM(CASE WHEN pa.tipo LIKE '%Suspeito%' AND pa.local LIKE '%UCI%' THEN 1 ELSE 0 END) AS UCISUSP,
        SUM(CASE WHEN pa.tipo LIKE '%Confirmado%' AND pa.local LIKE '%UTI%' THEN 1 ELSE 0 END) AS UTICONF,
        SUM(CASE WHEN pa.tipo LIKE '%Suspeito%' AND pa.local LIKE '%UTI%' THEN 1 ELSE 0 END) AS UTISUSP,
        SUM(CASE WHEN pa.tipo LIKE '%Confirmado%' AND UPPER(pa.local) LIKE '%ENF%' THEN 1 ELSE 0 END) AS ENFCONF,
        SUM(CASE WHEN pa.tipo LIKE '%Suspeito%' AND UPPER(pa.local) LIKE '%ENF%' THEN 1 ELSE 0 END) AS ENFSUSP,
        SUM(pa.ventilacao) AS VENTILACAO,
        COUNT(*) AS TOTAL,
        pa.hospitalid AS idhospital,
        MAX(cadastro.datacadastro) AS atu, l.*
         FROM `prontuarioatendimento` pa  
           LEFT JOIN `hospital` h on pa.hospitalid = h.hospitalid 
           LEFT JOIN (SELECT hospitalid, MAX(datacadastro) AS datacadastro FROM entradapacientes GROUP BY 1) cadastro ON cadastro.hospitalid = pa.hospitalid
           LEFT JOIN (SELECT l.* FROM hospitalleitos l INNER JOIN (SELECT MAX(hospitalleitosid) AS hospitalleitosid, hospitalid FROM hospitalleitos GROUP BY hospitalid) l2 ON (l2.hospitalleitosid = l.hospitalleitosid)) l ON (l.hospitalid = pa.hospitalid)
         WHERE pa.hospitalid $hospitalquery
         and pa.alta <> 1
         and pa.obito <> 1
         and pa.fimprontuario <> 1
         GROUP BY pa.hospitalid
         ORDER BY h.nomefantasia, UTI DESC, INTERNADO DESC");
        $hospitais = $this->getAllTableWhere('Hospital',["UPPER(nomefantasia) LIKE '%HOSPITAL%'", "uf"=>$estado],['pacientesunimeduti']); 
        $corona = 0;
        $uti = 0;
        $uci = 0;
        $confirmados = 0;
        $internados = 0;
        $suspeitos = 0;
        $utisuspeitos = 0;
        $uticonfirmados = 0;
        $ucisuspeitos = 0;
        $uciconfirmados = 0;
        $enfsuspeitos = 0;
        $enfconfirmados = 0;
        $totalprestadores = 0;
        $confirmadosunimed = 0;
        $suspeitosunimed = 0;
        $leitosenfgeral = 0;
        $leitosutigeral = 0;
        $ventilacao = 0;
        $enfermaria = 0;
        foreach ($pacientes as $item) {
            $leitosenfgeral += $item->enfermaria;
            $leitosutigeral += $item->utiadulto + $item->utipediatria;
            $confirmados = $confirmados + $item->CONFIRMADO;
            $suspeitos = $suspeitos + $item->SUSPEITO;
            $uticonfirmados = $uticonfirmados + $item->UTICONF;
            $utisuspeitos = $utisuspeitos + $item->UTISUSP;
            $uciconfirmados = $uciconfirmados + $item->UCICONF;
            $ucisuspeitos = $ucisuspeitos + $item->UCISUSP;
            $enfconfirmados = $enfconfirmados + $item->ENFCONF;
            $enfsuspeitos = $enfsuspeitos + $item->ENFSUSP;
            $uti = $uti + $item->UTI;
            $uci = $uci + $item->UCI;
            $internados = $internados + $item->INTERNADO;
            $totalprestadores += 1;
            $ventilacao += $item->VENTILACAO;
            $enfermaria += $item->ENFERMARIA;
        }
        $municipios = $this->getAllTableWhere('Cidade',['estado'=>$codestado],[]);

        $internadoseconfirmadosdia = $this->query(
            "SELECT d._date AS datacadastro, COALESCE(internados.qtdinternados, 0) AS qtdinternados,
             COALESCE(suspeitos.qtdsuspeitos, 0) AS qtdsuspeitos,COALESCE(descartados.qtddescartados, 0) AS qtddescartados,
                COALESCE(confirmados.qtdconfirmados, 0) AS qtdconfirmados, COALESCE(alta.qtdalta, 0) AS qtdalta , COALESCE(obito.qtdobito, 0) AS qtdobito 
            FROM datetable d 
            LEFT JOIN (
                SELECT COUNT(DISTINCT ultimododia.carteiracpf) AS qtdinternados, DATE_FORMAT(datacadastro, '%Y-%m-%d') AS datacadastro, pa.prontuarioatendimentoid FROM (
                    SELECT e.* FROM entradapacientes e 
                    INNER JOIN (
                    SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes GROUP BY DATE_FORMAT(`datacadastro`, '%Y-%m-%d'), carteiracpf) a ON (a.entradapacientesid = e.entradapacientesid)  
                
                    WHERE (UPPER(local) LIKE '%UTI%' OR UPPER(local) LIKE '%ENFERMARIA%' OR UPPER(local) LIKE '%UCI%')
                    ) ultimododia 
                INNER JOIN prontuarioatendimento AS pa ON (pa.prontuarioatendimentoid = ultimododia.prontuarioatendimentoid) 
                INNER JOIN (SELECT MIN(entradapacientesid) AS entradapacientesid FROM (
                    SELECT e.* FROM entradapacientes e 
                    INNER JOIN (
                    SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes GROUP BY DATE_FORMAT(`datacadastro`, '%Y-%m-%d'), carteiracpf) a ON (a.entradapacientesid = e.entradapacientesid)  
                
                    WHERE UPPER(local) LIKE '%UTI%' OR UPPER(local) LIKE '%ENFERMARIA%' OR UPPER(local) LIKE '%UCI%') b GROUP BY b.carteiracpf
                ) primeirodia ON ( ultimododia.entradapacientesid = primeirodia.entradapacientesid)
                GROUP BY 2 
            ) internados ON (d._date = internados.datacadastro)
            
            LEFT JOIN (
                SELECT DATE_FORMAT(e.datacadastro, '%Y-%m-%d') AS datacadastro, count(DISTINCT b.carteiracpf) AS qtdconfirmados, pa.prontuarioatendimentoid FROM entradapacientes e INNER JOIN 
                (SELECT e.* 
                FROM entradapacientes e
                INNER JOIN (SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes 	GROUP BY carteiracpf) a 
                    ON (a.entradapacientesid = e.entradapacientesid)
                WHERE UPPER(tipo) LIKE '%CONF%'
                GROUP BY 1) a ON (a.carteiracpf = e.carteiracpf)
                INNER JOIN prontuarioatendimento AS pa ON (pa.prontuarioatendimentoid = a.prontuarioatendimentoid) 

                INNER JOIN (SELECT e.* 
                FROM entradapacientes e
                INNER JOIN (SELECT MIN(entradapacientesid) as entradapacientesid FROM (SELECT * FROM entradapacientes WHERE UPPER(tipo) LIKE '%CONF%') a GROUP BY carteiracpf) a 
                    ON (a.entradapacientesid = e.entradapacientesid)
                WHERE UPPER(tipo) LIKE '%CONF%'
                GROUP BY 1) b ON (b.entradapacientesid = e.entradapacientesid) GROUP BY 1
            ) confirmados ON (confirmados.datacadastro = d._date)
            
            LEFT JOIN (
                SELECT DATE_FORMAT(e.datacadastro, '%Y-%m-%d') AS datacadastro, count(DISTINCT b.carteiracpf) AS qtdsuspeitos, pa.prontuarioatendimentoid  FROM entradapacientes e INNER JOIN 
                (SELECT e.* 
                FROM entradapacientes e
                INNER JOIN (SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes 	GROUP BY carteiracpf) a 
                    ON (a.entradapacientesid = e.entradapacientesid)
                WHERE UPPER(tipo) LIKE '%SUSP%'
                GROUP BY 1) a ON (a.carteiracpf = e.carteiracpf)
                INNER JOIN prontuarioatendimento AS pa ON (pa.prontuarioatendimentoid = a.prontuarioatendimentoid) 
                INNER JOIN (SELECT e.* 
                FROM entradapacientes e
                INNER JOIN (SELECT MIN(entradapacientesid) as entradapacientesid FROM (SELECT * FROM entradapacientes WHERE UPPER(tipo) LIKE '%SUSP%') a GROUP BY carteiracpf) a 
                    ON (a.entradapacientesid = e.entradapacientesid)
                WHERE UPPER(tipo) LIKE '%SUSP%'
                GROUP BY 1) b ON (b.entradapacientesid = e.entradapacientesid) GROUP BY 1
            ) suspeitos ON (suspeitos.datacadastro = d._date)

            LEFT JOIN (
                SELECT DATE_FORMAT(e.datacadastro, '%Y-%m-%d') AS datacadastro, count(DISTINCT b.carteiracpf) AS qtddescartados, pa.prontuarioatendimentoid FROM entradapacientes e INNER JOIN 
                (SELECT e.* 
                FROM entradapacientes e
                INNER JOIN (SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes 	GROUP BY carteiracpf) a 
                    ON (a.entradapacientesid = e.entradapacientesid)
                WHERE UPPER(tipo) LIKE '%DESC%'
                GROUP BY 1) a ON (a.carteiracpf = e.carteiracpf)
                INNER JOIN prontuarioatendimento AS pa ON (pa.prontuarioatendimentoid = a.prontuarioatendimentoid) 
                INNER JOIN (SELECT e.* 
                FROM entradapacientes e
                INNER JOIN (SELECT MIN(entradapacientesid) as entradapacientesid FROM (SELECT * FROM entradapacientes WHERE UPPER(tipo) LIKE '%DESC%') a GROUP BY carteiracpf) a 
                    ON (a.entradapacientesid = e.entradapacientesid)
                WHERE UPPER(tipo) LIKE '%DESC%'
                GROUP BY 1) b ON (b.entradapacientesid = e.entradapacientesid) GROUP BY 1
            ) descartados ON (descartados.datacadastro = d._date)
            
            LEFT JOIN (
                SELECT COUNT(DISTINCT ultimododiaalta.carteiracpf) AS qtdalta, DATE_FORMAT(pa.data_alta, '%Y-%m-%d') AS datacadastro, pa.prontuarioatendimentoid FROM (
                    SELECT e.* FROM entradapacientes e 
                    INNER JOIN (
                    SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes GROUP BY DATE_FORMAT(`datacadastro`, '%Y-%m-%d'), carteiracpf) a ON (a.entradapacientesid = e.entradapacientesid)  
            
                    WHERE (alta = 1)
                    ) ultimododiaalta 
                
                INNER JOIN prontuarioatendimento AS pa ON (pa.prontuarioatendimentoid = ultimododiaalta.prontuarioatendimentoid) 

                INNER JOIN (SELECT MIN(entradapacientesid) AS entradapacientesid FROM (
                    SELECT e.* FROM entradapacientes e 
                    INNER JOIN (
                    SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes GROUP BY DATE_FORMAT(`datacadastro`, '%Y-%m-%d'), carteiracpf) a ON (a.entradapacientesid = e.entradapacientesid)  
            
                    WHERE alta = 1) b GROUP BY b.carteiracpf
                ) primeirodiaalta ON ( ultimododiaalta.entradapacientesid = primeirodiaalta.entradapacientesid)
                GROUP BY 2 
            ) alta ON (d._date = alta.datacadastro)

            LEFT JOIN (
                SELECT COUNT(DISTINCT ultimododiaobito.carteiracpf) AS qtdobito, DATE_FORMAT(pa.data_obito, '%Y-%m-%d') AS datacadastro, pa.prontuarioatendimentoid FROM (
                    SELECT e.* FROM entradapacientes e 
                    INNER JOIN (
                    SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes GROUP BY DATE_FORMAT(`datacadastro`, '%Y-%m-%d'), carteiracpf) a ON (a.entradapacientesid = e.entradapacientesid)  
            
                    WHERE (obito = 1)
                    ) ultimododiaobito 
                    
                INNER JOIN prontuarioatendimento AS pa ON (pa.prontuarioatendimentoid = ultimododiaobito.prontuarioatendimentoid) 

                INNER JOIN (SELECT MIN(entradapacientesid) AS entradapacientesid FROM (
                    SELECT e.* FROM entradapacientes e 
                    INNER JOIN (
                    SELECT MAX(entradapacientesid) as entradapacientesid FROM entradapacientes GROUP BY DATE_FORMAT(`datacadastro`, '%Y-%m-%d'), carteiracpf) a ON (a.entradapacientesid = e.entradapacientesid)  
            
                    WHERE obito = 1) b GROUP BY b.carteiracpf
                ) primeirodiaobito ON ( ultimododiaobito.entradapacientesid = primeirodiaobito.entradapacientesid)
                GROUP BY 2 
            ) obito ON (d._date = obito.datacadastro)
            WHERE CONCAT(COALESCE(confirmados.qtdconfirmados, 0),COALESCE(internados.qtdinternados, 0),COALESCE(alta.qtdalta, 0)) <> '000'
            ORDER BY 1 
            ");
        $qtdinternados = [];
        $qtdconfirmados = [];
        $qtdsuspeitos = [];
        $qtddescartados = [];
        $qtdalta = [];
        $qtdinternadosacum = [];
        $qtdconfirmadosacum = [];
        $qtdsuspeitosacum = [];
        $qtddescartadosacum = [];
        $qtdobitossacum = [];
        $qtdaltaacum = [];
        $acuminternados = 0;
        $dataatendimento = [];
        $acumconfirmados = 0;
        $acumsuspeitos = 0;
        $acumdescartados = 0;
        $acumalta = 0;
        $acumobito = 0;
        foreach ($internadoseconfirmadosdia as $item) {
            $acuminternados = $acuminternados + $item->qtdinternados;
            $acumconfirmados = $acumconfirmados + $item->qtdconfirmados;
            $acumdescartados = $acumdescartados + $item->qtddescartados;
            $acumobito = $acumobito + $item->qtdobito;
            $acumsuspeitos = $acumsuspeitos + $item->qtdsuspeitos;
            $acumalta = $acumalta + $item->qtdalta;
            array_push($qtdinternados, $item->qtdinternados);
            array_push($qtdconfirmados, $item->qtdconfirmados);
            array_push($qtdsuspeitos, $item->qtdsuspeitos);
            array_push($qtddescartados, $item->qtddescartados);
            array_push($qtdalta, $item->qtdalta);
            array_push($qtdobitossacum, $acumobito);
            array_push($qtdinternadosacum, $acuminternados);
            array_push($qtdconfirmadosacum, $acumconfirmados);
            array_push($qtddescartadosacum, $acumdescartados);
            array_push($qtdsuspeitosacum, $acumsuspeitos);
            array_push($qtdaltaacum, $acumalta);
            array_push($dataatendimento, $this->formatData($item->datacadastro));
            }

        $this->set(compact([
            'hospitais'
            ,'pacientes'
            ,'corona'
            ,'uti'
            ,'leitosenfgeral'
            ,'leitosutigeral'
            //,'leitos'
            ,'enfgeral'
            ,'geralenfermaria'
            ,'unimedenfermaria'
            ,'enfermariasusp'
            ,'enfermariaconf'
            ,'geraluti'
            ,'unimeduti'
            ,'confirmados'
            ,'utisuspeitos'
            ,'uticonfirmados'
            ,'internados'
            ,'totalprestadores'
            ,'suspeitos'
            ,'estado'
            ,'municipios'
            ,'empresa'
            ,'enfconfirmados'
            ,'enfsuspeitos'
            ,'acompanhamentos'
            ,'dataatendimento'
            ,'qtdinternados'
            ,'qtdconfirmados'
            ,'qtdinternadosacum'
            ,'qtdconfirmadosacum'
            ,'qtdalta'
            ,'qtdaltaacum'
            ,'ventilacao'
            ,'qtdsuspeitos'
            ,'qtddescartados'
            ,'qtdsuspeitosacum'
            ,'qtddescartadosacum'
            ,'qtdobitossacum'
            ,'enfermaria'
            ,'uci'
            ,'ucisuspeitos'
            ,'uciconfirmados'
        ]));
    }

    public function edicaomodal($id) {
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        $hospitais = $this->getAllTableWhere('Hospital',['hospitalid '.$hospitalquery]);
        $paciente = $this->get("Entradapacientes",'entradapacientesid',$id);    
        $gruposderisco = $this->getAllTableWhere("Paciente_gruporisco",["entradapacientesid"=>$id],[]); 
        $gruposrisco = [];
        $date = '';
        if (null !== $paciente->data_ultimotratamento) {
            $date = (get_object_vars($paciente->data_ultimotratamento)['date']);
            $date = explode(" ", $date);
            $date = $date[0];
        }
        if($paciente->gruporisco != null) {
            array_push($gruposrisco,$paciente->gruporisco);
        } else {
            foreach ($gruposderisco as $gruporisco) {
                array_push($gruposrisco, $gruporisco->gruporisco);
            }   
        }
        $estado = $empresa->estado;
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $tabelaentrada = TableRegistry::get('Entradapacientes');
            $gruporiscoTable = TableRegistry::get('Paciente_gruporisco');
            $entrada = $tabelaentrada->newEntity();
            $entrada->tipo = $data['tipo'];
            $entrada->carteiracpf = $data['carteiracpf'];
            $entrada->local = $data['local'];
            $entrada->hospitalid = $data['hospitalid'];
            $entrada->observacao = $data['observacao'];
            $entrada->codigoteste = $data['codigoteste'];
            $entrada->data_ultimotratamento = $data['data_ultimotratamento'];
            $entrada->ultimotratamento = $data['ultimotratamento'];
            $entrada->datacadastro = Date('Y-m-d H:i:s');
            $entrada->testecolhido = (array_key_exists('testecolhido',$data)) ? 1 : 0;
            $entrada->alta = (array_key_exists('alta',$data)) ? 1 : 0;
            $entrada->ventilacao = (array_key_exists('ventilacao',$data)) ? 1 : 0;
            $entrada->usuariocadastro = $usuario->idusuario;
            if (!$tabelaentrada->save($entrada)) {
                $this->Flash->error("Não foi possível salvar o Paciente");
            } else {
                $grupos = $this->getAllTableWhere('Paciente_gruporisco',['entradapacientesid'=>$id],[]);
                foreach ($grupos as $grupo) {
                    $gruporiscoTable->delete($grupo);
                }
                if (array_key_exists('gruporisco',$data)) {
                    foreach ($data['gruporisco'] as $gruporisco) {
                        $pacientegruporisco = $gruporiscoTable->newEntity();
                        $pacientegruporisco->gruporisco = $gruporisco;
                        $pacientegruporisco->entradapacientesid = $entrada->entradapacientesid;
                        $gruporiscoTable->save($pacientegruporisco);
                    }
                    $this->Flash->success("Paciente Editado com Sucesso!");
                }
            }
            return $this->redirect(['action'=>'hospitaisentrada']);
        }
        $this->set(compact([
            'paciente'
            ,'hospitais'
            ,'gruposrisco'
            ,'date'
        ]));
    }


        public function central24h() {
            
            $empresa = $this->sessionread('login.empresa');
            $mesAtual = Date('m');
            $ligacoespordia = $this->query(
                "SELECT
                SUM(l.a)/count(1) AS 'ligacoespordia'
                FROM (
                    SELECT 
                        DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                        ,COUNT(1) AS a
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa 
                    GROUP BY 1
                    ) l 
                "
            );
            $ligacoesnomes = $this->query(
                "SELECT
                SUM(l.a) AS 'ligacoesmes'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa AND DATE_FORMAT(`datahora_atendimento`, '%Y-%m') = '2020-$mesAtual'
                    ) l 
                "
            );
            $covidnomes = $this->query(
                "SELECT
                SUM(l.a) AS 'covidnomes'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa
                    ) l 
                "
            );
            $covidgrave = $this->query(
                "SELECT
                SUM(l.a) AS 'covidgrave'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento24h
                    WHERE
                    UPPER(motivo) LIKE '%GRAVE%'
                    ) l 
                "
            );
            $dataAtual = Date('Y-m-d');
            $covidgravehoje = $this->query(
                "SELECT
                SUM(l.a) AS 'covidgrave'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento24h
                    WHERE
                    UPPER(motivo) LIKE '%GRAVE%'
                    AND DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') = '$dataAtual'
                    ) l 
                "
            );
            $ligacoes = $this->getAllTableWhere('Atendimento24h', ['codunimed'=>$empresa->idempresa],[]);
            $top20 = $this->query(
                "
                    SELECT atendenteid, count(*) AS ligacoes, 
                        SUM(CASE WHEN UPPER(motivo) LIKE '%GRAVE%' OR UPPER(motivo) LIKE '%LEVE%' THEN 1 ELSE 0 END) AS corona
                    FROM atendimento24h
                    WHERE 
                    codunimed = $empresa->idempresa
                    GROUP BY atendenteid
                    ORDER BY 2 DESC 
                    LIMIT 20
                "
            );
    
            $quantidadeatendimentos = $this->query(
                "SELECT
                SUM(l.a)/count(1) AS '0-3'
                ,SUM(l.b)/count(1) AS '3-6'
                ,SUM(l.c)/count(1) AS '6-9'
                ,SUM(l.d)/count(1) AS '9-12'
                ,SUM(l.e)/count(1) AS '12-15'
                ,SUM(l.f)/count(1) AS '15-18'
                ,SUM(l.g)/count(1) AS '18-21'
                ,SUM(l.h)/count(1) AS '21-24'
                FROM (
                    SELECT 
                        DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 3 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 0 ) THEN 1 ELSE 0 END) AS a
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 6 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 3 ) THEN 1 ELSE 0 END) AS b
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 9 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 6 ) THEN 1 ELSE 0 END) AS c
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 12 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 9 ) THEN 1 ELSE 0 END) AS d
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 15 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 12 ) THEN 1 ELSE 0 END) AS e
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 18 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 15 ) THEN 1 ELSE 0 END) AS f
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 21 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 18 ) THEN 1 ELSE 0 END) AS g
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 24 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 21 ) THEN 1 ELSE 0 END) AS h
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa 
                    GROUP BY 1
                    ) l
                "
            );
            $quantidadeatendimentoshoje = $this->query(
                "SELECT
                SUM(l.a) AS '0-3'
                ,SUM(l.b) AS '3-6'
                ,SUM(l.c) AS '6-9'
                ,SUM(l.d) AS '9-12'
                ,SUM(l.e) AS '12-15'
                ,SUM(l.f) AS '15-18'
                ,SUM(l.g) AS '18-21'
                ,SUM(l.h) AS '21-24'
                FROM (
                    SELECT 
                        DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 3 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 0 ) THEN 1 ELSE 0 END) AS a
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 6 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 3 ) THEN 1 ELSE 0 END) AS b
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 9 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 6 ) THEN 1 ELSE 0 END) AS c
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 12 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 9 ) THEN 1 ELSE 0 END) AS d
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 15 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 12 ) THEN 1 ELSE 0 END) AS e
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 18 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 15 ) THEN 1 ELSE 0 END) AS f
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 21 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 18 ) THEN 1 ELSE 0 END) AS g
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 24 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 21 ) THEN 1 ELSE 0 END) AS h
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa AND DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') = '$dataAtual'
                    GROUP BY 1
                    ) l
                "
            );
            $atendimentospordia = $this->query(
                "SELECT 
                    DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                    ,DATE_FORMAT(`datahora_atendimento`, '%m') AS mes
                    ,DAY(`datahora_atendimento`) AS dia
                    ,COUNT(1) AS total
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa
                    GROUP BY 1   ORDER BY 1 ASC    
                "
            );
            $media = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $atendimentospordiamedia = $this->query(
                "SELECT 
                    a.dia, SUM(a.total)/COUNT(*) as media FROM 
                    (SELECT
                        DATE_FORMAT(`datahora_atendimento`, '%m') AS mes
                        ,DAY(`datahora_atendimento`) AS dia
                        ,COUNT(1) AS total
                        FROM atendimento24h
                        WHERE codunimed = $empresa->idempresa
                        GROUP BY 1,2  ORDER BY 1 ASC
                    ) a
                    GROUP BY 1
                "
            );
            foreach ($atendimentospordiamedia as $item) {
                $media[$item->dia -1] = $item->media;
            }
            $totalatendidohoje = $this->query(
                "SELECT 
                    COUNT(1) AS total
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa AND DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') = '$dataAtual'
                    ORDER BY 1 ASC    
                "
            );
            $meses = $this->query(
                "SELECT DISTINCT
                    DATE_FORMAT(`datahora_atendimento`, '%m') AS mes
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa  
                "
            );
            $jandiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $fevdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $mardiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $abrdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $maidiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jundiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $juldiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $agodiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $setdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $outdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $novdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $dezdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jan = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $fev = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $mar = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $abr = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $mai = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jun = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jul = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $ago = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $set = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $out = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $nov = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $dez = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $janacum = 0;
            $fevacum = 0;
            $maracum = 0;
            $abracum = 0;
            $maiacum = 0;
            $junacum = 0;
            $julacum = 0;
            $agoacum = 0;
            $setacum = 0;
            $outacum = 0;
            $novacum = 0;
            $dezacum = 0;
            foreach ($atendimentospordia as $item) {
                if ($item->mes == '01') {
                    $jan[$item->dia -1] = $item->total + $janacum;
                    $jandiario[$item->dia -1] = $item->total;
                    $janacum = $jan[$item->dia -1];
                }
                if ($item->mes == '02') {
                    $fev[$item->dia -1] = $item->total + $fevacum;
                    $fevdiario[$item->dia -1] = $item->total;
                    $fevacum = $fev[$item->dia -1];
                }
                if ($item->mes == '03') {
                    $mar[$item->dia -1] = $item->total + $maracum;
                    $mardiario[$item->dia -1] = $item->total;
                    $maracum = $mar[$item->dia -1];
                }
                if ($item->mes == '04') {
                    $abr[$item->dia -1] = $item->total + $abracum;
                    $abrdiario[$item->dia -1] = $item->total;
                    $abracum = $abr[$item->dia -1];
                }
                if ($item->mes == '05') {
                    $mai[$item->dia -1] = $item->total + $maiacum;
                    $maidiario[$item->dia -1] = $item->total;
                    $maiacum = $mai[$item->dia -1];
                }
                if ($item->mes == '06') {
                    $jun[$item->dia -1] = $item->total + $junacum;
                    $jundiario[$item->dia -1] = $item->total;
                    $junacum = $jun[$item->dia -1];
                }
                if ($item->mes == '07') {
                    $jul[$item->dia -1] = $item->total + $julacum;
                    $juldiario[$item->dia -1] = $item->total;
                    $julacum = $jul[$item->dia -1];
                }
                if ($item->mes == '08') {
                    $ago[$item->dia -1] = $item->total + $agoacum;
                    $agodiario[$item->dia -1] = $item->total;
                    $agoacum = $ago[$item->dia -1];
                }
                if ($item->mes == '09') {
                    $set[$item->dia -1] = $item->total + $setacum;
                    $setdiario[$item->dia -1] = $item->total;
                    $setacum = $set[$item->dia -1];
                }
                if ($item->mes == '10') {
                    $out[$item->dia -1] = $item->total + $outacum;
                    $outdiario[$item->dia -1] = $item->total;
                    $outacum = $out[$item->dia -1];
                }
                if ($item->mes == '11') {
                    $nov[$item->dia -1] = $item->total + $novacum;
                    $novdiario[$item->dia -1] = $item->total;
                    $novacum = $nov[$item->dia -1];
                }
                if ($item->mes == '12') {
                    $dez[$item->dia -1] = $item->total + $dezacum;
                    $dezdiario[$item->dia -1] = $item->total;
                    $dezacum = $dez[$item->dia -1];
                }
            }
            $listameses = ['jan','fev','mar','abr','mai','jun','jul','ago','set','out','nov','dez'];
            for ($i = 1; $i < 31; $i++) {
                foreach ($listameses as $mes) {
                    if (${$mes}[$i] == 0) {
                        ${$mes}[$i] = ${$mes}[$i-1];
                    }
                }
            }
            
            $ligacoes = (object) [];
            $motivos = $this->query(
                "SELECT CASE WHEN UPPER(motivo) LIKE '%GRAVE%' THEN 'GRAVE'
                WHEN UPPER(motivo) LIKE '%LEVE%' THEN 'LEVE'
                ELSE 'NÃO SUSPEITO' END AS motivo, COUNT(*) AS total
                FROM atendimento24h WHERE codunimed = $empresa->idempresa
                GROUP BY 1
                "
            );
            $somatotal = 0;
            foreach ($motivos as $item) {
                $somatotal += $item->total;
            }
            $motivosgrafico = $this->query(
                "SELECT SUM(CASE WHEN UPPER(motivo) LIKE '%LEVE%' THEN 1 ELSE 0 END) AS 'LEVE'
                        ,SUM(CASE WHEN UPPER(motivo) LIKE '%GRAVE%' THEN 1 ELSE 0 END) AS 'GRAVE'
                        ,SUM(CASE WHEN UPPER(motivo) LIKE '%SUSP%' THEN 1 ELSE 0 END) AS 'SUSP'
                ,DATE_FORMAT(`datahora_atendimento`, '%d/%m/%Y') AS data
                ,`datahora_atendimento`
                FROM atendimento24h WHERE codunimed = $empresa->idempresa
                GROUP BY 4
                ORDER BY 5
                "
            );
            $grave = [];
            $leve = [];
            $suspeito = [];
            $dataatendimento = [];
            foreach ($motivosgrafico as $item) {
                array_push($leve, $item->LEVE);
                array_push($grave, $item->GRAVE);
                array_push($suspeito, $item->SUSP);
                array_push($dataatendimento, $item->data);
            }
            $beneficiarios = $this->query(
                "SELECT a.paciente, a.motivos, b.atendimento24hid, b.total FROM 
                (SELECT a.paciente, COUNT(*) AS motivos
                FROM (SELECT DISTINCT paciente, motivo, codunimed FROM atendimento24h) a 
                WHERE codunimed = $empresa->idempresa
                GROUP BY 1) a 
                INNER JOIN (
                SELECT paciente, atendimento24hid, COUNT(*) AS total
                FROM atendimento24h WHERE codunimed = $empresa->idempresa
                GROUP BY 1) b ON (a.paciente = b.paciente)
                "
            );
            $ultimaintegracao = $this->query("SELECT MAX(data_integracao) as dataintegracao FROM atendimento24h")[0]->dataintegracao;
            $this->set(compact([
                'ligacoes'
                ,'ultimaintegracao'
                ,'empresa'
                ,'top20'
                ,'quantidadeatendimentos'
                ,'quantidadeatendimentoshoje'
                ,'ligacoesnomes'
                ,'ligacoespordia'
                ,'covidnomes'
                ,'jan'
                ,'fev'
                ,'mar'
                ,'abr'
                ,'mai'
                ,'jun'
                ,'jul'
                ,'ago'
                ,'set'
                ,'out'
                ,'nov'
                ,'dez'
                ,'jandiario'
                ,'fevdiario'
                ,'mardiario'
                ,'abrdiario'
                ,'maidiario'
                ,'jundiario'
                ,'juldiario'
                ,'agodiario'
                ,'setdiario'
                ,'outdiario'
                ,'novdiario'
                ,'dezdiario'
                ,'ligacoes'
                ,'totalatendidohoje'
                ,'motivos'
                ,'beneficiarios'
                ,'media'
                ,'leve'
                ,'grave'
                ,'suspeito'
                ,'dataatendimento'
                ,'somatotal'
                ,'covidgrave'
                ,'covidgravehoje'
            ]));
        }

    public function tabelamodalpaciente($atendimento24hid) {
        $empresa = $this->sessionread('login.empresa');
        $paciente = $this->get('Atendimento24h','atendimento24hid', $atendimento24hid)->paciente;
        $resumo = $this->query(
            "SELECT datahora_atendimento, atendimento24hid, atendenteid, reg_relato, motivo, codorigem FROM atendimento24h
            WHERE codunimed = $empresa->idempresa AND paciente = '$paciente' ORDER BY 1 DESC
            "
        );
        $this->set(compact([
            'resumo',
            'paciente'
        ]));
    }

    public function tabelamodalcard($tipo) {
        $empresa = $this->sessionread('login.empresa');
        $dataAtual = Date('Y-m-d');
        $mesAtual = Date('m');
        $header = "Resumo das Informações";
        switch ($tipo){
            case 'hoje':
                $resumo = $this->query(
                    "SELECT datahora_atendimento, atendimento24hid, atendenteid, reg_relato, motivo, codorigem, CONCAT(paciente,' (',telefonepac_solicitante, ')') AS paciente
                        FROM atendimento24h
                        WHERE codunimed = $empresa->idempresa AND DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') = '$dataAtual'
                        ORDER BY 1 DESC    
                    "
                );
                $header = "Resumo dos Atendimentos Realizados Hoje";
                $title = "Atendimentos do Dia";
                break;
            case 'mes':
                $resumo = $this->query(
                    "SELECT datahora_atendimento, atendimento24hid, atendenteid, reg_relato, motivo, codorigem, CONCAT(paciente,' (',telefonepac_solicitante, ')') AS paciente
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa AND DATE_FORMAT(`datahora_atendimento`, '%Y-%m') = '2020-$mesAtual' ORDER BY 1 DESC
                    "
                );
                $header = "Resumo dos Atendimentos do Mês";
                $title = "Atendimentos do Mês";
                break;
            case 'corona':
                $resumo = $this->query(
                    "SELECT datahora_atendimento, atendimento24hid, atendenteid, reg_relato, motivo, codorigem, CONCAT(paciente,' (',telefonepac_solicitante, ')') AS paciente
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa
                    ORDER BY 1 DESC
                    "
                );
                $header = "Todos os Atendimentos";
                $title = "Todos os Atendimentos";
                break;
            case 'grave':
                $resumo = $this->query(
                    "SELECT datahora_atendimento, atendimento24hid, atendenteid, reg_relato, motivo, codorigem, CONCAT(paciente,' (',telefonepac_solicitante, ')') AS paciente
                    FROM atendimento24h
                    WHERE codunimed = $empresa->idempresa
                    AND UPPER(motivo) like '%GRAVE%' 
                    ORDER BY 1 DESC
                    "
                );
                $header = "Atendimentos COVID-19 Classificados como Grave";
                $title = "Atendimentos COVID-19 Classificados como Grave";
                break;
        }
        $this->set(compact([
            'resumo',
            'tipo',
            'header',
            'title'
        ]));
    }

    public function acompanhamentos() {
        $empresa = $this->sessionread('login.empresa');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $usuario = $this->sessionread('login.usuario');
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        $hospitais = $this->getAllTableWhere('Hospital',['hospitalid '.$hospitalquery]);
        $acompanhamentos = $this->query("SELECT * FROM acompanhamentocasos ac INNER JOIN (SELECT MAX(acompanhamentocasosid) as id FROM acompanhamentocasos GROUP BY hospital) a ON (a.id = ac.acompanhamentocasosid) WHERE hospitalid $hospitalquery");
        if ($this->request->is('post')) {
            //salvar os dados
            $data = $this->request->getData();
            $acompanhamentocasosTable = TableRegistry::get('acompanhamentocasos');
            $acomp = $acompanhamentocasosTable->newEntity();
            
            $acomp->hospital = $data['hospital'];
            $acomp->hospitalid = $this->get("Hospital",'nomefantasia',$data['hospital'])->hospitalid;
            $acomp->enfgeral = $data['enfgeral'];
            $acomp->enfunimed = $data['enfunimed'];
            $acomp->utiadgeral = $data['utiadgeral'];
            $acomp->utiadunimed = $data['utiadunimed'];
            $acomp->ucigeral = $data['ucigeral'];
            $acomp->uciunimed = $data['uciunimed'];
            $acomp->utipgeral = $data['utipgeral'];
            $acomp->utipunimed = $data['utipunimed'];
            $acomp->enfcovidsusp = $data['enfcovidsusp'];
            $acomp->enfcovidconf = $data['enfcovidconf'];
            $acomp->uticovidsusp = $data['uticovidsusp'];
            $acomp->uticovidconf = $data['uticovidconf'];
            $acomp->ucicovidsusp = $data['ucicovidsusp'];
            $acomp->ucicovidconf = $data['ucicovidconf'];
            $acomp->utipcovidsusp = $data['utipcovidsusp'];
            $acomp->utipcovidconf = $data['utipcovidconf'];
            $acomp->observacao = $data['observacao'];
            $acomp->usuariocadastro = $usuario->nome.' '.$usuario->idusuario;
            if (!$acompanhamentocasosTable->save($acomp)) {
                $this->Flash->error("Não foi possível salvar o Paciente");
            } else {
                $this->Flash->success("Informações Atualizadas com Sucesso!");
            }
            return $this->redirect(['action'=>'hospitaisentrada']);
        }
        $this->set(compact([
            'acompanhamentos'
            ,'hospitais'
            ,'perfil'
        ]));
    }


    public function hospitaisentrada($edicao = null) {
        $modulos = $this->sessionread('login.modulos');
        $modulosuser = [];
        foreach ($modulos as $modulo) {
            array_push($modulosuser,$modulo->chave);
        }
        if (!in_array('hospital',$modulosuser)) {
            return $this->redirect($this->referer());
        }
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        $hospitais = $this->getAllTableWhere('Hospital',['hospitalid '.$hospitalquery]);
        $pacientes = $this->query(
            " SELECT pa.*, hosp.nomefantasia, GROUP_CONCAT(pg.gruporisco) AS grupo_risco, ep.observacao, ep.datacadastro, GROUP_CONCAT(ao.observacao) AS observacaoauditoria FROM prontuarioatendimento pa
              LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)
              LEFT JOIN entradapacientes ep ON (ep.entradapacientesid = pa.entradapacienteid_gruporisco)
              LEFT JOIN auditoriaobservacao ao ON (ao.entradapacientesid = ep.entradapacientesid)
              LEFT JOIN hospital hosp ON (hosp.hospitalid = pa.hospitalid)
              WHERE pa.hospitalid $hospitalquery
              GROUP BY pa.prontuarioatendimentoid
            "
        );
        if ($this->request->is('post')) {
            //buscar prontuario aberto, ou criar um novo caso nao exista
            $data = $this->request->getData();
            $prontuarioAtendimentoTable = TableRegistry::get('Prontuarioatendimento');
            $prontuarios = $this->getAllTableWhere('Prontuarioatendimento',['carteiracpf'=>$data['carteiracpf'], 'fimprontuario'=>0],[])->all();
            if (count($prontuarios) == 0) {
                //criar novo
                $prontuario = $prontuarioAtendimentoTable->newEntity();
                $prontuario->carteiracpf = $data['carteiracpf'];
                $prontuario->data_entrada = Date('Y-m-d H:i:s');
                $prontuario->hospitalid = $data['hospitalid'];
                $prontuario->usuarioidcadastro = $usuario->idusuario;
                $prontuario->usuarionomecadastro = $usuario->nome;
                $prontuario = $prontuarioAtendimentoTable->save($prontuario);
            } else {
                //usar o primeiro (Não deve ter mais de um)
                $prontuario = $this->getAllTableWhere('Prontuarioatendimento',['carteiracpf'=>$data['carteiracpf'], 'fimprontuario'=>0],[])->first();
            }
            $tabelaentrada = TableRegistry::get('Entradapacientes');
            $gruporiscoTable = TableRegistry::get('Paciente_gruporisco');
            $entrada = $tabelaentrada->newEntity();
            $entrada->tipo = $data['tipo'];
            $entrada->prontuarioatendimentoid = $prontuario->prontuarioatendimentoid;
            $entrada->carteiracpf = $data['carteiracpf'];
            $entrada->local = $data['local'];
            $entrada->hospitalid = $data['hospitalid'];
            $entrada->observacao = $data['observacao'];
            $entrada->usuariocadastro = $usuario->idusuario;//'('.$usuario->idusuario.') '.$usuario->nome;
            $entrada->usuariocadastronome = $usuario->nome;
            $entrada->codigoteste = $data['codigoteste'];
            $entrada->testecolhido = (array_key_exists('testecolhido',$data)) ? 1 : 0;
            $entrada->alta = (array_key_exists('alta',$data)) ? 1 : 0;
            $entrada->dataalta = $data['dataalta'];
            $entrada->obito = (array_key_exists('obito',$data)) ? 1 : 0;
            $entrada->dataobito = $data['dataobito'];
            $entrada->ventilacao = (array_key_exists('ventilacao',$data)) ? 1 : 0;
            $vent = (array_key_exists('ventilacao',$data)) ? 1 : 0;
            $entrada->auditado = $edicao == null ? 0 : $edicao;
            if ($edicao == 1) {
                if ($entrada->ventilacao) {
                    $entrada->tiposuporte = $data['tiposuporte'];
                    if ($entrada->tiposuporte != 'Ventilação Mecânica') {
                        $vent = 0;
                    }
                    $entrada->descricaosuporte = $data['descricaosuporte'];
                }
                $entrada->antibiotico = (array_key_exists('antibiotico',$data)) ? 1 : 0;
                if ($entrada->antibiotico) {
                    $entrada->antibioticonome = $data['antibioticonome'];
                }
                $entrada->parecer = (array_key_exists('parecer',$data)) ? 1 : 0;
                if ($entrada->parecer) {
                    $entrada->especialidademedica = $data['especialidademedica'];
                }
                $entrada->hemodialise = (array_key_exists('hemodialise',$data)) ? 1 : 0;
                $entrada->imunobiologicos = (array_key_exists('imunobiologicos',$data)) ? 1 : 0;
                if ($entrada->imunobiologicos) {
                    $entrada->imunobiologicosnome = $data['imunobiologicosnome'];
                }
                if ($entrada->testecolhido) {
                    $entrada->datacoleta = $data['datacoleta'];
                }
                $prontuario->fimprontuario = (array_key_exists('fimprontuario',$data)) ? 1 : 0;
            } else {
                $prontuario->fimprontuario = 0;
            }
            $entrada->auditado = $edicao == null ? 0 : $edicao;
            $entrada = $tabelaentrada->save($entrada);
            if (!$entrada) {
                $this->Flash->error("Não foi possível salvar o Paciente");
            } else {
                foreach ($data['gruporisco'] as $gruporisco) {
                    $pacientegruporisco = $gruporiscoTable->newEntity();
                    $pacientegruporisco->gruporisco = $gruporisco;
                    $pacientegruporisco->entradapacientesid = $entrada->entradapacientesid;
                    $gruporiscoTable->save($pacientegruporisco);
                }

                $prontuario->entradapacienteid_gruporisco = $entrada->entradapacientesid;
                $prontuario->ventilacao = $vent;
                $prontuario->testecolhido = (array_key_exists('testecolhido',$data)) ? 1 : 0;
                $prontuario->codigoteste = $data['codigoteste'];
                $prontuario->tipo = $data['tipo'];
                $prontuario->local = $data['local'];
                $prontuario->sexo = $data['sexo'];
                $prontuario->nome = $data['nome'];
                $prontuario->data_nascimento = $data['data_nascimento'];

                $prontuario->alta = (array_key_exists('alta',$data)) ? 1 : 0;
                $prontuario->data_alta = $data['dataalta'];
                $prontuario->obito = (array_key_exists('obito',$data)) ? 1 : 0;
                $prontuario->data_obito = $data['dataobito'];
                if ($prontuario->fimprontuario) {
                    $prontuario->data_saida = Date('Y-m-d H:i:s');
                }
                $prontuario = $prontuarioAtendimentoTable->save($prontuario);

                if (!$prontuario) {
                    $this->Flash->error("Não foi possível Atualizar o Prontuário!");
                } else {
                }
            }
            if ($edicao == 1) {
                $this->Flash->success("Paciente Auditado com Sucesso!");
                return $this->redirect(['controller'=>'auditoria','action'=>'index']);
            } else {
                $this->Flash->success("Paciente Cadastrado com Sucesso!");
                return $this->redirect(['action'=>'hospitaisentrada']);
            }
        }

        $this->set(compact([
            'pacientes'
            ,'empresa'
            ,'hospital'
            ,'hospitais'
            ,'suspeitos'
            ,'confirmados'
            ,'descartados'
            ,'altas'
            ,'perfil'
        ]));
    }

    public function entradapaciente($modal = null, $prontuarioatendimentoid = null, $edicao = null) {
        $modulos = $this->sessionread('login.modulos');
        $modulosuser = [];
        foreach ($modulos as $modulo) {
            array_push($modulosuser,$modulo->chave);
        }
        if (!in_array('hospital',$modulosuser)) {
            return $this->redirect($this->referer());
        }
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";
        $hospitais = $this->getAllTableWhere('Hospital',['hospitalid '.$hospitalquery]);
        $atendimento = TableRegistry::get('Prontuarioatendimento')->newEntity();
        $prontuario = TableRegistry::get('Prontuarioatendimento')->newEntity();
        $grupo_risco = [];
        $data_alta = '';
        $data_obito = '';
        $data_nascimento = '';
        if ($prontuarioatendimentoid != null) {
            $prontuario = $this->get('Prontuarioatendimento','prontuarioatendimentoid',$prontuarioatendimentoid);
            $atendimento = $this->get('Entradapacientes', 'entradapacientesid', $prontuario->entradapacienteid_gruporisco);
            $grupo_risco2 = $this->getAllTableWhere('Paciente_gruporisco',['entradapacientesid'=>$atendimento->entradapacientesid],[]);
            foreach ($grupo_risco2 as $item) {
                array_push($grupo_risco, $item->gruporisco);
            }
            if ($prontuario->data_alta != null) {
                $data_alta = (get_object_vars($prontuario->data_alta)['date']);
                $data_alta = explode(" ", $data_alta);
                $data_alta = $data_alta[0];
            }
            if ($prontuario->data_obito != null) {
                $data_obito = (get_object_vars($prontuario->data_obito)['date']);
                $data_obito = explode(" ", $data_obito);
                $data_obito = $data_obito[0];
            }
            if ($prontuario->data_nascimento != null) {
                $data_nascimento = (get_object_vars($prontuario->data_nascimento)['date']);
                $data_nascimento = explode(" ", $data_nascimento);
                $data_nascimento = $data_nascimento[0];
            }
        }
        $this->set(compact([
            'perfil'
            ,'hospitais'
            ,'modal'
            ,'atendimento'
            ,'grupo_risco'
            ,'data_alta'
            ,'data_obito'
            ,'data_nascimento'
            ,'prontuario'
            ,'edicao'
            ]));
    }
    
    public function kanban($hospital = null, $carteirinha = null) {
        $empresa = $this->sessionread('login.empresa');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $hospitaisid = $this->sessionread('login.hospitais');
        $hospitalquery = "IN (".implode(',',$hospitaisid).")";   
        $hospitais = $this->getAllTableWhere('Hospital',['hospitalid '.$hospitalquery]);
        if ($hospital != "todos" && $hospital != null) {
            $hospitalquery = "= ".$hospital;   
        }
        if ($carteirinha != null) {
            $carteirinhaquery = "LIKE '%".$carteirinha."%'";
        } else {
            $carteirinhaquery = "LIKE '%'";
        }
        $internados = [];
        $altas = [];
        $obitos = [];
        $entradapacientes = 
            $this->query("SELECT pa.*, GROUP_CONCAT(pg.gruporisco) AS gruporisco FROM prontuarioatendimento pa
                          LEFT JOIN paciente_gruporisco pg ON (pa.entradapacienteid_gruporisco = pg.entradapacientesid)

                          WHERE pa.hospitalid $hospitalquery AND pa.carteiracpf $carteirinhaquery
                          AND pa.fimprontuario <> 1
                          GROUP BY pa.prontuarioatendimentoid");
        $internadouti = 0;
        $internadovent = 0;
        $internadotest = 0;
        $altauti = 0;
        $altavent = 0;
        $altatest = 0;
        $obitouti = 0;
        $obitovent = 0;
        $obitotest = 0;
        foreach ($entradapacientes as $item) {
            if ($item->obito == 1) {
                    $obitouti += ($item->local == 'UTI') ? 1 : 0;
                    $obitovent += $item->ventilacao;
                    $obitotest += $item->testecolhido;
                array_push($obitos,$item);
            } else if ($item->alta == 1) {
                    $altauti += ($item->local == 'UTI') ? 1 : 0;
                    $altavent += $item->ventilacao;
                    $altatest += $item->testecolhido;
               array_push($altas,$item);
            } else {
                if ( ($item->local != 'Isolamento Domiciliar') ) {
                    $internadouti += ($item->local == 'UTI') ? 1 : 0;
                    $internadovent += $item->ventilacao;
                    $internadotest += $item->testecolhido;
                    array_push($internados,$item);
                }
            }
        }
        $this->set(compact([
            'pacientes'
            ,'empresa'
            ,'internados'
            ,'altas'
            ,'obitos'
            ,'perfil'
            ,'internadouti'
            ,'internadovent'
            ,'internadotest'
            ,'altauti'
            ,'altavent'
            ,'altatest'
            ,'obitouti'
            ,'obitovent'
            ,'obitotest'
            ,'hospital'
            ,'hospitais'
            ,'carteirinha'
        ]));

    }

    public function modalentrada($id, $isrel = null) {
        if ($isrel == null) {
            $prontuario = $this->get('Prontuarioatendimento','prontuarioatendimentoid',$id);
        } else {
            $prontuario = $this->get('Prontuarioatendimento','entradapacienteid_gruporisco',$id);
        }
        $prontuarioatendimentoid = $prontuario->prontuarioatendimentoid;
        $ultimaentrada = $this->get('Entradapacientes','entradapacientesid',$prontuario->entradapacienteid_gruporisco);
        $carteiracpf = $ultimaentrada->carteiracpf;
        $resumo = $this->getAllTableWhere('Entradapacientes',['prontuarioatendimentoid'=>$prontuario->prontuarioatendimentoid],['datacadastro DESC'])->all();
        $this->set(compact([
            'resumo'
            ,'carteiracpf'
            ,'prontuarioatendimentoid'
        ]));
    }

    public function alterarkanban($obs, $tipo, $id) {
        $usuario = $this->sessionread('login.usuario');
        $tabelaentrada = TableRegistry::get('Entradapacientes');
        if ($tipo == 'Alta') {
            $entrada = $tabelaentrada->newEntity();
            $entradaantiga = $this->get("Entradapacientes",'entradapacientesid',$id);
            $entrada->observacao = $obs;
            $entrada->tipo = $entradaantiga->tipo;
            $entrada->hospitalid = $entradaantiga->hospitalid;
            $entrada->coduninmed = $entradaantiga->coduninmed;
            $entrada->carteiracpf = $entradaantiga->carteiracpf;
            $entrada->data_nascimento = $entradaantiga->data_nascimento;
            $entrada->sexo = $entradaantiga->sexo;
            $entrada->local = $entradaantiga->local;
            $entrada->gruporisco = $entradaantiga->gruporisco;
            $entrada->alta = 1;
            $entrada->usuariocadastro = $usuario->idusuario;
            $entrada->obito = 0;
            $entrada->ventilacao = $entradaantiga->ventilacao;
            $entrada->testecolhido = $entradaantiga->testecolhido;
        } else if ($tipo == 'Obito') {
            $entrada = $tabelaentrada->newEntity();
            $entradaantiga = $this->get("Entradapacientes",'entradapacientesid',$id);
            $entrada->observacao = $obs;
            $entrada->tipo = $entradaantiga->tipo;
            $entrada->hospitalid = $entradaantiga->hospitalid;
            $entrada->coduninmed = $entradaantiga->coduninmed;
            $entrada->carteiracpf = $entradaantiga->carteiracpf;
            $entrada->data_nascimento = $entradaantiga->data_nascimento;
            $entrada->sexo = $entradaantiga->sexo;
            $entrada->local = $entradaantiga->local;
            $entrada->gruporisco = $entradaantiga->gruporisco;
            $entrada->alta = $entradaantiga->alta;
            $entrada->ventilacao = $entradaantiga->ventilacao;
            $entrada->usuariocadastro = $usuario->idusuario;
            $entrada->testecolhido = $entradaantiga->testecolhido;
            $entrada->obito = 1;
        } else {
            $entrada = $tabelaentrada->newEntity();
            $entradaantiga = $this->get("Entradapacientes",'entradapacientesid',$id);
            $entrada->observacao = $obs;
            $entrada->tipo = $tipo;
            $entrada->hospitalid = $entradaantiga->hospitalid;
            $entrada->coduninmed = $entradaantiga->coduninmed;
            $entrada->carteiracpf = $entradaantiga->carteiracpf;
            $entrada->data_nascimento = $entradaantiga->data_nascimento;
            $entrada->sexo = $entradaantiga->sexo;
            $entrada->local = $entradaantiga->local;
            $entrada->gruporisco = $entradaantiga->gruporisco;
            $entrada->alta = 0;
            $entrada->obito = 0;
            $entrada->usuariocadastro = $usuario->idusuario;
            $entrada->ventilacao = $entradaantiga->ventilacao;
            $entrada->testecolhido = $entradaantiga->testecolhido;
        }
        if (!$tabelaentrada->save($entrada) ) {
            $this->response->body("Por favor, tente novamente.");
            return $this->response;
            exit();
        } else {
            $this->response->body("ok");
            return $this->response;
            exit();
        }
    }

    public function leitos(){
        if ($this->request->is('post')) {
            //salvar os dados
            $data = $this->request->getData();

            $tabelaleitos = TableRegistry::get('Hospitalleitos');
            $leitos = $tabelaleitos->newEntity();
            $leitos->enfermaria = $data['enfermaria'];
            $leitos->hospitalid = $data['hospital'];
            $leitos->enfadulto = 0;
            $leitos->enfpediatria = 0;
            $leitos->enfocup = 0;
            $leitos->enfcorona = $data['enfcorona'];
            $leitos->uti = 0;
            $leitos->utiadulto = $data['utiadulto'];
            $leitos->utipediatria = $data['utipediatria'];
            $leitos->utiocup = 0;
            $leitos->uticorona = $data['uticorona'];
            if (!$tabelaleitos->save($leitos)) {
                $this->Flash->error("Não foi possível salvar as informações dos Leitos");
            } else {
                $this->Flash->success("Leitos Cadastrados com Sucesso!");
            }
            return $this->redirect(['action'=>'leitos']);
        }    
        $hospitais = $this->getAllTableWhere('Hospital',[],[]); 
        $this->set(compact([
            'hospitais'
        ]));
    }


    public function idosos() {
        
    }
    public function internacoes() {
        
    }
    public function projecao() {
        
    }
    public function transportes() {
        
    }
    public function uti() {
        
    }

    public function importacaohospitais(){

        $nomearquivo = "estabelecimentos-240000.csv";
        $caminho_arquivo = "../../htdocs/flymed/$nomearquivo";
        $sql = " LOAD DATA INFILE \"$caminho_arquivo\"
        INTO TABLE hospital FIELDS TERMINATED BY ';' OPTIONALLY ENCLOSED BY '\"'
        LINES TERMINATED BY '\r\n' IGNORE 1 LINES
        (ibge, uf, municipio, cnes, nomefantasia, razaosocial, cnpjproprio, cnpjmantedora, tipogestao, logradouro, numero, bairro, cep, latitude, longitude)
        set codunimed = 1";

        $conn = mysqli_connect('localhost','root','','corpstek_flymed_unimednatal') or die (mysqli_error($conn));
        try{mysqli_query($conn,$sql) or die (mysqli_error($conn));} catch(\Exception $ex) {}
        exit();
    }

    public function buscarcarteiracpf($cpf) {
        $prontuarios = $this->getAllTableWhere('Prontuarioatendimento',['carteiracpf'=>$cpf, 'fimprontuario'=>0],[])->all();
        if (count($prontuarios) == 0) {
            $prontuarios = $this->getAllTableWhere('Prontuarioatendimento',['carteiracpf'=>ltrim($cpf,"0"), 'fimprontuario'=>0],[])->all();
        }
        $beneficiario_nome = $this->get('Beneficiario_nome','cpf',$cpf);
        if ($beneficiario_nome == null) {
            $beneficiario_nome = $this->get('Beneficiario_nome','cpf',ltrim($cpf,"0"));
        }
        if (count($prontuarios) == 0 && $beneficiario_nome == null) {
            $paciente = 'nenhuma resposta';
        } else {
            $prontuario = $this->getAllTableWhere('Prontuarioatendimento',['carteiracpf'=>$cpf, 'fimprontuario'=>0],[])->first();
            if ($prontuario == null) {
                $prontuario = (object) [];
                $paciente = (object) [];
                $gruposderisco = (object) [];
            } else {
                $paciente = $this->getAllTableWhere('Entradapacientes',['prontuarioatendimentoid'=>$prontuario->prontuarioatendimentoid],['datacadastro DESC'])->first();
                $gruposderisco = $this->getAllTableWhere("Paciente_gruporisco",["entradapacientesid"=>$paciente->entradapacientesid],[])->all(); 
            }
            if ($beneficiario_nome != null) {
                $prontuario->nome = $beneficiario_nome->nome;
                $prontuario->sexo = ($beneficiario_nome->sexo == 'M' ? 'Masculino' : 'Feminino');
            }
        }

        $this->set([
            'prontuario' => $prontuario,
            'paciente' => $paciente,
            'gruposderisco' => $gruposderisco,
            '_serialize' => ['paciente','gruposderisco','prontuario'],
        ]);
        $this->RequestHandler->renderAs($this, 'json');
    }

    public function painelcovid() {
        $data_ultima_atualizacao = $this->query("SELECT CAST(MAX(datacadastro) AS DATE) AS data_cadastro FROM entradapacientes")[0]->data_cadastro;
        $suspeitos = $this->query("SELECT COUNT(1) AS suspeitos, SUM(CASE WHEN (local = 'UTI' OR local = 'UCI' OR local = 'Enfermaria') AND obito <> 1 AND alta <> 1 AND fimprontuario <> 1 THEN 1 ELSE 0 END) AS internados FROM prontuarioatendimento WHERE tipo = 'Diag. Suspeito' AND obito <> 1");
        $descartados = $this->query("SELECT COUNT(1) AS descartados, SUM(CASE WHEN (local = 'UTI' OR local = 'UCI' OR local = 'Enfermaria') AND obito <> 1 AND alta <> 1 AND fimprontuario <> 1 THEN 1 ELSE 0 END) AS internados FROM prontuarioatendimento WHERE tipo = 'Descartado'");
        $confirmados = $this->query("SELECT COUNT(1) AS confirmados, SUM(CASE WHEN obito = 1 THEN 1 ELSE 0 END) AS obitos, SUM(CASE WHEN (local = 'UTI' OR local = 'UCI' OR local = 'Enfermaria') AND obito <> 1 AND alta <> 1 AND fimprontuario <> 1 THEN 1 ELSE 0 END) AS internados, SUM(CASE WHEN alta = 1 AND obito = 0 THEN 1 ELSE 0 END) AS recuperados FROM prontuarioatendimento WHERE tipo = 'Diag. Confirmado'");
        $internados = $this->query("SELECT SUM(CASE WHEN local = 'UTI' OR local = 'UCI' OR local = 'Enfermaria'  THEN 1 ELSE 0 END) AS internados, SUM(CASE WHEN local = 'UTI' THEN 1 ELSE 0 END) AS uti, SUM(CASE WHEN local = 'UTI' AND ventilacao = 1 THEN 1 ELSE 0 END) AS ventilacao, SUM(CASE WHEN local = 'UCI' THEN 1 ELSE 0 END) AS uci, SUM(CASE WHEN local = 'Enfermaria' THEN 1 ELSE 0 END) AS enfermaria FROM prontuarioatendimento WHERE tipo <> 'Descartado' AND alta <> 1 AND obito <> 1 AND fimprontuario <> 1");
        $tabelahospitais = $this->query("SELECT h.nomefantasia AS hospital, SUM(CASE WHEN pa.alta <> 1 AND pa.obito <> 1 AND pa.fimprontuario <> 1 AND (pa.local = 'UTI') THEN 1 ELSE 0 END) AS uti, 
        SUM(CASE WHEN pa.alta <> 1 AND pa.obito <> 1 AND fimprontuario <> 1 AND (pa.ventilacao = 1 AND pa.local = 'UTI') THEN 1 ELSE 0 END) AS ventilacao, 
        SUM(CASE WHEN pa.alta <> 1 AND pa.obito <> 1 AND fimprontuario <> 1 AND (pa.local = 'UCI') THEN 1 ELSE 0 END) AS uci, 
        SUM(CASE WHEN pa.alta <> 1 AND pa.obito <> 1 AND fimprontuario <> 1 AND (pa.local = 'Enfermaria') THEN 1 ELSE 0 END) AS enfermaria,  
        SUM(CASE WHEN pa.alta <> 1 AND pa.obito <> 1 AND fimprontuario <> 1 AND (pa.local = 'Enfermaria' OR pa.local = 'UTI' OR pa.local = 'UCI') THEN 1 ELSE 0 END) AS total, 
        CAST(MAX(ep.datacadastro) AS DATE) AS data_ultima_atualizacao 
        FROM prontuarioatendimento pa INNER JOIN hospital h ON h.hospitalid = pa.hospitalid INNER JOIN entradapacientes ep ON ep.entradapacientesid = pa.entradapacienteid_gruporisco
        WHERE pa.tipo <> 'Descartado'
        GROUP BY 1
        ");
        $this->set(compact([
            'data_ultima_atualizacao'
            ,'suspeitos'
            ,'descartados'
            ,'confirmados'
            ,'internados'
            ,'tabelahospitais'
        ]));
    }
}