<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use \stdClass;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;

/**
 * Gpad Controller
 *
 *
 * @method \App\Model\Entity\Dashboard[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class HomecareController extends AppController
{
    /*
    public function beforeRender(Event $event) {
		$session = $this->request->session();
		$count = 0;
		foreach ($session->read('login.modulos') as $modulo) {
			if ($modulo->chave == 'homecare') {
				$count = 1;
				break;
			} 
		}
		if ($count == 0) {
			return $this->redirect($this->referer());	
		}
    }
    */
    public function index() {
        
    }

    public function gpad() {
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $pacientes = $this->query("SELECT o.*, GROUP_CONCAT(p.gruporisco) AS gruporisco2
        FROM `pacientes_homecare` o                   
          LEFT JOIN `pacientes_homecare` b     
              ON o.carteiracpf = b.carteiracpf AND o.datacadastro < b.datacadastro
          LEFT JOIN `pacientehomecare_gruporisco` p ON (p.pacientes_homecareid = o.pacientes_homecareid)
        WHERE b.datacadastro is NULL
        GROUP BY o.pacientes_homecareid");
        if ($this->request->is('post')) {
            //salvar os dados
            $data = $this->request->getData();
            $tabelahomecare = TableRegistry::get('Pacientes_homecare');
            $gruporiscoTable = TableRegistry::get('Pacientehomecare_gruporisco');
            $homecare = $tabelahomecare->newEntity();
            $homecare->tipo = $data['tipo'];
            $homecare->carteiracpf = $data['carteiracpf'];
            $homecare->tipoprograma = $data['tipoprograma'];
            $homecare->observacao = $data['observacao'];
            $homecare->usuariocadastro = $usuario->idusuario;
            $homecare->usuariocadastronome = $usuario->nome;
            $homecare->codigoteste = $data['codigoteste'];
            $homecare->data_ultimotratamento = $data['data_ultimotratamento'];
            $homecare->ultimotratamento = $data['ultimotratamento'];
            $homecare->testecolhido = (array_key_exists('testecolhido',$data)) ? 1 : 0;
            $homecare->alta = (array_key_exists('alta',$data)) ? 1 : 0;
            $homecare->obito = (array_key_exists('obito',$data)) ? 1 : 0;
            $homecare->ventilacao = (array_key_exists('ventilacao',$data)) ? 1 : 0;
            $homecare = $tabelahomecare->save($homecare);
            if (!$homecare) {
                $this->Flash->error("Não foi possível salvar o Paciente");
            } else {
                foreach ($data['gruporisco'] as $gruporisco) {
                    $pacientegruporisco = $gruporiscoTable->newEntity();
                    $pacientegruporisco->gruporisco = $gruporisco;
                    $pacientegruporisco->pacientes_homecareid = $homecare->pacientes_homecareid;
                    $gruporiscoTable->save($pacientegruporisco);
                }
                $this->Flash->success("Paciente Cadastrado com Sucesso!");
            }
            return $this->redirect(['action'=>'gpad']);
        }
        $this->set(compact([
            'pacientes'
            ,'empresa'
            ,'perfil'
        ]));
    }

    public function modalpacientehomecare($id) {
        $entradacpf = $this->get('pacientes_homecare','pacientes_homecareid',$id);
        $carteiracpf = $this->get('pacientes_homecare','pacientes_homecareid',$id)->carteiracpf;
        $resumo = $this->getAllTableWhere('pacientes_homecare',['carteiracpf'=>$entradacpf->carteiracpf],[])->all();
        $this->set(compact([
            'resumo'
            ,'carteiracpf'
        ]));
    }

    public function kanbangpad($carteirinha = null) {
        $empresa = $this->sessionread('login.empresa');
        $perfil = $this->sessionread('login.perfil')->perfil;
        $suspeitos = [];
        $confirmados = [];
        $descartados = [];
        $altas = [];
        $obitos = [];
        if ($carteirinha != null) {
            $carteirinhaquery = "LIKE '%".$carteirinha."%'";
        } else {
            $carteirinhaquery = "LIKE '%'";
        }
        $pacientes_homecare = $this->query("SELECT o.*, b2.datamin, GROUP_CONCAT(p.gruporisco) AS gruporisco2, tempoalta.entrada, tempoalta.saida
        FROM `pacientes_homecare` o
          LEFT JOIN `pacientes_homecare` b
              ON o.carteiracpf = b.carteiracpf AND o.datacadastro < b.datacadastro
          LEFT JOIN (SELECT pacientes_homecareid, MIN(datacadastro) AS datamin FROM pacientes_homecare GROUP BY carteiracpf) b2
              ON (b2.pacientes_homecareid = o.pacientes_homecareid)
          LEFT JOIN pacientehomecare_gruporisco p ON (p.pacientes_homecareid = o.pacientes_homecareid)
          INNER JOIN (SELECT MIN(datacadastro) AS entrada, MAX(datacadastro) AS saida, carteiracpf
                      FROM pacientes_homecare GROUP BY 3) AS tempoalta ON (tempoalta.carteiracpf = o.carteiracpf)
        WHERE b.datacadastro is NULL AND o.carteiracpf $carteirinhaquery
        GROUP BY o.pacientes_homecareid");
        $utisusp = 0;
        $uticonf = 0;
        $utidesc = 0;
        $ventsusp = 0;
        $ventconf = 0;
        $ventdesc = 0;
        $testadosusp = 0;
        $testadoconf = 0;
        $testadodesc = 0;
        foreach ($pacientes_homecare as $item) {
            if ($item->obito == 1) {
                array_push($obitos,$item);
            } else if ($item->alta == 1) {
               array_push($altas,$item);
            } else {
                if ($item->tipo == 'Diag. Suspeito') {
                    $utisusp += ($item->local == 'UTI') ? 1 : 0;
                    $ventsusp += $item->ventilacao;
                    $testadosusp += $item->testecolhido;
                    array_push($suspeitos,$item);
                }
                if ($item->tipo == 'Diag. Confirmado') {
                    $uticonf += ($item->local == 'UTI') ? 1 : 0;
                    $ventconf += $item->ventilacao;
                    $testadoconf += $item->testecolhido;
                    array_push($confirmados,$item);
                }
                if ($item->tipo == 'Descartado') {
                    $utidesc += ($item->local == 'UTI') ? 1 : 0;
                    $ventdesc += $item->ventilacao;
                    $testadodesc += $item->testecolhido;
                    array_push($descartados,$item);
                }
            }
        }
        $this->set(compact([
            'pacientes'
            ,'empresa'
            ,'suspeitos'
            ,'confirmados'
            ,'descartados'
            ,'altas'
            ,'obitos'
            ,'perfil'
            ,'utisusp'
            ,'uticonf'
            ,'utidesc'
            ,'ventsusp'
            ,'ventconf'
            ,'ventdesc'
            ,'testadosusp'
            ,'testadoconf'
            ,'testadodesc'
            ,'carteirinha'
        ]));
    }

    public function alterarkanban($obs, $tipo, $id) {
        $usuario = $this->sessionread('login.usuario');
        $tabelahomecare = TableRegistry::get('Pacientes_homecare');
        if ($tipo == 'Alta') {
            $paciente_homecare = $tabelahomecare->newEntity();
            $pacientehomecare_anterior = $this->get("Pacientes_homecare",'pacientes_homecareid',$id);
            $paciente_homecare->observacao = $obs;
            $paciente_homecare->tipo = $pacientehomecare_anterior->tipo;
            $paciente_homecare->coduninmed = $pacientehomecare_anterior->coduninmed;
            $paciente_homecare->carteiracpf = $pacientehomecare_anterior->carteiracpf;
            $paciente_homecare->data_nascimento = $pacientehomecare_anterior->data_nascimento;
            $paciente_homecare->sexo = $pacientehomecare_anterior->sexo;
            $paciente_homecare->tipoprograma = $pacientehomecare_anterior->tipoprograma;
            $paciente_homecare->gruporisco = $pacientehomecare_anterior->gruporisco;
            $paciente_homecare->alta = 1;
            $paciente_homecare->usuariocadastronome = $usuario->nome;
            $paciente_homecare->usuariocadastro = $usuario->idusuario;
            $paciente_homecare->obito = 0;
            $paciente_homecare->ventilacao = $pacientehomecare_anterior->ventilacao;
            $paciente_homecare->testecolhido = $pacientehomecare_anterior->testecolhido;
        } else if ($tipo == 'Obito') {
            $paciente_homecare = $tabelahomecare->newEntity();
            $pacientehomecare_anterior = $this->get("Pacientes_homecare",'pacientes_homecareid',$id);
            $paciente_homecare->observacao = $obs;
            $paciente_homecare->tipo = $pacientehomecare_anterior->tipo;
            $paciente_homecare->coduninmed = $pacientehomecare_anterior->coduninmed;
            $paciente_homecare->carteiracpf = $pacientehomecare_anterior->carteiracpf;
            $paciente_homecare->data_nascimento = $pacientehomecare_anterior->data_nascimento;
            $paciente_homecare->tipoprograma = $pacientehomecare_anterior->tipoprograma;
            $paciente_homecare->sexo = $pacientehomecare_anterior->sexo;
            $paciente_homecare->gruporisco = $pacientehomecare_anterior->gruporisco;
            $paciente_homecare->alta = $pacientehomecare_anterior->alta;
            $paciente_homecare->ventilacao = $pacientehomecare_anterior->ventilacao;
            $paciente_homecare->usuariocadastronome = $usuario->nome;
            $paciente_homecare->usuariocadastro = $usuario->idusuario;
            $paciente_homecare->testecolhido = $pacientehomecare_anterior->testecolhido;
            $paciente_homecare->obito = 1;
        } else {
            $paciente_homecare = $tabelahomecare->newEntity();
            $pacientehomecare_anterior = $this->get("Pacientes_homecare",'pacientes_homecareid',$id);
            $paciente_homecare->observacao = $obs;
            $paciente_homecare->tipo = $tipo;
            $paciente_homecare->coduninmed = $pacientehomecare_anterior->coduninmed;
            $paciente_homecare->carteiracpf = $pacientehomecare_anterior->carteiracpf;
            $paciente_homecare->data_nascimento = $pacientehomecare_anterior->data_nascimento;
            $paciente_homecare->tipoprograma = $pacientehomecare_anterior->tipoprograma;
            $paciente_homecare->sexo = $pacientehomecare_anterior->sexo;
            $paciente_homecare->gruporisco = $pacientehomecare_anterior->gruporisco;
            $paciente_homecare->usuariocadastronome = $usuario->nome;
            $paciente_homecare->alta = 0;
            $paciente_homecare->obito = 0;
            $paciente_homecare->usuariocadastro = $usuario->idusuario;
            $paciente_homecare->ventilacao = $pacientehomecare_anterior->ventilacao;
            $paciente_homecare->testecolhido = $pacientehomecare_anterior->testecolhido;
        }
        if (!$tabelahomecare->save($paciente_homecare) ) {
            $this->response->body("Por favor, tente novamente.");
            return $this->response;
            exit();
        } else {
            $this->response->body("ok");
            return $this->response;
            exit();
        }
    }

    public function cadastromodal($id) {
        $empresa = $this->sessionread('login.empresa');
        $usuario = $this->sessionread('login.usuario');
        $paciente = $this->get("Pacientes_homecare",'pacientes_homecareid',$id);    
        $gruposderisco = $this->getAllTableWhere("Pacientehomecare_gruporisco",["pacientes_homecareid"=>$id],[]); 
        $gruposrisco = [];
        $date = '';
        if (null !== $paciente->data_ultimotratamento) {
            $date = (get_object_vars($paciente->data_ultimotratamento)['date']);
            $date = explode(" ", $date);
            $date = $date[0];
        }
        if($paciente->gruporisco != null) {
            array_push($gruposrisco,$paciente->gruporisco);
        } else {
            foreach ($gruposderisco as $gruporisco) {
                array_push($gruposrisco, $gruporisco->gruporisco);
            }   
        }
        $estado = $empresa->estado;
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $tabelahomecare = TableRegistry::get('pacientes_homecare');
            $gruporiscoTable = TableRegistry::get('Pacientehomecare_gruporisco');
            $paciente_homecare = $tabelahomecare->newEntity();
            $paciente_homecare->tipo = $data['tipo'];
            $paciente_homecare->carteiracpf = $data['carteiracpf'];
            $paciente_homecare->tipoprograma = $data['tipoprograma'];
            $paciente_homecare->observacao = $data['observacao'];
            $paciente_homecare->codigoteste = $data['codigoteste'];
            $paciente_homecare->data_ultimotratamento = $data['data_ultimotratamento'];
            $paciente_homecare->ultimotratamento = $data['ultimotratamento'];
            $paciente_homecare->datacadastro = Date('Y-m-d H:i:s');
            $paciente_homecare->testecolhido = (array_key_exists('testecolhido',$data)) ? 1 : 0;
            $paciente_homecare->alta = (array_key_exists('alta',$data)) ? 1 : 0;
            $paciente_homecare->obito = (array_key_exists('obito',$data)) ? 1 : 0;
            $paciente_homecare->ventilacao = (array_key_exists('ventilacao',$data)) ? 1 : 0;
            $paciente_homecare->usuariocadastro = $usuario->idusuario;
            $paciente_homecare->usuariocadastronome = $usuario->nome;
            if (!$tabelahomecare->save($paciente_homecare)) {
                $this->Flash->error("Não foi possível salvar o Paciente");
            } else {
                $grupos = $this->getAllTableWhere('Pacientehomecare_gruporisco',['pacientes_homecareid'=>$id],[]);
                foreach ($grupos as $grupo) {
                    $gruporiscoTable->delete($grupo);
                }
                if (array_key_exists('gruporisco',$data)) {
                    foreach ($data['gruporisco'] as $gruporisco) {
                        $pacientegruporisco = $gruporiscoTable->newEntity();
                        $pacientegruporisco->gruporisco = $gruporisco;
                        $pacientegruporisco->pacientes_homecareid = $paciente_homecare->pacientes_homecareid;
                        $gruporiscoTable->save($pacientegruporisco);
                    }
                    $this->Flash->success("Paciente Cadastrado com Sucesso!");
                }
            }
            return $this->redirect(['action'=>'gpad']);
        }
        $this->set(compact([
            'paciente'
            ,'hospitais'
            ,'gruposrisco'
            ,'date'
            ,'empresa'
        ]));
    }
}