<?php
namespace App\Controller\Adm;

use App\Controller\AppController;

/**
 * Modulousuario Controller
 *
 * @property \App\Model\Table\ModulousuarioTable $Modulousuario
 *
 * @method \App\Model\Entity\Modulousuario[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ModulousuarioController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $modulousuario = $this->paginate($this->Modulousuario);

        $this->set(compact('modulousuario'));
    }

    /**
     * View method
     *
     * @param string|null $id Modulousuario id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $modulousuario = $this->Modulousuario->get($id, [
            'contain' => []
        ]);

        $this->set('modulousuario', $modulousuario);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null)
    {
		if($id == null){
			echo "selecione um usuário";exit();
		}
		$usuario = $this->get('usuario','usuarioid',$id);
		$pessoa = $this->get('pessoa','pessoaid',$usuario->pessoaid);
		
        $modulousuario = $this->Modulousuario->newEntity();
        if ($this->request->is('post')) {
            $modulousuario = $this->Modulousuario->patchEntity($modulousuario, $this->request->getData());
			$modulousuario->pessoaidcadastro = $this->pessoaid();
			$modulousuario->empresaid = $this->empresaid();
			$modulousuario->ativo = 1;
            if ($this->Modulousuario->save($modulousuario)) {
                $this->Flash->success(__('Módulo foi salvo com sucesso.'));
                return $this->redirect($this->referer());
            }
            $this->Flash->error(__('modulousuario não pode ser salvo. Favor, tentar novamente.'));
        }
		$modulos = $this->getAllTableWhere('modulo',[],['ordem'=>'asc']);
		
		$this->set([
			'modulos'=>$modulos
			,'usuario'=>$usuario
			,'pessoa'=>$pessoa
		]);
        $this->set(compact('modulousuario'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Modulousuario id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $modulousuario = $this->Modulousuario->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $modulousuario = $this->Modulousuario->patchEntity($modulousuario, $this->request->getData());
            if ($this->Modulousuario->save($modulousuario)) {
                $this->Flash->success(__('The modulousuario has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The modulousuario could not be saved. Please, try again.'));
        }
        $this->set(compact('modulousuario'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Modulousuario id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $modulousuario = $this->Modulousuario->get($id);
        if ($this->Modulousuario->delete($modulousuario)) {
            $this->Flash->success(__('Módulo foi removido.'));
        } else {
            $this->Flash->error(__('The modulousuario could not be deleted. Please, try again.'));
        }

        return $this->redirect($this->referer());
    }
}
