<?php
namespace App\Controller\Adm;

use App\Controller\AppController;

/**
 * Notificacao Controller
 *
 * @property \App\Model\Table\NotificacaoTable $Notificacao
 *
 * @method \App\Model\Entity\Notificacao[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class NotificacaoController extends AppController
{

    public function visto(){
			$pessoaid = $this->pessoaid();
			
			$this->update('notificacao',[
				'visto'=>1
				,'data_visto'=>date('Y-m-d H:i:s')
			],[
				'pessoaiddestino'=>$pessoaid
				,'data_lembrete <='=>date('Y-m-d')
			]);
			exit();
	}
	
    public function index()
    {
        $notificacao = $this->paginate($this->Notificacao
			->find('all')
			->where(['pessoaiddestino'=>$this->pessoaid()])
			->order(['data_criacao'=>'desc'])
		);

        $this->set(compact('notificacao'));
    }

    /**
     * View method
     *
     * @param string|null $id Notificacao id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $notificacao = $this->Notificacao->get($id, [
            'contain' => []
        ]);

        $this->set('notificacao', $notificacao);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $notificacao = $this->Notificacao->newEntity();
        if ($this->request->is('post')) {
            $notificacao = $this->Notificacao->patchEntity($notificacao, $this->request->getData());
            if ($this->Notificacao->save($notificacao)) {
                $this->Flash->success(__('The notificacao has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The notificacao could not be saved. Please, try again.'));
        }
        $this->set(compact('notificacao'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Notificacao id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $notificacao = $this->Notificacao->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $notificacao = $this->Notificacao->patchEntity($notificacao, $this->request->getData());
            if ($this->Notificacao->save($notificacao)) {
                $this->Flash->success(__('The notificacao has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The notificacao could not be saved. Please, try again.'));
        }
        $this->set(compact('notificacao'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Notificacao id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $notificacao = $this->Notificacao->get($id);
        if ($this->Notificacao->delete($notificacao)) {
            $this->Flash->success(__('The notificacao has been deleted.'));
        } else {
            $this->Flash->error(__('The notificacao could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
