<?php
namespace App\Controller\Adm;

use App\Controller\AppController;

/**
 * Perfilusuario Controller
 *
 * @property \App\Model\Table\PerfilusuarioTable $Perfilusuario
 *
 * @method \App\Model\Entity\Perfilusuario[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class PerfilusuarioController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $perfilusuario = $this->paginate($this->Perfilusuario);

        $this->set(compact('perfilusuario'));
    }

    /**
     * View method
     *
     * @param string|null $id Perfilusuario id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $perfilusuario = $this->Perfilusuario->get($id, [
            'contain' => []
        ]);

        $this->set('perfilusuario', $perfilusuario);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null)
    {
		if($id == null){
			echo "selecione um usuário";exit();
		}
		$usuario = $this->get('usuario','usuarioid',$id);
		$pessoa = $this->get('pessoa','pessoaid',$usuario->pessoaid);
		
        $perfilusuario = $this->Perfilusuario->newEntity();
        if ($this->request->is('post')) {
            $perfilusuario = $this->Perfilusuario->patchEntity($perfilusuario, $this->request->getData());
			$perfilusuario->pessoaidcadastro = $this->pessoaid();
			$perfilusuario->empresaid = $this->empresaid();
            $perfilusuario->ativo = 1;
            if ($this->Perfilusuario->save($perfilusuario)) {
                $this->Flash->success(__('Perfil foi salvo com sucesso.'));
				
				//perfil vendedor , insere na tabela vendedor
				$vendedor = $this->get('vendedor','pessoaid',$pessoa->pessoaid);
				if($vendedor == null && $perfilusuario->perfilid == 5){
					$this->insert('vendedor',[
						'pessoaid'=>$pessoa->pessoaid
						,'pessoaidcadastro'=>$this->pessoaid()
						,'empresaid'=>$usuario->empresaid
					]);
				}
                return $this->redirect($this->referer());
            }
            $this->Flash->error(__('The perfilusuario could not be saved. Please, try again.'));
        }
		$perfis = $this->getAllTableWhere('perfil',[],['ordem'=>'asc']);
		
		$this->set([
			'perfis'  =>$perfis
			,'usuario'=>$usuario
			,'pessoa' =>$pessoa
		]);
        $this->set(compact('perfilusuario'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Perfilusuario id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $perfilusuario = $this->Perfilusuario->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $perfilusuario = $this->Perfilusuario->patchEntity($perfilusuario, $this->request->getData());
            if ($this->Perfilusuario->save($perfilusuario)) {
                $this->Flash->success(__('The perfilusuario has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The perfilusuario could not be saved. Please, try again.'));
        }
        $this->set(compact('perfilusuario'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Perfilusuario id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $perfilusuario = $this->Perfilusuario->get($id);
        if ($this->Perfilusuario->delete($perfilusuario)) {
            $this->Flash->success(__('Perfil foi removido.'));
        } else {
            $this->Flash->error(__('The perfilusuario could not be deleted. Please, try again.'));
        }

        return  $this->redirect($this->referer());
    }
}
