<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;

/**
 * Pessoa Controller
 *
 * @property \App\Model\Table\PessoaTable $Pessoa
 *
 * @method \App\Model\Entity\Pessoa[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class PessoaController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $pessoa = $this->paginate($this->Pessoa);

        $this->set(compact('pessoa'));
    }

    /**
     * View method
     *
     * @param string|null $id Pessoa id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $pessoa = $this->Pessoa->get($id, [
            'contain' => []
        ]);

        $this->set('pessoa', $pessoa);
    }

    public function salvardependentes($jsondependentes, $empresaid){
        $jsondependentes = json_decode($jsondependentes);
        foreach ($jsondependentes as $pessoajson){
            $sql = "select * from pessoa where REPLACE(REPLACE(REPLACE(cpfcnpj, '/', ''), '-', ''), '.', '') = ".str_replace("/","",str_replace("-","",str_replace(".","",$pessoajson->cpfcnpj)))." and empresaid = $empresaid";
            $pessoas = $this->query($sql);
            if (count($pessoas) == 0){
                $pessoasave = $this->Pessoa->newEntity();
                $pessoa = [];
                $pessoa['cpfcnpj'] = str_replace("/","",str_replace("-","",str_replace(".","",$pessoajson->cpfcnpj)));
                $pessoa['empresaid'] = $empresaid;
                $pessoa['nome'] = $pessoajson->nome;
                $pessoa['razaosocial'] = $pessoajson->nome;
                $pessoa['datanascimento'] = $pessoajson->datanascimento;
                $pessoasave = $this->Pessoa->patchEntity($pessoasave, $pessoa);
                if (!$this->Pessoa->save($pessoasave)) {
                    $this->Flash->error("Houve um erro ao salvar a pessoa. Por favor, tente novamente.");
                }
            } else {
                $pessoa = $this->get("Pessoa", 'pessoaid', $pessoas[0]->pessoaid);
                $pessoa->nome = $pessoajson->nome;
                $pessoa->razaosocial = $pessoajson->nome;
                $pessoa->cpfcnpj = $pessoajson->cpfcnpj;
                $pessoa->datanascimento = $pessoajson->datanascimento;
                $pessoasave = $pessoa;
                if (!$this->Pessoa->save($pessoasave)) {
                    $this->Flash->error("Houve um erro ao salvar a pessoa. Por favor, tente novamente.");
                }
            }
            $clienteTable = TableRegistry::get('Cliente');
            if(!count($this->getAllTableWhere('Cliente',['pessoaid'=>$pessoasave->pessoaid, 'empresaid'=>$empresaid],[])->all()) > 0 ) {
                $cliente = $clienteTable->newEntity();
            } else {
                $cliente = $this->get('Cliente', 'clienteid', $this->getAllTableWhere('Cliente',['pessoaid'=>$pessoasave->pessoaid, 'empresaid'=>$empresaid],[])->first()->clienteid);
            }
            $cliente->pessoaid = $pessoasave->pessoaid;
            $cliente->empresaid = $empresaid;
            $cliente->observacao = 'Cadastrado Pelo salvar Dependentes';
            $cliente->pessoaidcadastro = $this->pessoaid();
            if(!$clienteTable->save($cliente)){
                $this->Flash->error('Houve um erro ao cadastrar o cliente! '.$cliente);
            }
        }
    }

    public function getpessoa($id){
        $id = str_replace("/","",str_replace("-","",str_replace(".","",$id)));
        $empresaid = $this->empresaid();
        $sql = "
            SELECT pessoa.* from pessoa
            inner join cliente on ( pessoa.pessoaid = cliente.pessoaid)
            where REPLACE(REPLACE(REPLACE(pessoa.cpfcnpj, '/',''),'-',''),'.','') = '$id'
        ";
        $pessoa = $this->query($sql);
        $this->set([
            'pessoa' => $pessoa,
            '_serialize' => 'pessoa',
        ]);
        $this->RequestHandler->renderAs($this, 'json');
    }

    public function getpessoa2($busca){ 
        $busca = str_replace("/","",str_replace("-","",str_replace(".","",$busca)));
        /*
        $empresaid = $this->empresaid();
        $pessoaTable = TableRegistry::get('Pessoa');
		$query = $pessoaTable->find('all')->innerJoin('cliente','pessoa.pessoaid = cliente.pessoaid')->where(["pessoa.nome like ('%$busca%')"]);
        $pessoa = $this->query($query);
        $this->d($pessoa);
        */
        
        $empresaid = $this->empresaid();
        $sql = "
            (SELECT pessoa.pessoaid, UPPER(pessoa.nome) as nome, pessoa.datanascimento, pessoa.tipopessoa, REPLACE(REPLACE(REPLACE(pessoa.cpfcnpj, '/',''),'-',''),'.','') as cpfcnpj from pessoa
            inner join cliente on ( pessoa.pessoaid = cliente.pessoaid)
            where pessoa.nome like ('%$busca%') or REPLACE(REPLACE(REPLACE(pessoa.cpfcnpj, '/',''),'-',''),'.','') like ('%$busca%')
            group by pessoa.pessoaid) 
            UNION ALL
            (SELECT pessoa.pessoaid, UPPER(pessoa.nome) as nome, pessoa.datanascimento, pessoa.tipopessoa, REPLACE(REPLACE(REPLACE(pessoa.cpfcnpj, '/',''),'-',''),'.','') as cpfcnpj from pessoa
            inner join fornecedor on ( pessoa.pessoaid = fornecedor.pessoaid)
            where pessoa.nome like ('%$busca%') or REPLACE(REPLACE(REPLACE(pessoa.cpfcnpj, '/',''),'-',''),'.','') like ('%$busca%')
            group by pessoa.pessoaid
            )
            LIMIT 20
        ";
        $pessoa = $this->queryPessoa($sql);
        $this->set([
            'pessoa' => $pessoa,
        ]);
    }
    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $pessoa = $this->Pessoa->newEntity();
        if ($this->request->is('post')) {
            $pessoa = $this->Pessoa->patchEntity($pessoa, $this->request->getData());
            if ($this->Pessoa->save($pessoa)) {
                $this->Flash->success(__('The pessoa has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The pessoa could not be saved. Please, try again.'));
        }
        $this->set(compact('pessoa'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Pessoa id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $pessoa = $this->Pessoa->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $pessoa = $this->Pessoa->patchEntity($pessoa, $this->request->getData());
            if ($this->Pessoa->save($pessoa)) {
                $this->Flash->success(__('The pessoa has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The pessoa could not be saved. Please, try again.'));
        }
        $this->set(compact('pessoa'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Pessoa id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $pessoa = $this->Pessoa->get($id);
        if ($this->Pessoa->delete($pessoa)) {
            $this->Flash->success(__('The pessoa has been deleted.'));
        } else {
            $this->Flash->error(__('The pessoa could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
