<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
/**
 * Relatorio Controller
 *
 *
 * @method \App\Model\Entity\Relatorio[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class RelatorioController extends AppController
{
    
    public function beforeRender(Event $event) {
		$session = $this->request->session();
		$count = 0;
		foreach ($session->read('login.modulos') as $modulo) {
			if ($modulo->chave == 'relatorio'){
				$count = 1;
				break;
			} 
		}
		if ($count == 0) {
			return $this->redirect($this->referer());	
		}
    }
    
    public function index() {
		$session = $this->request->session();
        $usuario = $session->read('login.usuario');
        $hospitais = $this->getAllTableWhere('Hospital',[]);
        $relatorio = $this->query(
            "SELECT a.carteiracpf, COALESCE(a.idade,'-') AS idade, COALESCE(a.sexo,'-') AS sexo,
                c.datacadastro AS cadastro, h.nomefantasia AS hospital, a.local, a.ventilacao, a.alta,a.obito,a.usuariocadastronome
             FROM entradapacientes a 
             INNER JOIN (SELECT carteiracpf, MAX(entradapacientesid) AS entradapacientesid FROM entradapacientes GROUP BY carteiracpf) b ON (a.entradapacientesid = b.entradapacientesid)        
             INNER JOIN (SELECT carteiracpf, MIN(datacadastro) AS datacadastro FROM  entradapacientes WHERE tipo = 'Diag. Confirmado' GROUP BY carteiracpf) c ON (c.carteiracpf = a.carteiracpf) 
             INNER JOIN hospital h ON (h.hospitalid = a.hospitalid)
             WHERE tipo = 'Diag. Confirmado'
             ORDER BY c.datacadastro
        ");
        $this->set(compact([
            'relatorio'
            ,'usuario'
            ,'hospitais'
        ]));
    }

    public function relconfirmado() {
        $periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
        
        $session = $this->request->session();
        $usuario = $session->read('login.usuario');
        $hospitais = $this->getAllTableWhere('Hospital',['ativo'=>1]);
        $relatorio = $this->query(
            "SELECT a.carteiracpf, COALESCE(a.idade,'-') AS idade, COALESCE(a.sexo,'-') AS sexo,
                c.datacadastro AS cadastro, h.nomefantasia AS hospital, a.local, a.ventilacao, a.alta,a.obito,a.usuariocadastronome
             FROM entradapacientes a 
             INNER JOIN (SELECT carteiracpf, MAX(entradapacientesid) AS entradapacientesid FROM entradapacientes GROUP BY carteiracpf) b ON (a.entradapacientesid = b.entradapacientesid)        
             INNER JOIN (SELECT carteiracpf, MIN(datacadastro) AS datacadastro FROM  entradapacientes WHERE tipo = 'Diag. Confirmado' GROUP BY carteiracpf) c ON (c.carteiracpf = a.carteiracpf) 
             INNER JOIN hospital h ON (h.hospitalid = a.hospitalid)
             WHERE tipo = 'Diag. Confirmado'
             and cast(c.datacadastro as date) between '$datainicio' and '$datafim'
             ORDER BY c.datacadastro
        ");
        $this->set(compact([
            'relatorio'
            ,'usuario'
            ,'hospitais'
            ,'periodo'
        ]));
    }

        public function relsuspeitos() {
        $periodo    = $_GET['periodo'];
        $datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
        $datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
        
        $session = $this->request->session();
        $usuario = $session->read('login.usuario');
        $hospitais = $this->getAllTableWhere('Hospital',['ativo'=>1]);
        $relatorio = $this->query(
            "SELECT a.carteiracpf, COALESCE(a.idade,'-') AS idade, COALESCE(a.sexo,'-') AS sexo,
                c.datacadastro AS cadastro, h.nomefantasia AS hospital, a.local, a.ventilacao, a.alta,a.obito,a.usuariocadastronome
             FROM entradapacientes a 
             INNER JOIN (SELECT carteiracpf, MAX(entradapacientesid) AS entradapacientesid FROM entradapacientes GROUP BY carteiracpf) b ON (a.entradapacientesid = b.entradapacientesid)        
             INNER JOIN (SELECT carteiracpf, MIN(datacadastro) AS datacadastro FROM  entradapacientes WHERE tipo = 'Diag. Suspeito' GROUP BY carteiracpf) c ON (c.carteiracpf = a.carteiracpf) 
             INNER JOIN hospital h ON (h.hospitalid = a.hospitalid)
             WHERE tipo = 'Diag. Suspeito'
             and cast(c.datacadastro as date) between '$datainicio' and '$datafim'
             ORDER BY c.datacadastro
        ");
        $this->set(compact([
            'relatorio'
            ,'usuario'
            ,'hospitais'
            ,'periodo'
        ]));
    }

    public function rel() {
		$session = $this->request->session();
        $usuario = $session->read('login.usuario');
        $relatorio = $this->query("SELECT TRIM(LEADING '0' FROM medilar.codorigem) AS carteirinha, motivo AS motivo_Medilar, medilar.conduta AS conduta_Medilar, CASE WHEN api.conduta IS NULL THEN 'NÃO' ELSE 'SIM' END AS 'entradaHospital', api.conduta AS conduta_Hospital, api.setor_nome AS HOSPITAL, api.data_atendimento AS data_atend_Hospital, medilar.datahora_atendimento AS data_atend_Medilar 
        FROM atendimento24h medilar 
        LEFT JOIN acompanhamento_hospital api ON (TRIM(LEADING '0' FROM api.benef_carteira) = TRIM(LEADING '0' FROM medilar.codorigem)) ORDER BY 1");
        $this->set(compact([
            'relatorio'
            ,'usuario'
        ]));
    }

    public function reltmpmediopermhosp() {
        $session = $this->request->session();
        $usuario = $session->read('login.usuario');
        $hospitais = $this->getAllTableWhere('Hospital',['ativo'=>1]);
        $relatorio = $this->query(
            "SELECT h.nomefantasia AS hospital, AVG(COALESCE(uti.totalUTI, 0)) AS 'diasuti', AVG(COALESCE(internado.dias, 0)) AS 'diasinternado', SUM(CASE WHEN UPPER(recente.tipo) LIKE '%CONF%' THEN 1 ELSE 0 END) AS 'confirmados',
             SUM(CASE WHEN UPPER(recente.tipo) LIKE '%SUSP%' THEN 1 ELSE 0 END) AS 'suspeitos', SUM(CASE WHEN recente.alta = 1  THEN 1 ELSE 0 END) AS alta,
             SUM(CASE WHEN recente.obito = 1 THEN 1 ELSE 0 END) AS obito, MAX(datas.dataatual) AS ultimaatualizacao FROM

            (SELECT carteiracpf, MIN(datacadastro) AS dataentrada, MAX(datacadastro) AS dataatual FROM entradapacientes GROUP BY carteiracpf) datas
            INNER JOIN (SELECT entradapacientes.* FROM entradapacientes INNER JOIN (SELECT MAX(entradapacientesid) AS entradapacientesid, carteiracpf FROM entradapacientes GROUP BY carteiracpf) a ON entradapacientes.entradapacientesid = a.entradapacientesid) recente ON (recente.carteiracpf = datas.carteiracpf)
            
            LEFT JOIN (SELECT A.carteiracpf, SUM(diff) AS totalUTI 
                FROM ( SELECT b.carteiracpf, b.Origem, b.CadOrigem, b.PROXIMO, b.datacadastro, 
                MAX(b.DIFF) AS diff FROM ( SELECT e.carteiracpf, e.local AS Origem, e.datacadastro AS CadOrigem,
                    e2.local AS PROXIMO, MIN(e2.datacadastro) AS datacadastro, 
                    MIN(DATEDIFF(COALESCE(e2.datacadastro, CURRENT_TIMESTAMP()),e.datacadastro)) AS DIFF 
                    FROM (SELECT carteiracpf, local, datacadastro FROM `entradapacientes` e 
                    WHERE local = 'UTI' AND alta <> 1 AND obito <> 1 GROUP BY 1,2,3) e 
                    LEFT JOIN (SELECT carteiracpf, local, datacadastro FROM entradapacientes 
                    WHERE local <> 'UTI' OR alta = 1 OR obito = 1 GROUP BY 1,2,3) e2 
                    ON (e2.carteiracpf = e.carteiracpf AND e2.datacadastro > e.datacadastro) GROUP BY 1,2,3) b 
                    GROUP BY 1,2,4,5) A
                GROUP BY 1 
            ) uti ON (uti.carteiracpf = recente.carteiracpf)
            
            LEFT JOIN (
                SELECT entrada.carteiracpf, DATEDIFF(COALESCE(saida.datasaidahospital, CURRENT_TIMESTAMP()),entrada.dataentradahospital) AS dias FROM
            (SELECT MIN(datacadastro) AS dataentradahospital, carteiracpf FROM entradapacientes WHERE local = 'UTI' or local = 'Enfermaria' or local = 'UCI' GROUP BY carteiracpf) entrada
            
            LEFT JOIN (SELECT MIN(datacadastro) AS datasaidahospital, carteiracpf FROM entradapacientes WHERE alta = 1 OR obito = 1 GROUP BY carteiracpf) saida ON ( (entrada.carteiracpf = saida.carteiracpf) AND (entrada.dataentradahospital <= saida.datasaidahospital))
            ) internado ON (internado.carteiracpf = recente.carteiracpf)
            
            LEFT JOIN hospital h ON (h.hospitalid = recente.hospitalid)
            GROUP BY h.hospitalid
        ");
        $this->set(compact([
            'relatorio'
            ,'usuario'
            ,'hospitais'
            ,'periodo'
        ]));
    }

    public function reltmpmediopermpac() {
        $session = $this->request->session();
        $usuario = $session->read('login.usuario');
        $hospitais = $this->getAllTableWhere('Hospital',['ativo'=>1]);
        $relatorio = $this->query(
            "SELECT recente.carteiracpf, recente.entradapacientesid AS atendimentoid2, datas.dataentrada, COALESCE(saida.datasaida, '-') AS datasaida, h.nomefantasia AS hospital, COALESCE(uti.totalUTI, 0) AS 'diasuti', COALESCE(internado.dias, 0) AS 'diasinternado',
             CASE WHEN UPPER(recente.tipo) LIKE '%CONF%' THEN 'Sim' ELSE 'Não' END AS 'covid-19', CASE WHEN recente.alta = 1  THEN 'Sim' ELSE 'Não' END AS alta,
             CASE WHEN recente.obito = 1 THEN 'Sim' ELSE 'Não' END AS obito, CASE WHEN recente.ventilacao = 1 THEN 'Sim' ELSE 'Não' END AS ventilacao, datas.dataatual AS ultimaatualizacao 
             FROM
            (SELECT carteiracpf, MIN(datacadastro) AS dataentrada, MAX(datacadastro) AS dataatual FROM entradapacientes GROUP BY carteiracpf) datas
            
            INNER JOIN (SELECT entradapacientes.* FROM entradapacientes INNER JOIN 
                    (SELECT MAX(entradapacientesid) AS entradapacientesid, carteiracpf FROM entradapacientes 
                    GROUP BY carteiracpf) a ON entradapacientes.entradapacientesid = a.entradapacientesid
                ) recente ON (recente.carteiracpf = datas.carteiracpf)
            
            LEFT JOIN (SELECT A.carteiracpf, SUM(diff) AS totalUTI 
                FROM ( SELECT b.carteiracpf, b.Origem, b.CadOrigem, b.PROXIMO, b.datacadastro, 
                MAX(b.DIFF) AS diff FROM ( SELECT e.carteiracpf, e.local AS Origem, e.datacadastro AS CadOrigem,
                    e2.local AS PROXIMO, MIN(e2.datacadastro) AS datacadastro, 
                    MIN(DATEDIFF(COALESCE(e2.datacadastro, CURRENT_TIMESTAMP()),e.datacadastro)) AS DIFF 
                    FROM (SELECT carteiracpf, local, datacadastro FROM `entradapacientes` e 
                    WHERE local = 'UTI' AND alta <> 1 AND obito <> 1 GROUP BY 1,2,3) e 
                    LEFT JOIN (SELECT carteiracpf, local, datacadastro FROM entradapacientes 
                    WHERE local <> 'UTI' OR alta = 1 OR obito = 1 GROUP BY 1,2,3) e2 
                    ON (e2.carteiracpf = e.carteiracpf AND e2.datacadastro > e.datacadastro) GROUP BY 1,2,3) b 
                    GROUP BY 1,2,4,5) A
                GROUP BY 1 
            ) uti ON (uti.carteiracpf = recente.carteiracpf)
            LEFT JOIN ( SELECT MIN(datacadastro) AS datasaida, carteiracpf FROM (SELECT * FROM entradapacientes WHERE alta = 1 or obito = 1) a GROUP BY carteiracpf)
            saida ON (saida.carteiracpf = recente.carteiracpf) 
            LEFT JOIN (
                SELECT entrada.carteiracpf, DATEDIFF(COALESCE(saida.datasaidahospital, CURRENT_TIMESTAMP()),entrada.dataentradahospital) AS dias FROM
            (SELECT MIN(datacadastro) AS dataentradahospital, carteiracpf FROM entradapacientes WHERE local = 'UTI' or local = 'Enfermaria' or local = 'UCI' GROUP BY carteiracpf) entrada
            
            LEFT JOIN (SELECT MIN(datacadastro) AS datasaidahospital, carteiracpf FROM entradapacientes WHERE alta = 1 OR obito = 1 GROUP BY carteiracpf) saida ON ( (entrada.carteiracpf = saida.carteiracpf) AND (entrada.dataentradahospital <= saida.datasaidahospital))
            ) internado ON (internado.carteiracpf = recente.carteiracpf)            
            LEFT JOIN hospital h ON (h.hospitalid = recente.hospitalid)
        ");
        $this->set(compact([
            'relatorio'
            ,'usuario'
            ,'hospitais'
            ,'periodo'
        ]));
    }

    public function reltmpmediopermpacuti() {
        $session = $this->request->session();
        $usuario = $session->read('login.usuario');
        $hospitais = $this->getAllTableWhere('Hospital',['ativo'=>1]);
        $relatorio = $this->query(
            "SELECT h.nomefantasia, p.prontuarioatendimentoid, p.entradapacienteid_gruporisco, p.carteiracpf, e.local, e.datacadastro, e.alta, e.obito, e.dataalta, e.dataobito, p.fimprontuario
            FROM prontuarioatendimento p 
            LEFT JOIN entradapacientes e ON (e.prontuarioatendimentoid = p.prontuarioatendimentoid) 
            LEFT JOIN hospital h ON (h.hospitalid = p.hospitalid) 
            ORDER BY p.prontuarioatendimentoid, e.datacadastro");
        $arrayzao = [];
        $prontuarioatendimentoid = $relatorio[0]->prontuarioatendimentoid;
        $flagUTI = 0;
        $obj = (object) [];
        $array = [];
        $fim = 0;
        foreach ($relatorio as $item) {
            if ($item->prontuarioatendimentoid != $prontuarioatendimentoid) {
                if ($flagUTI == 1) {
                    $obj->data_saida = '-';
                    array_push($array,$obj);
                    $fim = 0;
                    $prontuarioatendimentoid = 0;
                }
                $obj = (object) [];
                $flagUTI = 0;
                $prontuarioatendimentoid = $item->prontuarioatendimentoid;
            }
            if ($item->local == 'UTI') {
                if ($flagUTI == 1 ) {
                    if ($item->alta == 1 || $item->obito == 1) {
                        $obj->data_saida = $item->datacadastro;
                        $flagUTI = 0;
                        $fim = 1;
                    } else {
                        continue;
                    }
                } else {
                    $flagUTI = 1;
                    $obj->prontuario = $item->prontuarioatendimentoid;
                    $obj->entradapacienteid_gruporisco = $item->entradapacienteid_gruporisco;
                    $obj->carteiracpf = $item->carteiracpf;
                    $obj->hospital = $item->nomefantasia;
                    $obj->data_entrada = $item->datacadastro;
                    if ($item->alta == 1 || $item->obito == 1 || $item->fimprontuario == 1) {
                        $fim = 0;
                        $prontuarioatendimentoid = 0;
                        $flagUTI = 0;
                        $flagUTI = 0;
                        continue;
                    }
                }
            } else {
                if ($flagUTI == 1) {
                    $obj->data_saida = $item->datacadastro;
                    $flagUTI = 0;
                    $fim = 1;
                }
            }
            if ($fim == 1) {
                array_push($array,$obj);
                $fim = 0;
                $prontuarioatendimentoid = 0;
            }
        }
        $this->set(compact([
            'relatorio'
            ,'usuario'
            ,'hospitais'
            ,'periodo'
            ,'array'
        ]));
    }
}