<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
/**
 * DashboardCorona Controller
 *
 *
 * @method \App\Model\Entity\DashboardCorona[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TelemedicinaController extends AppController
{
    
    public function beforeRender(Event $event) {
		$session = $this->request->session();
		$count = 0;
		foreach ($session->read('login.modulos') as $modulo) {
			if ($modulo->chave == 'telemedicina'){
				$count = 1;
				break;
			} 
		}
		if ($count == 0) {
			return $this->redirect($this->referer());	
		}
    }
    
    public function modalhistoricopaciente($atendimentoid) {
        $empresa = $this->sessionread('login.empresa');
        $pessoaid = $this->get('Atendimento','atendimentoid', $atendimentoid)->pessoaid;
        $pessoa = $this->get("Pessoa",'pessoaid',$pessoaid);
        $resumo = $this->query(
            "SELECT a.*, p.*, lig.ligacoes AS ligacoes, c.nome AS cidadenome, COALESCE(h.nomefantasia, 'Isolamento') AS nomefantasia, primeiroatendimento.primeiroatendimento AS primeiroatendimento,
              GROUP_CONCAT(s.sintoma) AS sintomas, a.atendimentoid AS atendimentoid2 FROM atendimento a
            INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid)
            INNER JOIN (SELECT COUNT(1) AS ligacoes, pessoaid FROM atendimento GROUP BY pessoaid) lig ON (lig.pessoaid = a.pessoaid)
            INNER JOIN (SELECT MIN(datahora_atendimento) AS primeiroatendimento, pessoaid FROM atendimento GROUP BY pessoaid) primeiroatendimento ON (primeiroatendimento.pessoaid = a.pessoaid)
            LEFT JOIN atendimentosintoma s ON (s.atendimentoid = a.atendimentoid) 
            LEFT JOIN hospital h ON (h.hospitalid = a.hospitalid)
            LEFT JOIN cidade c ON (c.id = p.cidade)
            WHERE a.pessoaid = '$pessoaid'
            GROUP BY a.atendimentoid ORDER BY a.datahora_atendimento DESC
            "
        );
        $this->set(compact([
            'resumo',
            'pessoa'
        ]));
    }

    public function index() {
        $estado = $this->sessionread('login.empresa')->estado;
        $empresa = $this->sessionread('login.empresa');
        $modulos = $this->sessionread('login.modulos');
        $usuario = $this->sessionread('login.usuario');
        $codestado = $this->get('Estado','uf',$estado)->id;
        $cidades = $this->getAllTableWhere('Cidade',['estado'=>$codestado],[]);
        $hospitais = $this->getAllTableWhere('Hospital',['UPPER(uf)'=>mb_strtoupper($estado)],[]);
        $atendimentos = $this->query('SELECT a.*, p.*, lig.ligacoes, primeiroatendimento.primeiroatendimento, CASE WHEN a.motivo = 1 THEN \'COVID-19 (Leve)\' WHEN a.motivo = 0 THEN \'COVID-19 (Não Susp.)\' WHEN a.motivo = 2 THEN \'COVID-19 (Grave)\' END AS motivo2,  GROUP_CONCAT(s.sintoma) AS sintomas, a.atendimentoid AS atendimentoid2 FROM (SELECT a.* FROM atendimento a                  
        LEFT JOIN atendimento b     
            ON a.pessoaid = b.pessoaid AND a.datahora_atendimento < b.datahora_atendimento
        WHERE b.datahora_atendimento is NULL ) a 
        INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
        INNER JOIN (SELECT COUNT(1) AS ligacoes, pessoaid FROM atendimento GROUP BY pessoaid) lig ON (lig.pessoaid = a.pessoaid)
        INNER JOIN (SELECT MIN(datahora_atendimento) AS primeiroatendimento, pessoaid FROM atendimento GROUP BY pessoaid) primeiroatendimento ON (primeiroatendimento.pessoaid = a.pessoaid)
        LEFT JOIN atendimentosintoma s ON (s.atendimentoid = a.atendimentoid) GROUP BY a.atendimentoid ORDER BY a.datahora_atendimento DESC');
        $totalligacoes = count($atendimentos);
        $totalgeralligacoes = count($this->getAllTableWhere('Atendimento',[],[])->all());
        $covidleve = 0;
        $covidgrave = 0;
        $naosuspeito = 0;
        $metastase = 0;
        foreach ($atendimentos as $item) {
            if ($item->motivo == 0) {
                $naosuspeito ++;
            }
            if ($item->motivo == 1) {
                $covidleve ++;
            }
            if ($item->motivo == 2) {
                $covidgrave ++;
            }
            if ($item->metastasepulmonar == 1) {
                $metastase ++;
            }
        }

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $pessoaTable = TableRegistry::get('Pessoa');
            $atendimentosintomaTable = TableRegistry::get('Atendimentosintoma');
            $atendimentoTable = TableRegistry::get('Atendimento');

            //cadastrar pessoa
            if (array_key_exists('pessoaid',$data)) {
                $pessoa = $this->get('Pessoa','pessoaid',$data['pessoaid']);
            } else {
                $pessoa = $this->get('Pessoa','documento',$data['documento']);
                if ($pessoa == null) {
                    $pessoa = $pessoaTable->newEntity();
                }
            }
            $pessoa->telefone = $data['telefone'];
            $pessoa->data_nascimento = $data['data_nascimento'];
            $pessoa->documento = $data['documento'];
            $pessoa->nome = $data['nome'];
            $pessoa->sexo = $data['sexo'];
            $pessoa->cidade = $data['cidade'];
            $pessoa->bairro = $data['bairro'];
            $pessoa->logradouro = $data['logradouro'];
            $pessoa->telefone = $data['telefone'];
            $pessoa = $pessoaTable->save($pessoa);
            if (!$pessoa) {
                $this->Flash->error('Não foi Possível Cadastrar a Pessoa. Por favor, tente novamente.');
                return $this->redirect(['action'=>'index']);
            }

            //cadastra atendimento
            $atendimento = $atendimentoTable->newEntity();
            $atendimento->observacao = $data['observacao'];
            $atendimento->wpp = (array_key_exists('wpp',$data)) ? 1 : 0;
            $atendimento->fimsintoma = (array_key_exists('fimsintoma',$data)) ? 1 : 0;
            $atendimento->metastasepulmonar = (array_key_exists('metastasepulmonar',$data)) ? 1 : 0;
            $atendimento->alta = (array_key_exists('alta',$data)) ? 1 : 0;
            $atendimento->obito = (array_key_exists('obito',$data)) ? 1 : 0;
            if (array_key_exists('testecolhido',$data)) {
                $atendimento->testecolhido = (array_key_exists('testecolhido',$data)) ? 1 : 0;
                $atendimento->covidpositivo = (array_key_exists('covidpositivo',$data)) ? 1 : 0;
                $atendimento->codigoteste = $data['codigoteste'];
                $atendimento->datateste = $data['datateste'];
            }
            $atendimento->origemligacao = $data['origem'];
            $atendimento->tratamento = $data['tratamento'];
            $atendimento->datatratamento = $data['datatratamento'];
            $atendimento->dataprimeirosintoma = $data['dataprimeirosintoma'];
            if (array_key_exists('datahora_atendimento',$data)) {
                $atendimento->dataatendimento = $data['datahora_atendimento'];
            }
            $atendimento->tumorprimario = $data['tumorprimario'];
            if (array_key_exists('sintoma',$data)) {
                if (in_array('Falta de Ar',$data['sintoma'])) {
                    $atendimento->motivo = 2;
                } else {
                    $atendimento->motivo = 1;
                }
            } else {
                $atendimento->motivo = 0;
            }
            $atendimento->direcionamento = $data['direcionamento'];
            $atendimento->hospitalid = $data['hospitalid'];
            $atendimento->hospitalnome = ($this->get('Hospital','hospitalid',$data['hospitalid'])) ? $this->get('Hospital','hospitalid',$data['hospitalid'])->nomefantasia : '';
            $atendimento->pessoaid = $pessoa->pessoaid;
            $atendimento->usuariocadastro = $usuario->idusuario;
            $atendimento->usuariocadastronome = $usuario->nome;
            $atendimento = $atendimentoTable->save($atendimento);
            if (!$atendimento) {
                $this->Flash->error('Não foi Possível Cadastrar o Atendimento. Por favor, tente novamente.');
                return $this->redirect(['action'=>'index']);
            }
            //cadastra sintomas
            if (array_key_exists('sintoma',$data)){
                foreach ($data['sintoma'] as $sintoma) {
                    $atendimentosintoma = $atendimentosintomaTable->newEntity();
                    $atendimentosintoma->sintoma = $sintoma;
                    $atendimentosintoma->atendimentoid = $atendimento->atendimentoid;
                    if(!$atendimentosintomaTable->save($atendimentosintoma)){
                        $this->Flash->error('Não foi Possível Cadastrar os Sintomas. Por favor, tente novamente.');
                        return $this->redirect(['action'=>'index']);
                    }
                }
            }
            $this->Flash->success("Atendimento Cadastrado com Sucesso!");
            return $this->redirect(['action'=>'index']);
        }
        $customlabel1 = "Tumor Primário";
        $hospitais = $this->getAllTableWhere('Hospital',["UPPER(nomefantasia) LIKE '%HOSPITAL%' OR nomefantasia = 'UPA'", "uf"=>$estado],[]); 
        $this->set(compact(
            [
                'cidades'
                ,'hospitais'
                ,'atendimentos'
                ,'totalligacoes'
                ,'covidleve'
                ,'covidgrave'
                ,'naosuspeito'
                ,'hospitais'
                ,'customlabel1'
                ,'usuario'
                ,'totalgeralligacoes'
                ,'metastase'
            ]
        ));
    }

    public function kanbanatendimento() {
        $atendimentos = $this->query('SELECT a.*, p.*, CASE WHEN a.motivo = 1 THEN \'COVID-19 (Leve)\' WHEN a.motivo = 0 THEN \'COVID-19 (Não Susp.)\' WHEN a.motivo = 2 THEN \'COVID-19 (Grave)\' END AS motivo2,
          GROUP_CONCAT(s.sintoma) AS sintomas, a.atendimentoid AS atendimentoid2, primeiroatendimento.primeiroatendimento
          FROM (SELECT a.* FROM atendimento a                  
        LEFT JOIN atendimento b     
            ON a.pessoaid = b.pessoaid AND a.datahora_atendimento < b.datahora_atendimento
      WHERE b.datahora_atendimento is NULL ) a 
      INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
      LEFT JOIN (SELECT MIN(datahora_atendimento) AS primeiroatendimento, documento FROM atendimento INNER JOIN pessoa ON (pessoa.pessoaid = atendimento.atendimentoid) GROUP BY documento) primeiroatendimento ON (primeiroatendimento.documento = p.documento)
      LEFT JOIN atendimentosintoma s ON (s.atendimentoid = a.atendimentoid) 
      GROUP BY a.atendimentoid');
        $hoje = new \DateTime(Date('Y-m-d'));
        $array48h = [];
        $array24h = [];
        $finalizados = [];
        $obitos = [];

        foreach ($atendimentos as $atendimento) {
            $horaatendimento = new \DateTime(Date('Y-m-d', strtotime($atendimento->datahora_atendimento)));
            $dias = $hoje->diff($horaatendimento)->days;
            if ($atendimento->obito == 1) {
                array_push($obitos,$atendimento);
            } else if ($atendimento->fimsintoma) {
                array_push($finalizados,$atendimento);
            } else if ($dias >= 2) {
                array_push($array48h, $atendimento);
            } else if ($dias >= 0) {
                array_push($array24h, $atendimento);
            } 
        }
        
        $this->set(compact([
            'atendimentos'
            ,'array48h'
            ,'array24h'
            ,'finalizados'
            ,'obitos'
        ]));
    }

    public function modalcard24h($tipo) {
        $empresa = $this->sessionread('login.empresa');
        $dataAtual = Date('Y-m-d');
        $mesAtual = Date('m');
        $anoAtual = Date('Y');
        $header = "Resumo das Informações";
        switch ($tipo){
            case 'hoje':
                $resumo = $this->query(
                    "SELECT a.datahora_atendimento, CASE WHEN motivo = 0 THEN 'Não Suspeito' WHEN motivo = 1 THEN 'Suspeito Leve' WHEN motivo = 2 THEN 'Suspeito Grave' END AS motivo, primeiroatendimento.datahora_atendimento AS datahora_atendimento2, DATEDIFF(a.datahora_atendimento, primeiroatendimento.datahora_atendimento) AS diasatendimento,
                    ligacoes.qtd, p.nome, obito, fimsintoma, p.telefone, COALESCE(h.nomefantasia,'Isolamento') AS nomefantasia, a.direcionamento, p.cidade, a.usuariocadastronome, a.metastasepulmonar 
                    FROM atendimento a
                    INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
                    INNER JOIN (SELECT MIN(datahora_atendimento) AS datahora_atendimento, pessoaid FROM atendimento GROUP BY 2) primeiroatendimento ON (primeiroatendimento.pessoaid = p.pessoaid)
                    INNER JOIN (SELECT COUNT(1) AS qtd, pessoaid FROM atendimento GROUP BY pessoaid) ligacoes ON (ligacoes.pessoaid = a.pessoaid)
                    LEFT JOIN hospital h ON (h.hospitalid = a.hospitalid)
                    WHERE DATE_FORMAT(a.`datahora_atendimento`, '%Y-%m-%d') = '$dataAtual'
                    ORDER BY 1 DESC 
                    "
                );
                $header = "Resumo dos Atendimentos Realizados Hoje";
                $title = "Atendimentos do Dia";
                break;
            case 'mes':
                $resumo = $this->query(
                    "SELECT a.datahora_atendimento, CASE WHEN motivo = 0 THEN 'Não Suspeito' WHEN motivo = 1 THEN 'Suspeito Leve' WHEN motivo = 2 THEN 'Suspeito Grave' END AS motivo, primeiroatendimento.datahora_atendimento AS datahora_atendimento2, DATEDIFF(a.datahora_atendimento, primeiroatendimento.datahora_atendimento) AS diasatendimento,
                    ligacoes.qtd, p.nome, obito, fimsintoma, p.telefone, COALESCE(h.nomefantasia,'Isolamento') AS nomefantasia, a.direcionamento, p.cidade, a.usuariocadastronome, a.metastasepulmonar 
                    FROM atendimento a
                    INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
                    INNER JOIN (SELECT MIN(datahora_atendimento) AS datahora_atendimento, pessoaid FROM atendimento GROUP BY 2) primeiroatendimento ON (primeiroatendimento.pessoaid = p.pessoaid)
                    INNER JOIN (SELECT COUNT(1) AS qtd, pessoaid FROM atendimento GROUP BY pessoaid) ligacoes ON (ligacoes.pessoaid = a.pessoaid)
                    LEFT JOIN hospital h ON (h.hospitalid = a.hospitalid)
                    WHERE DATE_FORMAT(a.`datahora_atendimento`, '%Y-%m') = '$anoAtual-$mesAtual'
                    ORDER BY 1 DESC
                    "
                );
                $header = "Resumo dos Atendimentos do Mês";
                $title = "Atendimentos do Mês";
                break;
            case 'total':
                $resumo = $this->query(
                    "SELECT a.datahora_atendimento, CASE WHEN motivo = 0 THEN 'Não Suspeito' WHEN motivo = 1 THEN 'Suspeito Leve' WHEN motivo = 2 THEN 'Suspeito Grave' END AS motivo, primeiroatendimento.datahora_atendimento AS datahora_atendimento2, DATEDIFF(a.datahora_atendimento, primeiroatendimento.datahora_atendimento) AS diasatendimento,
                    ligacoes.qtd, p.nome, obito, fimsintoma, p.telefone, COALESCE(h.nomefantasia,'Isolamento') AS nomefantasia, a.direcionamento, p.cidade, a.usuariocadastronome, a.metastasepulmonar 
                    FROM atendimento a
                    INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
                    INNER JOIN (SELECT MIN(datahora_atendimento) AS datahora_atendimento, pessoaid FROM atendimento GROUP BY 2) primeiroatendimento ON (primeiroatendimento.pessoaid = p.pessoaid)
                    INNER JOIN (SELECT COUNT(1) AS qtd, pessoaid FROM atendimento GROUP BY pessoaid) ligacoes ON (ligacoes.pessoaid = a.pessoaid)
                    LEFT JOIN hospital h ON (h.hospitalid = a.hospitalid)
                    ORDER BY 1 DESC
                    "
                );
                $header = "Todos os Atendimentos";
                $title = "Todos os Atendimentos";
                break;
            case 'grave':
                $resumo = $this->query(
                    "SELECT a.datahora_atendimento, CASE WHEN motivo = 0 THEN 'Não Suspeito' WHEN motivo = 1 THEN 'Suspeito Leve' WHEN motivo = 2 THEN 'Suspeito Grave' END AS motivo, primeiroatendimento.datahora_atendimento AS datahora_atendimento2, DATEDIFF(a.datahora_atendimento, primeiroatendimento.datahora_atendimento) AS diasatendimento,
                    ligacoes.qtd, p.nome, obito, fimsintoma, p.telefone, COALESCE(h.nomefantasia,'Isolamento') AS nomefantasia, a.direcionamento, p.cidade, a.usuariocadastronome, a.metastasepulmonar 
                    FROM atendimento a
                    INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
                    INNER JOIN (SELECT MIN(datahora_atendimento) AS datahora_atendimento, pessoaid FROM atendimento GROUP BY 2) primeiroatendimento ON (primeiroatendimento.pessoaid = p.pessoaid)
                    INNER JOIN (SELECT COUNT(1) AS qtd, pessoaid FROM atendimento GROUP BY pessoaid) ligacoes ON (ligacoes.pessoaid = a.pessoaid)
                    LEFT JOIN hospital h ON (h.hospitalid = a.hospitalid)
                    WHERE motivo = 2
                    ORDER BY 1 DESC
                    "
                );
                $header = "Atendimentos COVID-19 Classificados como Grave";
                $title = "Atendimentos COVID-19 Classificados como Grave";
                break;
        }
        $this->set(compact([
            'resumo',
            'tipo',
            'header',
            'title'
        ]));
    }

    public function edicaoatendimento() {
        $usuario = $this->sessionread('login.usuario');
        if ($usuario->idperfil == 6) {
            $atendimentos = $this->query('SELECT a.*, p.*, CASE WHEN a.motivo = 1 THEN \'COVID-19 (Leve)\' WHEN a.motivo = 0 THEN \'COVID-19 (Não Susp.)\' WHEN a.motivo = 2 THEN \'COVID-19 (Grave)\' END AS motivo2,  GROUP_CONCAT(s.sintoma) AS sintomas, a.atendimentoid AS atendimentoid2, a.datahora_atendimento AS datahora 
                                            FROM atendimento a 
                                            INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
                                            LEFT JOIN atendimentosintoma s ON (s.atendimentoid = a.atendimentoid) 
                                            GROUP BY a.atendimentoid ORDER BY a.datahora_atendimento DESC');
        } else {
            $atendimentos = $this->query('SELECT a.*, p.*, CASE WHEN a.motivo = 1 THEN \'COVID-19 (Leve)\' WHEN a.motivo = 0 THEN \'COVID-19 (Não Susp.)\' WHEN a.motivo = 2 THEN \'COVID-19 (Grave)\' END AS motivo2,  GROUP_CONCAT(s.sintoma) AS sintomas, a.atendimentoid AS atendimentoid2, a.datahora_atendimento AS datahora 
                                            FROM atendimento a 
                                            INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
                                            LEFT JOIN atendimentosintoma s ON (s.atendimentoid = a.atendimentoid) 
                                            WHERE a.usuariocadastro = '.$usuario->idusuario.' GROUP BY a.atendimentoid ORDER BY a.datahora_atendimento DESC');
        }
        $this->set(compact([
            'atendimentos',
            'usuario'
        ]));
    }

    public function modaledicao($atendimentoid) {
        $usuario = $this->sessionread('login.usuario');
        $atendimento = $this->get('Atendimento','atendimentoid',$atendimentoid);
        if ($usuario->idperfil != 6) {
            if ($atendimento->usuariocadastro != $usuario->idusuario) {
                $this->Flash->error("Atendimento não pertence ao seu usuário.");
                return $this->redirect($this->referer());
            }
        }
        $estado = $this->sessionread('login.empresa')->estado;
        $empresa = $this->sessionread('login.empresa');
        $modulos = $this->sessionread('login.modulos');
        $usuario = $this->sessionread('login.usuario');
        $codestado = $this->get('Estado','uf',$estado)->id;
        $cidades = $this->getAllTableWhere('Cidade',['estado'=>$codestado],[]);
        $hospitais = $this->getAllTableWhere('Hospital',['UPPER(uf)'=>mb_strtoupper($estado)],[]);
        $cids = $this->getAllTableWhere('Cid10',[],[]);
        $pessoa = $this->get('Pessoa','pessoaid',$atendimento->pessoaid);
        $date = Date('Y-m-d');
        if (null !== $pessoa->data_nascimento) {
            $date = (get_object_vars($pessoa->data_nascimento)['date']);
            $date = explode(" ", $date);
            $date = $date[0];
        }
        $datetratamento = '';
        if (null !== $atendimento->datatratamento) {
            $datetratamento = (get_object_vars($atendimento->datatratamento)['date']);
            $datetratamento = explode(" ", $datetratamento);
            $datetratamento = $datetratamento[0];
        }
        $dateprimeirosintoma = '';
        if (null !== $atendimento->dataprimeirosintoma) {
            $dateprimeirosintoma = (get_object_vars($atendimento->dataprimeirosintoma)['date']);
            $dateprimeirosintoma = explode(" ", $dateprimeirosintoma);
            $dateprimeirosintoma = $dateprimeirosintoma[0];
        }
        $datateste = '';
        if (null !== $atendimento->datateste) {
            $datateste = (get_object_vars($atendimento->datateste)['date']);
            $datateste = explode(" ", $datateste);
            $datateste = $datateste[0];
        }
        $data_horaatendimento = '';
        if (null !== $atendimento->dataatendimento) {
            $data_horaatendimento = (get_object_vars($atendimento->dataatendimento)['date']);
            $data_horaatendimento = explode(" ", $data_horaatendimento);
            $data_horaatendimento = $data_horaatendimento[0];
        }
        $sintomaarray = [];
        $sintomas = $this->getAllTableWhere('Atendimentosintoma',['atendimentoid'=>$atendimentoid],[]);
        foreach ($sintomas as $item) {
            array_push($sintomaarray,$item->sintoma);
        }
        $customlabel1 = 'Tumor Primário';
        $pessoaid = $atendimento->pessoaid;

        if($this->request->is('post')) {
            $data = $this->request->getData();
            $pessoaTable = TableRegistry::get('Pessoa');
            $atendimentosintomaTable = TableRegistry::get('Atendimentosintoma');
            $sintomasatendimento = $this->getAllTableWhere('Atendimentosintoma',['atendimentoid'=>$atendimentoid],[]);
            foreach ($sintomasatendimento as $item) {
                $atendimentosintomaTable->delete($item);
            }
            $atendimentoTable = TableRegistry::get('Atendimento');

            //cadastrar pessoa
            if (array_key_exists('pessoaid',$data)) {
                $pessoa = $this->get('Pessoa','pessoaid',$data['pessoaid']);
            } else {
                $pessoa = $this->get('Pessoa','documento',$data['documento']);
                if ($pessoa == null) {
                    $pessoa = $pessoaTable->newEntity();
                }
            }
            $pessoa->telefone = $data['telefone'];
            $pessoa->data_nascimento = $data['data_nascimento'];
            $pessoa->documento = $data['documento'];
            $pessoa->nome = $data['nome'];
            $pessoa->sexo = $data['sexo'];
            $pessoa->cidade = $data['cidade'];
            $pessoa->bairro = $data['bairro'];
            $pessoa->logradouro = $data['logradouro'];
            $pessoa->telefone = $data['telefone'];
            $pessoa = $pessoaTable->save($pessoa);
            if (!$pessoa) {
                $this->Flash->error('Não foi Possível Cadastrar a Pessoa. Por favor, tente novamente.');
                return $this->redirect(['action'=>'index']);
            }

            //cadastra atendimento
            $atendimento = $this->get('Atendimento','atendimentoid',$atendimentoid);
            $atendimento->observacao = $data['observacao'];
            $atendimento->wpp = (array_key_exists('wpp',$data)) ? 1 : 0;
            $atendimento->fimsintoma = (array_key_exists('fimsintoma',$data)) ? 1 : 0;
            $atendimento->metastasepulmonar = (array_key_exists('metastasepulmonar',$data)) ? 1 : 0;
            $atendimento->alta = (array_key_exists('alta',$data)) ? 1 : 0;
            $atendimento->obito = (array_key_exists('obito',$data)) ? 1 : 0;
            if (array_key_exists('testecolhido',$data)) {
                $atendimento->testecolhido = (array_key_exists('testecolhido',$data)) ? 1 : 0;
                $atendimento->covidpositivo = (array_key_exists('covidpositivo',$data)) ? 1 : 0;
                $atendimento->codigoteste = $data['codigoteste'];
                $atendimento->datateste = $data['datateste'];
            } else {
                $atendimento->testecolhido = 0;
                $atendimento->covidpositivo = 0;
                $atendimento->codigoteste = '';
                $atendimento->datateste = null;
            }
            $atendimento->tratamento = $data['tratamento'];
            $atendimento->datatratamento = $data['datatratamento'];
            $atendimento->origemligacao = $data['origem'];
            $atendimento->dataprimeirosintoma = $data['dataprimeirosintoma'];
            $atendimento->dataatendimento = $data['datahora_atendimento'];
            $atendimento->tumorprimario = $data['tumorprimario'];
            if (array_key_exists('sintoma',$data)) {
                if (in_array('Falta de Ar',$data['sintoma'])) {
                    $atendimento->motivo = 2;
                } else {
                    $atendimento->motivo = 1;
                }
            } else {
                $atendimento->motivo = 0;
            }
            $atendimento->direcionamento = $data['direcionamento'];
            $atendimento->hospitalid = $data['hospitalid'];
            $atendimento->hospitalnome = ($this->get('Hospital','hospitalid',$data['hospitalid'])) ? $this->get('Hospital','hospitalid',$data['hospitalid'])->nomefantasia : '';
            $atendimento->pessoaid = $pessoa->pessoaid;
            $atendimento->usuariocadastro = $usuario->idusuario;
            $atendimento->usuariocadastronome = $usuario->nome;
            $atendimento = $atendimentoTable->save($atendimento);
            if (!$atendimento) {
                $this->Flash->error('Não foi Possível Cadastrar o Atendimento. Por favor, tente novamente.');
                return $this->redirect(['action'=>'index']);
            }
            //cadastra sintomas
            if (array_key_exists('sintoma',$data)){
                foreach ($data['sintoma'] as $sintoma) {
                    $atendimentosintoma = $atendimentosintomaTable->newEntity();
                    $atendimentosintoma->sintoma = $sintoma;
                    $atendimentosintoma->atendimentoid = $atendimento->atendimentoid;
                    if(!$atendimentosintomaTable->save($atendimentosintoma)){
                        $this->Flash->error('Não foi Possível Cadastrar os Sintomas. Por favor, tente novamente.');
                        return $this->redirect(['action'=>'index']);
                    }
                }
            }
            $edicaoTable = TableRegistry::get("log_edicao");
            $log_edicao = $edicaoTable->newEntity();
            $log_edicao->usuarioid = $usuario->idusuario;
            $log_edicao->nome = $usuario->nome;
            $log_edicao->atendimentoid = $atendimentoid;
            $edicaoTable->save($log_edicao);
            $this->Flash->success("Atendimento Cadastrado com Sucesso!");
            return $this->redirect(['action'=>'edicaoatendimento']);
        }
        $this->set(compact(
            [
                'cidades'
                ,'cids'
                ,'hospitais'
                ,'totalligacoes'
                ,'covidleve'
                ,'covidgrave'
                ,'naosuspeito'
                ,'hospitais'
                ,'pessoa'
                ,'sintomaarray'
                ,'atendimento'
                ,'date'
                ,'customlabel1'
                ,'datetratamento'
                ,'dateprimeirosintoma'
                ,'data_horaatendimento'
                ,'datateste'
            ]
            ));
    }

    public function modalkanbanatendimento ($atendimentoid) {
        $estado = $this->sessionread('login.empresa')->estado;
        $empresa = $this->sessionread('login.empresa');
        $modulos = $this->sessionread('login.modulos');
        $usuario = $this->sessionread('login.usuario');
        $codestado = $this->get('Estado','uf',$estado)->id;
        $cidades = $this->getAllTableWhere('Cidade',['estado'=>$codestado],[]);
        $hospitais = $this->getAllTableWhere('Hospital',['UPPER(uf)'=>mb_strtoupper($estado)],[]);
        $cids = $this->getAllTableWhere('Cid10',[],[]);
        $atendimento = $this->get('Atendimento','atendimentoid',$atendimentoid);
        $pessoa = $this->get('Pessoa','pessoaid',$atendimento->pessoaid);
        $date = Date('Y-m-d');
        if (null !== $pessoa->data_nascimento) {
            $date = (get_object_vars($pessoa->data_nascimento)['date']);
            $date = explode(" ", $date);
            $date = $date[0];
        }
        $datetratamento = '';
        if (null !== $atendimento->datatratamento) {
            $datetratamento = (get_object_vars($atendimento->datatratamento)['date']);
            $datetratamento = explode(" ", $datetratamento);
            $datetratamento = $datetratamento[0];
        }
        $dateprimeirosintoma = '';
        if (null !== $atendimento->dataprimeirosintoma) {
            $dateprimeirosintoma = (get_object_vars($atendimento->dataprimeirosintoma)['date']);
            $dateprimeirosintoma = explode(" ", $dateprimeirosintoma);
            $dateprimeirosintoma = $dateprimeirosintoma[0];
        }
        $datateste = '';
        if (null !== $atendimento->datateste) {
            $datateste = (get_object_vars($atendimento->datateste)['date']);
            $datateste = explode(" ", $datateste);
            $datateste = $datateste[0];
        }
        $sintomaarray = [];
        $sintomas = $this->getAllTableWhere('Atendimentosintoma',['atendimentoid'=>$atendimentoid],[]);
        foreach ($sintomas as $item) {
            array_push($sintomaarray,$item->sintoma);
        }
        $customlabel1 = 'Tumor Primário';
        $pessoaid = $atendimento->pessoaid;
        $historico = $this->query('SELECT a.*, p.*, CASE WHEN a.motivo = 1 THEN \'COVID-19 (Leve)\' WHEN a.motivo = 0 THEN \'COVID-19 (Não Susp.)\' WHEN a.motivo = 2 THEN \'COVID-19 (Grave)\' END AS motivo2,  GROUP_CONCAT(s.sintoma) AS sintomas,
         a.atendimentoid AS atendimentoid2, a.datahora_atendimento AS datahora 
        FROM atendimento a                  
         INNER JOIN pessoa p ON (p.pessoaid = a.pessoaid) 
         LEFT JOIN atendimentosintoma s ON (s.atendimentoid = a.atendimentoid) 
         WHERE a.pessoaid = '.$pessoaid.' GROUP BY a.atendimentoid ORDER BY a.datahora_atendimento DESC');
        $this->set(compact(
            [
                'cidades'
                ,'cids'
                ,'hospitais'
                ,'totalligacoes'
                ,'covidleve'
                ,'covidgrave'
                ,'naosuspeito'
                ,'hospitais'
                ,'pessoa'
                ,'sintomaarray'
                ,'atendimento'
                ,'date'
                ,'customlabel1'
                ,'historico'
                ,'datetratamento'
                ,'dateprimeirosintoma'
                ,'datateste'
            ]
            ));
    }

    public function central24h() {
            $empresa = $this->sessionread('login.empresa');
            $mesAtual = Date('m');
            $ligacoespordia = $this->query(
                "SELECT
                SUM(l.a)/count(1) AS 'ligacoespordia'
                FROM (
                    SELECT 
                        DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                        ,COUNT(1) AS a
                    FROM atendimento
                    GROUP BY 1
                    ) l 
                "
            );
            $anoAtual = Date('Y');
            $ligacoesnomes = $this->query(
                "SELECT
                SUM(l.a) AS 'ligacoesmes'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento
                    WHERE DATE_FORMAT(`datahora_atendimento`, '%Y-%m') = '$anoAtual-$mesAtual'
                    ) l 
                "
            );
            $covidnomes = $this->query(
                "SELECT
                SUM(l.a) AS 'covidnomes'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento
                    ) l 
                "
            );
            $grave2 = $this->query(
                "SELECT
                SUM(l.a) AS 'grave'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento
                    WHERE motivo = 2
                    ) l 
                "
            );
            $gravemes = $this->query(
                "SELECT
                SUM(l.a) AS 'grave'
                FROM (
                    SELECT 
                        COUNT(1) AS a
                    FROM atendimento
                    WHERE motivo = 2 AND DATE_FORMAT(`datahora_atendimento`, '%Y-%m') = '$anoAtual-$mesAtual'
                    ) l 
                "
            );
            $ligacoes = $this->getAllTableWhere('Atendimento', [],[]);
    
            $quantidadeatendimentos = $this->query(
                "SELECT
                SUM(l.a)/count(1) AS '0-3'
                ,SUM(l.b)/count(1) AS '3-6'
                ,SUM(l.c)/count(1) AS '6-9'
                ,SUM(l.d)/count(1) AS '9-12'
                ,SUM(l.e)/count(1) AS '12-15'
                ,SUM(l.f)/count(1) AS '15-18'
                ,SUM(l.g)/count(1) AS '18-21'
                ,SUM(l.h)/count(1) AS '21-24'
                FROM (
                    SELECT 
                        DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 3 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 0 ) THEN 1 ELSE 0 END) AS a
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 6 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 3 ) THEN 1 ELSE 0 END) AS b
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 9 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 6 ) THEN 1 ELSE 0 END) AS c
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 12 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 9 ) THEN 1 ELSE 0 END) AS d
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 15 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 12 ) THEN 1 ELSE 0 END) AS e
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 18 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 15 ) THEN 1 ELSE 0 END) AS f
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 21 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 18 ) THEN 1 ELSE 0 END) AS g
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 24 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 21 ) THEN 1 ELSE 0 END) AS h
                    FROM atendimento
                    GROUP BY 1
                    ) l
                "
            );
            $dataAtual = Date('Y-m-d');
            $quantidadeatendimentoshoje = $this->query(
                "SELECT
                SUM(l.a) AS '0-3'
                ,SUM(l.b) AS '3-6'
                ,SUM(l.c) AS '6-9'
                ,SUM(l.d) AS '9-12'
                ,SUM(l.e) AS '12-15'
                ,SUM(l.f) AS '15-18'
                ,SUM(l.g) AS '18-21'
                ,SUM(l.h) AS '21-24'
                FROM (
                    SELECT 
                        DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 3 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 0 ) THEN 1 ELSE 0 END) AS a
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 6 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 3 ) THEN 1 ELSE 0 END) AS b
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 9 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 6 ) THEN 1 ELSE 0 END) AS c
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 12 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 9 ) THEN 1 ELSE 0 END) AS d
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 15 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 12 ) THEN 1 ELSE 0 END) AS e
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 18 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 15 ) THEN 1 ELSE 0 END) AS f
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 21 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 18 ) THEN 1 ELSE 0 END) AS g
                        ,SUM(CASE WHEN (DATE_FORMAT(`datahora_atendimento`, '%H') < 24 AND DATE_FORMAT(`datahora_atendimento`, '%H') >= 21 ) THEN 1 ELSE 0 END) AS h
                    FROM atendimento
                    WHERE DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') = '$dataAtual'
                    GROUP BY 1
                    ) l
                "
            );
            $atendimentospordia = $this->query(
                "SELECT 
                    DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') as data
                    ,DATE_FORMAT(`datahora_atendimento`, '%m') AS mes
                    ,DAY(`datahora_atendimento`) AS dia
                    ,COUNT(1) AS total
                    FROM atendimento
                    GROUP BY 1   ORDER BY 1 ASC    
                "
            );
            $media = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $atendimentospordiamedia = $this->query(
                "SELECT 
                    a.dia, SUM(a.total)/COUNT(*) as media FROM 
                    (SELECT
                        DATE_FORMAT(`datahora_atendimento`, '%m') AS mes
                        ,DAY(`datahora_atendimento`) AS dia
                        ,COUNT(1) AS total
                        FROM atendimento
                        GROUP BY 1,2  ORDER BY 1 ASC
                    ) a
                    GROUP BY 1
                "
            );
            foreach ($atendimentospordiamedia as $item) {
                $media[$item->dia -1] = $item->media;
            }
            $totalatendidohoje = $this->query(
                "SELECT 
                    COUNT(1) AS total
                    FROM atendimento
                    WHERE DATE_FORMAT(`datahora_atendimento`, '%Y-%m-%d') = '$dataAtual'
                    ORDER BY 1 ASC    
                "
            );
            $meses = $this->query(
                "SELECT DISTINCT
                    DATE_FORMAT(`datahora_atendimento`, '%m') AS mes
                    FROM atendimento
                "
            );
            $jandiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $fevdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $mardiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $abrdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $maidiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jundiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $juldiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $agodiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $setdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $outdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $novdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $dezdiario = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jan = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $fev = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $mar = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $abr = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $mai = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jun = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $jul = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $ago = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $set = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $out = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $nov = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $dez = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
            $janacum = 0;
            $fevacum = 0;
            $maracum = 0;
            $abracum = 0;
            $maiacum = 0;
            $junacum = 0;
            $julacum = 0;
            $agoacum = 0;
            $setacum = 0;
            $outacum = 0;
            $novacum = 0;
            $dezacum = 0;
            foreach ($atendimentospordia as $item) {
                if ($item->mes == '01') {
                    $jan[$item->dia -1] = $item->total + $janacum;
                    $jandiario[$item->dia -1] = $item->total;
                    $janacum = $jan[$item->dia -1];
                }
                if ($item->mes == '02') {
                    $fev[$item->dia -1] = $item->total + $fevacum;
                    $fevdiario[$item->dia -1] = $item->total;
                    $fevacum = $fev[$item->dia -1];
                }
                if ($item->mes == '03') {
                    $mar[$item->dia -1] = $item->total + $maracum;
                    $mardiario[$item->dia -1] = $item->total;
                    $maracum = $mar[$item->dia -1];
                }
                if ($item->mes == '04') {
                    $abr[$item->dia -1] = $item->total + $abracum;
                    $abrdiario[$item->dia -1] = $item->total;
                    $abracum = $abr[$item->dia -1];
                }
                if ($item->mes == '05') {
                    $mai[$item->dia -1] = $item->total + $maiacum;
                    $maidiario[$item->dia -1] = $item->total;
                    $maiacum = $mai[$item->dia -1];
                }
                if ($item->mes == '06') {
                    $jun[$item->dia -1] = $item->total + $junacum;
                    $jundiario[$item->dia -1] = $item->total;
                    $junacum = $jun[$item->dia -1];
                }
                if ($item->mes == '07') {
                    $jul[$item->dia -1] = $item->total + $julacum;
                    $juldiario[$item->dia -1] = $item->total;
                    $julacum = $jul[$item->dia -1];
                }
                if ($item->mes == '08') {
                    $ago[$item->dia -1] = $item->total + $agoacum;
                    $agodiario[$item->dia -1] = $item->total;
                    $agoacum = $ago[$item->dia -1];
                }
                if ($item->mes == '09') {
                    $set[$item->dia -1] = $item->total + $setacum;
                    $setdiario[$item->dia -1] = $item->total;
                    $setacum = $set[$item->dia -1];
                }
                if ($item->mes == '10') {
                    $out[$item->dia -1] = $item->total + $outacum;
                    $outdiario[$item->dia -1] = $item->total;
                    $outacum = $out[$item->dia -1];
                }
                if ($item->mes == '11') {
                    $nov[$item->dia -1] = $item->total + $novacum;
                    $novdiario[$item->dia -1] = $item->total;
                    $novacum = $nov[$item->dia -1];
                }
                if ($item->mes == '12') {
                    $dez[$item->dia -1] = $item->total + $dezacum;
                    $dezdiario[$item->dia -1] = $item->total;
                    $dezacum = $dez[$item->dia -1];
                }
            }
            $listameses = ['jan','fev','mar','abr','mai','jun','jul','ago','set','out','nov','dez'];
            for ($i = 1; $i < 31; $i++) {
                foreach ($listameses as $mes) {
                    if (${$mes}[$i] == 0) {
                        ${$mes}[$i] = ${$mes}[$i-1];
                    }
                }
            }
            
            $ligacoes = (object) [];
            $motivos = $this->query(
                "SELECT CASE WHEN motivo = 1 THEN 'LEVE'
                WHEN motivo = 2 THEN 'GRAVE'
                ELSE 'NÃO SUSPEITO' END AS motivo, COUNT(*) AS total
                FROM atendimento
                GROUP BY 1
                "
            );
            $somatotal = 0;
            foreach ($motivos as $item) {
                $somatotal += $item->total;
            }
            $motivosgrafico = $this->query(
                "SELECT SUM(CASE WHEN motivo = 1 THEN 1 ELSE 0 END) AS 'LEVE'
                        ,SUM(CASE WHEN motivo = 2 THEN 1 ELSE 0 END) AS 'GRAVE'
                        ,SUM(CASE WHEN motivo = 0 THEN 1 ELSE 0 END) AS 'SUSP'
                ,DATE_FORMAT(`datahora_atendimento`, '%d/%m/%Y') AS data
                ,`datahora_atendimento`
                FROM atendimento
                GROUP BY 4
                ORDER BY 5
                "
            );
            $grave = [];
            $leve = [];
            $suspeito = [];
            $dataatendimento = [];
            foreach ($motivosgrafico as $item) {
                array_push($leve, $item->LEVE);
                array_push($grave, $item->GRAVE);
                array_push($suspeito, $item->SUSP);
                array_push($dataatendimento, $item->data);
            }
            $beneficiarios = $this->query(
                "SELECT a.atendimentoid, p.nome, GROUP_CONCAT((CASE WHEN a.motivo = 0 THEN 'NÃO SUSP.' WHEN a.motivo = 1 THEN 'LEVE' WHEN a.motivo = 2 THEN 'GRAVE' END)) AS motivos, COUNT(1) AS ligacoes
                 FROM atendimento a 
                 LEFT JOIN pessoa p ON (p.pessoaid = a.pessoaid)
                 GROUP BY 2
                ");
            $this->set(compact([
                'ligacoes'
                ,'empresa'
                ,'top20'
                ,'quantidadeatendimentos'
                ,'quantidadeatendimentoshoje'
                ,'ligacoesnomes'
                ,'ligacoespordia'
                ,'covidnomes'
                ,'jan'
                ,'fev'
                ,'mar'
                ,'abr'
                ,'mai'
                ,'jun'
                ,'jul'
                ,'ago'
                ,'set'
                ,'out'
                ,'nov'
                ,'dez'
                ,'jandiario'
                ,'fevdiario'
                ,'mardiario'
                ,'abrdiario'
                ,'maidiario'
                ,'jundiario'
                ,'juldiario'
                ,'agodiario'
                ,'setdiario'
                ,'outdiario'
                ,'novdiario'
                ,'dezdiario'
                ,'ligacoes'
                ,'totalatendidohoje'
                ,'motivos'
                ,'beneficiarios'
                ,'media'
                ,'leve'
                ,'grave'
                ,'suspeito'
                ,'dataatendimento'
                ,'somatotal'
                ,'grave2'
                ,'gravemes'
            ]));
        }

    public function apiTeleatendimento($cpf) {
        $cpf = str_replace("-","",str_replace(".","", $cpf));
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "http://api.liga.org.br/account/login",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS =>"{\"username\":\"corpstec\",\"password\":\"HgfDDuW3UG5a9zu\"}",
          CURLOPT_HTTPHEADER => array(
            "accept: */*",
            "Content-Type: application/json"
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $json = json_decode($response);
        $token = $json->token;

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => "http://api.liga.org.br/Paciente/".$cpf,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_POSTFIELDS =>"\r\n{\r\n\t\"page\":1\r\n\t,\"limit\":1000\r\n}",
        CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
            "Authorization: Bearer ".$token
        ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $paciente = json_decode($response);

        $this->set([
            'paciente' => $paciente,
            '_serialize' => 'paciente',
        ]);
        $this->RequestHandler->renderAs($this, 'json');
    }

    public function agendamentosconferencia(){
        // $agenda = $this->;
    }

    public function videoconferencia(){
        if ($this->request->is('get')) {
           $sala = $_GET['sala'];
           $this->set([
                'sala' => $sala,
            ]);
        }
    }
}
