<?php
namespace App\Controller\Adm;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
/**
 * Usuario Controller
 *
 * @property \App\Model\Table\UsuarioTable $Usuario
 *
 * @method \App\Model\Entity\Usuario[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsuarioController extends AppController
{

	public function beforeRender(Event $event) {
		$action = $this->request->getParam('action');
		if(!in_array($this->perfilid(),[1]) && in_array($action,['view','edit'])){
			$id = $this->request->getParam('pass');
			
			$usuario = $this->Usuario->get($id, [
				'contain' => []
			]);
			
			if($this->empresaid() != $usuario->empresaid){
				echo "Usuário não pertence à sua empresa.";
				exit();
			}			
		}
		
		return parent::beforeRender($event);
	}
	
    public function index()
    {
		$wherearr = [1=>0];
		//administrador de sistema e secsis
		if(in_array($this->perfilid(),[1,7])){
			$wherearr = [1=>1];
		}
		
		//administrador de empresa e secretaria
		if(in_array($this->perfilid(),[3,6])){
			$wherearr = ['empresaid'=>$this->empresaid()];
		}
		
		//adm grupo
		if(in_array($this->perfilid(),[2])){
			$wherearr = ['empresaid IN'=>$this->grupoempresarialid()];
		}
		
		$query = $this->Usuario
					->find('all')
					->where($wherearr);
				
        $usuario = $query;

        $this->set(compact('usuario'));
    }

    /**
     * View method
     *
     * @param string|null $id Usuario id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $usuario = $this->Usuario->get($id, [
            'contain' => []
        ]);
		
		$pessoa  = $this->get('pessoa','pessoaid',$usuario->pessoaid);
		$modulos = $this->getAllTableWhere('modulousuario',['usuarioid'=>$usuario->usuarioid],[]);
		$perfis  = $this->getAllTableWhere('perfilusuario',['usuarioid'=>$usuario->usuarioid],[]);

        $this->set([
			'usuario'=>$usuario
			,'pessoa'=>$pessoa
			,'modulos'=>$modulos
			,'perfis'=>$perfis
			,'perfilid'=>$this->perfilid()
		]);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $usuario = $this->Usuario->newEntity();
		$perfilid = $this->sessionread('login.perfil')->perfilid;
        if ($this->request->is('post')) {
			$data = $this->request->getData();
			
			$empresaid = $this->empresaid();
			//é administrador de sistema
			if($perfilid == 1){
				$empresaid = $data['empresaid'];
			}
			//pessoa
			$data['cpfcnpj'] = str_replace(".","",str_replace("-","",$data['cpfcnpj']));
			$pessoaTable = TableRegistry::get('Pessoa');
			$pessoa = $pessoaTable->newEntity();
			
			if($this->validaData($data['datanascimento'])){
				$data['datanascimento'] = $this->formatDataToDatabase($data['datanascimento']);
			}else{
				$data['datanascimento'] = null;
			}
			$pessoa = $pessoaTable->patchEntity($pessoa, $data);
			$pessoa->pessoaidcadastro = $this->pessoaid();
			$pessoa->empresaid = $empresaid;
			
			if(!$pessoaTable->save($pessoa)){
				echo "Pessoa não pode ser salva<br>";$this->d($pessoa);
			}
			
			//usuario
            $usuario->pessoaid = $pessoa->pessoaid;
			$usuario->pessoaidcadastro = $this->pessoaid();
			$usuario->empresaid = $empresaid;
			$usuario->senha = $data['senha'];
			$usuario->ativo = $data['ativo'];
			$login = str_replace('.','',$data['cpfcnpj']);
			$login = str_replace('-','',$data['cpfcnpj']);
			$login = str_replace('/','',$data['cpfcnpj']);
			$usuario->login = $login;
			
			if(!$this->Usuario->save($usuario)){
				$this->remove('pessoa',['pessoaid'=>$usuario->pessoaid]);
				echo "Usuário não pode ser salvo<br>";$this->d($usuario);
			}
			
			//perfil
			foreach($data['perfil'] as $item){
				$this->insert('perfilusuario',[
					'perfilid'=>$item
					,'usuarioid'=>$usuario->usuarioid
					,'pessoaidcadastro'=>$this->pessoaid()
					,'empresaid'=>$empresaid
					,'ativo'=>1
				]);
				//perfil vendedor , insere na tabela vendedor
				if($item == 5){
					$this->insert('vendedor',[
						'pessoaid'=>$pessoa->pessoaid
						,'pessoaidcadastro'=>$this->pessoaid()
						,'empresaid'=>$empresaid
					]);
				}
			}
			//modulo
			foreach($data['modulo'] as $item){
				$this->insert('modulousuario',[
					'moduloid'=>$item
					,'usuarioid'=>$usuario->usuarioid
					,'pessoaidcadastro'=>$this->pessoaid()
					,'empresaid'=>$empresaid
					,'ativo'=>1
				]);
			}
			
			
			$this->Flash->success(__('Usuário criado com sucesso.'));
			return $this->redirect(['action' => 'index']);
		
        }
        $this->set(compact('usuario'));
		$this->set([
			'perfilid'=>$perfilid
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Usuario id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $usuario = $this->Usuario->get($id, [
            'contain' => []
        ]);
		$pessoa = $this->get('pessoa','pessoaid',$usuario->pessoaid);
		$perfilid = $this->sessionread('login.perfil')->perfilid;
		$empresaid = $this->empresaid();
        if ($this->request->is(['patch', 'post', 'put'])) {
            $data =  $this->request->getData();
			//é administrador de sistema
			if($perfilid == 1){
				$empresaid = $data['empresaid'];
			}
			$data['cpfcnpj'] = str_replace(".","",str_replace("-","",$data['cpfcnpj']));

			//pessoa
			$pessoaTable = TableRegistry::get('Pessoa');
			$pessoa = $pessoaTable->newEntity();
			
			if($this->validaData($data['datanascimento'])){
				$data['datanascimento'] = $this->formatDataToDatabase($data['datanascimento']);
			}else{
				$data['datanascimento'] = null;
			}
			$pessoa = $pessoaTable->patchEntity($pessoa, $data);
			$pessoa->pessoaid = $usuario->pessoaid;
			$pessoa->empresaid = $empresaid;
			if(!$pessoaTable->save($pessoa)){
				echo "Pessoa não pode ser salva<br>";$this->d($pessoa);
			}
			
			$usuario->empresaid = $empresaid;
			$usuario->ativo = array_key_exists('ativo',$data);
			$usuario->login = $pessoa->cpfcnpj;
			if(isset($data['senha']) && strlen($data['senha']) > 0){
				$usuario->senha = $data['senha'];
			}
			$usuarioTable = TableRegistry::get('Usuario');
			$usuarioTable->save($usuario);
			
			$this->update('usuario',['senha'=>$usuario->senha],['login'=>$usuario->login]);
			
			$this->Flash->success(__('Salvo com sucesso.'));
			return $this->redirect(['action' => 'view',$id]);
        }
        $this->set(compact('pessoa'));
		$this->set([
			'usuario'=>$usuario
			,'perfilid'=>$perfilid
		]);
    }

    /**
     * Delete method
     *
     * @param string|null $id Usuario id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $usuario = $this->Usuario->get($id);
		$this->remove('pessoa',['pessoaid'=>$usuario->pessoaid]);
		$this->remove('vendedor',['pessoaid'=>$usuario->pessoaid]);
		$this->remove('modulousuario',['usuarioid'=>$usuario->usuarioid]);
		$this->remove('perfilusuario',['usuarioid'=>$usuario->usuarioid]);
        if ($this->Usuario->delete($usuario)) {
            $this->Flash->success(__('The usuario has been deleted.'));
        } else {
            $this->Flash->error(__('The usuario could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
