<?php
/**
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link      http://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Controller\Controller;
use Cake\Event\Event;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;
use \stdClass;
use \DateTime;
use \Exception;
use Cake\Core\Configure;

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @link http://book.cakephp.org/3.0/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{

    public function initialize()
    {
        parent::initialize();
		$this->loadComponent('RequestHandler');
		$this->loadComponent('Flash');

		date_default_timezone_set('America/Sao_Paulo');

		$session = $this->request->session();

		$controller = strtolower($this->request->params['controller']);
		$prefix = "";
		if(isset($this->request->params['prefix'])){
			$prefix = strtolower($this->request->params['prefix']);
		}else{
			$prefix = $controller;
		}

		$usuario = 0;
		if($session->read('login.usuario') != null){
			$usuario = $session->read('login.usuario')->idusuario;
		}
		$ip = "";
		if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		} else {
			$REMOTE_ADDR = "";
			if(isset($_SERVER['REMOTE_ADDR'])){
				$REMOTE_ADDR = $_SERVER['REMOTE_ADDR'];
			}
			$ip = $REMOTE_ADDR;
		}
		$HTTP_HOST = "";
		if(isset($_SERVER['HTTP_HOST'])){
			$HTTP_HOST = $_SERVER['HTTP_HOST'];
		}
		$REQUEST_URI = "";
		if(isset($_SERVER['REQUEST_URI'])){
			$REQUEST_URI = $_SERVER['REQUEST_URI'];
		}
		$actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$HTTP_HOST$REQUEST_URI";

		if($prefix == "controladoria"){
		$this->insert('log_acesso',[
						'user'	=>$usuario
						,'url'=>$actual_link
						,'request'=>null
						,'ip'=>$ip
					],[]);
		}

		if($controller != "contexto"
			&& ($prefix == "adm" || $prefix == "inteligenciavendas" || $prefix == "emailnotificacao" || strpos($prefix, 'flystart') !== false 
			|| $prefix == "paciente" || $prefix == "medico" || $prefix == "secretaria")
			&& $session->read('login.empresa') != null){

				//mudar conexão de banco
				ConnectionManager::drop('conn1');
				$config = ConnectionManager::config('conn1', [
					'className' => 'Cake\Database\Connection',
					'driver' => 'Cake\Database\Driver\Mysql',
					'persistent' => true,
					'host' 	   => $session->read('login.empresa')->bancoflygestor_host,
					'username' => $session->read('login.empresa')->bancoflygestor_usuario,
					'password' => $session->read('login.empresa')->bancoflygestor_senha,
					'database' => $session->read('login.empresa')->bancoflygestor,
					'encoding' => 'utf8',
					'timezone' => '-3:00',
					'cacheMetadata' => true,

				]);
				
				$conn = ConnectionManager::get('conn1');
				ConnectionManager::alias('conn1', 'default');

			//contexto de empresa
			$empresas = $session->read('empresas');
			if(isset($_POST['contexto-idempresa'])){
				if($_POST['contexto-idempresa'] == -1){
					$session->write([
						'empresa'=>$empresas
					]);
				}else{
					foreach($empresas as $empresa){
						if($empresa['idempresa'] == $_POST['contexto-idempresa']){
							$session->write([
								'empresa'=>[$empresa]
							]);
						}
					}
				}
			}

			//contexto de filial
			$filiais = $session->read('filiais');
			if(isset($_POST['contexto-idfilial'])){
				if(count($_POST['contexto-idfilial']) == count($filiais)){
					$session->write([
						'filial'=>$filiais
					]);
				}else{
					$arrfilial = [];
					foreach($filiais as $filial){
						foreach($_POST['contexto-idfilial'] as $filialcontexto){
							if($filial['idfilial'] == $filialcontexto){
								array_push($arrfilial,$filial);
							}
						}
					}
					$session->write([
						'filial'=>$arrfilial
					]);
				}
			}
		}

		//echo $prefix;exit();
		if($prefix == "controladoria" && $session->read('login.empresa')->idempresa != 1){
			if (isset($_SESSION)) {
				session_destroy();
			}
			$this->request->session()->destroy();
			$this->redirect('/');
		}
    }

	public function existsLocalDatabase(){
		$session = $this->request->session();
		//verifica se existe banco
		$bancoflygestor = $session->read('login.empresa')->bancoflygestor;
		$sql = "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '$bancoflygestor'";
		$existsDatabase = $this->query($sql);
		if(is_array($existsDatabase) && count($existsDatabase)>0){
			return true;
		}
		return false;
	}

    /**
     * Before render callback.
     *
     * @param \Cake\Event\Event $event The beforeRender event.
     * @return \Cake\Network\Response|null|void
     */
    public function beforeRender(Event $event)
    {
        if (!array_key_exists('_serialize', $this->viewVars) &&
            in_array($this->response->type(), ['application/json', 'application/xml'])
        ) {
            $this->set('_serialize', true);
        }
    }

	public function textoLink($text){
		$reg_exUrl = "/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/";
		if(preg_match($reg_exUrl, $text, $url)) {
			return preg_replace($reg_exUrl, "<a target=\"_BLANK\" href=".$url[0].">".$url[0]."</a> ", $text);
		} else {
			return $text;
		}
	}

	public function getUltimoDiaMes($mes=null){
		if($mes == null){
			$date = new DateTime('now');
			$date->modify('last day of this month');
			return $date->format('d');
		}else{
			$year = date('Y');
			$date = new DateTime("$year-$mes-01");
			$date->modify('last day of this month');
			return $date->format('d');
		}
	}

	public function getData($getvalue){
		$data = null;

		if(isset($_GET[$getvalue])){
			if ($_GET[$getvalue] == null || trim($_GET[$getvalue]) == "" || strtoupper($_GET[$getvalue]) == "NULL"){
				return null;
			}

			$arrdate = explode('/',$_GET[$getvalue]);
			$d = $arrdate[0];
			$m = $arrdate[1];
			$y = $arrdate[2];
			$data = "$y-$m-$d";
		}

		return $data;
	}

	public function getPeriodo($getvalue){
		$arr = [];

		if(isset($_REQUEST[$getvalue])){
			if ($_REQUEST[$getvalue] == null || trim($_REQUEST[$getvalue]) == "" || strtoupper($_REQUEST[$getvalue]) == "NULL"){
				return null;
			}

			$datainicio = explode(' - ',$_REQUEST[$getvalue])[0];
			$datafim    = explode(' - ',$_REQUEST[$getvalue])[1];

			$arrdate = explode('/',$datainicio);
			$d = $arrdate[0];
			$m = $arrdate[1];
			$y = $arrdate[2];
			$datainicio = "$y-$m-$d";

			$arrdate = explode('/',$datafim);
			$d = $arrdate[0];
			$m = $arrdate[1];
			$y = $arrdate[2];
			$datafim = "$y-$m-$d";

			$arr = array($datainicio,$datafim);
		}

		return $arr;
	}

	function getIdEmpresaContexto(){
		$idempresa = "";
		$session = $this->request->session();
		$empresacontexto = $session->read('empresa');
		if(!$empresacontexto){
			return "";
		}
		for($i = 0; $i < count($empresacontexto); $i++){
			if($i == 0){
				$idempresa = $empresacontexto[$i]['idempresa'];
			}else{
				$idempresa = $idempresa .','.  $empresacontexto[$i]['idempresa'];
			}
		}

		return $idempresa;
	}

	function getIdFilialContexto(){
		$idfilial = "";
		$session = $this->request->session();
		$filialcontexto = $session->read('filial');
		if(!$filialcontexto){
			return "";
		}
		for($i = 0; $i < count($filialcontexto); $i++){
			if($i == 0){
				$idfilial = $filialcontexto[$i]['idfilial'];
			}else{
				$idfilial = $idfilial .','. $filialcontexto[$i]['idfilial'];
			}
		}
		return $idfilial;
	}

	function queryjson($sqlfile, $arrParametros = []){
		$session = $this->request->session();
		if(!$session->read('login.empresa')){
			return $this->redirect('/');
		}

		$key 	= $session->read('login.empresa')->conexao_key;
		$ip 	= $session->read('login.empresa')->conexao_ip;
		$porta 	= $session->read('login.empresa')->conexao_porta;
		$erp 	= $session->read('login.empresa')->erp;
		$pathfileservice = $session->read('login.empresa')->conexao_path;
		$idempresa = $session->read('login.empresa')->idempresa;
		$pathempresa = "../consultas/$erp/$idempresa/$sqlfile.sql";
		
		if($erp == null){echo "sessão encerrada";}

		if(file_exists($pathempresa)){
			$path = $pathempresa;
		}else{
			$path = "../consultas/$erp/$sqlfile.sql";
		}


		if(!file_exists($path)){
			echo "<b>Arquivo não encontrado:</b> $path";
			exit();
		}

		$sql = file_get_contents($path);

		if(is_array($arrParametros) && count($arrParametros)>0){
			foreach($arrParametros as $arrkey=>$arrvalue){
				$sql = str_replace('$'.$arrkey,$arrvalue,$sql);
			}
		}

		$encripted_sql = $this->cryptdata($sql,'e');
		$encripted_key = $this->cryptdata($key,'e');
		$data          = ["key"=>$encripted_key, "sql"=>$encripted_sql];
		$url           = "http://$ip:$porta/$pathfileservice";
		//

		$json = null;
		if($erp == "scgwin_cloud"){
			return $this->queryscgwincloud($url,$path,$sql);
		}else{
			$json = $this->httpPost($url,$data);
		}
		//
		if(!$this->isJson($json) && Configure::read('debug')){
			$sql = preg_replace("/\\n/m", "<br />", $sql);
			echo "<b>Ocorreu um erro interno. Tente novamente em instantes.</b><br>";
			if($this->isLocalhost()){
				echo "<b>Arquivo:</b> <br>$path<br>";
				echo "<b>Consulta:</b> <br>$sql</br>";
				echo "<b>Mensagem:</b> <br>$json";
			}
			exit();
		}
		//
		if($json == null){
			echo "Ocorreu um erro de conexão com o servidor.<br>";
			echo "Tentou conectar em $ip:$porta";
			exit();
		}

		return json_decode($json);
	}

	function queryscgwincloud($url,$path,$sql){
		$username = "apsinformatica";
		$password = "YXBzYXBzMTEz";

		$sqloriginal = preg_replace("/\\n/m", "<br />", $sql);

		$sql = preg_replace( "/\r|\n/", " ", $sql );
		$sql = urlencode($sql);
		$url = str_replace("http", "https", $url)."/Sistema/ConsultaSQL/Listar/Receber?sql=$sql";

		$headers = array(
			'Content-Type: application/json',
			'Authorization: Basic '. base64_encode("$username:$password")
		);

		$response = $this->httpGet($url,$headers);

		$json = json_decode($response);
		if(Configure::read('debug') &&
			(!is_array($json) || (count($json) == 1 && isset($json[0]->mensagem)))
			){
			$mensagem = $json[0]->mensagem;
			$sql = preg_replace("/\\n/m", "<br />", $sql);
			echo "<b>Ocorreu um erro interno. Tente novamente em instantes.</b><br>";
			if($this->isLocalhost()){
				echo "<b>Arquivo:</b> <br>$path<br>";
				echo "<b>Consulta:</b> <br>$sqloriginal</br>";
				echo "<b>Mensagem:</b> <br>$mensagem";
			}
			exit();

		}else{
			for($i=0;$i<count($json);$i++){
				$temp = (array) $json[$i];
				$temp = array_change_key_case($temp ,CASE_LOWER);
				$json[$i] = (object) $temp;
			}
		}

		return $json;
	}

	function isJson($string) {
		json_decode($string);
		return (json_last_error() == JSON_ERROR_NONE);
	}

	function cryptdata( $string, $action = 'e' ) {
		$secret_key = '8d9$fdf#56c0a27433!3e7c';
		$secret_iv  = '9b47^c7ef1958&ffc419@d1';

		$output = false;
		$encrypt_method = "AES-256-CBC";
		$key = hash( 'sha256', $secret_key );
		$iv = substr( hash( 'sha256', $secret_iv ), 0, 16 );

		if( $action == 'e' ) {
			$output = base64_encode( openssl_encrypt( $string, $encrypt_method, $key, 0, $iv ) );
		}
		else if( $action == 'd' ){
			$output = openssl_decrypt( base64_decode( $string ), $encrypt_method, $key, 0, $iv );
		}

		return $output;
	}

	public function mesreferencia(){
		return date('m');
	}

	public function anoreferencia(){
		return date('Y');
	}


	function httpPost($url, $data, $headers=null){
		$curl = curl_init(rawurlencode($url));
		curl_setopt($curl, CURLOPT_POST, true);
		if(is_array($data)){
			curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
		}else{
			curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
		}
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true );
		curl_setopt($curl, CURLOPT_TIMEOUT, 900);
		curl_setopt($curl, CURLOPT_URL, trim($url));
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

		if($headers){
			curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		}

		$response = curl_exec($curl);
		if ($response === false) {
			echo "<b>Ocorreu um erro de rede. Tente novamente em instantes.</b><br>";
			echo "<b>Url:</b> <br>$url<br>";
			echo "<b>Mensagem:</b> <br>".curl_error($curl);
			exit();
		}
		curl_close($curl);
		return $response;
    }




    function httpPost2($url, $post_data) {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_USERPWD, 'apsinformatica' . ":" . 'YXBzYXBzMTEz');
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        // post_data
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $post_data);

        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_VERBOSE, true);

        $intRetries = 3;
        $intCount = 1;
        do {
            $result['result'] = curl_exec($curl);

            $result['info'] = curl_getinfo($curl);
            if ($result['result'] == false) {
                $result['error'] = curl_error($curl) . " (" . curl_errno($curl) . ")";
            }
            $intCount++;
        } while (($intCount != $intRetries) && ($result['result'] == false));

        curl_close($curl);
        return $result;
    }

	function httpGet($url,$headers){
		$curl = curl_init(rawurlencode($url));
		curl_setopt($curl, CURLOPT_HTTPGET, true);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true );
		curl_setopt($curl, CURLOPT_TIMEOUT, 900);
		curl_setopt($curl, CURLOPT_URL, trim($url));
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

		$response = curl_exec($curl);
		if ($response === false) {
			echo "<b>Ocorreu um erro de rede. Tente novamente em instantes.</b><br>";
			echo "<b>Url:</b> <br>$url<br>";
			echo "<b>Mensagem:</b> <br>".curl_error($curl);
			exit();
		}

		return $response;
	}

	public function uploadFile($file, $prefix = null, $extensoesPermitidasArr = null){
		if($file!= null && strlen($file['name']) != 0 && strlen($file['tmp_name']) != 0){
			$extensao = pathinfo($file['name'], PATHINFO_EXTENSION);
			if($extensoesPermitidasArr != null && !in_array($extensao,$extensoesPermitidasArr)){
				return null;
			}

			$filename = $prefix.$file['name'];
			$uploadfile = $this->getUploadDir() . basename($file['name']);
			move_uploaded_file($file['tmp_name'], $uploadfile);

			return $filename;
		}
		return null;
	}
	public function getInnerJoin($table1,$table2,$arr1,$arr2,$order){
		$table  = TableRegistry::get($table1);
		$arr = $table
					->find('all')
					->innerJoin($table2, $arr1)
					->where($arr2)
					->order($order)
					->toArray();
		return $arr;
	}
	public function d($value,$message = null){
		debug($value);
		if(isset($message)){
			throw new Exception($message);
		}
		exit();
	}

	function arrtoserie($arr, $colArr){
		$result = [];
		foreach($colArr as $value){
			$result[$value] = [];
		}

		foreach($arr as $arrLinha){
			foreach($arrLinha as $key=>$value){
				if(is_numeric($value)){
					$value = (float)$value;
				}
				array_push($result[$key],$value);

			}
		}
		return $result;
	}

	public function get($table, $column, $value){
		$table  = TableRegistry::get($table);
		$object = $table
						->find('all')
						->where([$column=>$value])
						->first();

		return $object;
	}

	public function getTableWhere($table, $arr){
		$table  = TableRegistry::get($table);
		$object = $table
						->find('all')
						->where($arr)
						->first();

		return $object;
	}

	public function getAll($table, $column, $value){
		$table  = TableRegistry::get($table);
		$arr = $table
					->find('all')
					->where([$column=>$value]);
		return $arr;
	}

	public function getAllTableWhere($table, $arr, $order=[]){
		$table  = TableRegistry::get($table);
		$arr = $table
					->find('all')
					->where($arr)
					->order($order);
		return $arr;
	}

	public function getAllTableWhereLimit($table, $arr, $order=[], $limit){
		$table  = TableRegistry::get($table);
		$arr = $table
					->find('all')
					->where($arr)
					->order($order)
					->limit($limit);
		return $arr;
	}

	public function getLimit(){
		$page = "";
		$pageTotal = "";

		$limit = "";
		if(isset($_GET['page']) && $_GET['page'] > 1 && isset($_GET['pageTotal']) && $_GET['pageTotal'] > 1){
			$page = $_GET['page'];
			$pageTotal = $_GET['pageTotal'];

			$page = ($page -1)* $pageTotal;
			$limit = "LIMIT $pageTotal OFFSET $page;";
		}else{
			$limit = "LIMIT 10";
		}

		return $limit;
	}

	public function query($sql){
		$connection = ConnectionManager::get('default');
        $query = $connection->execute($sql)->fetchall('assoc');
		return $this->arrayToArrayObj($query);
	}

	public function queryArr($sql){
		$connection = ConnectionManager::get('default');
        $query = $connection->execute($sql)->fetchall('assoc');
		return $query;
	}

	public function update($table,$setArr,$whereArr){
		$connection = ConnectionManager::get('default');
        $connection->update($table,$setArr,$whereArr);
	}

	public function insert($table,$setArr,$whereArr = []){
		$connection = ConnectionManager::get('default');
        $connection->insert($table,$setArr,$whereArr);
	}

	public function remove($table,$whereArr){
		$connection = ConnectionManager::get('default');
        $connection->delete($table,$whereArr);
	}

	public function toMes($num, $abrev = false){
		$mes = [
			'Janeiro',
			'Fevereiro',
			'Março',
			'Abril',
			'Maio',
			'Junho',
			'Julho',
			'Agosto',
			'Setembro',
			'Outubro',
			'Novembro',
			'Dezembro'
		];

		$value = $mes[$num-1];
		if($abrev){
			$value = substr($value, 0, 3);
		}

		return $value;
	}

	public function isLocalhost(){
		$whitelist = array('127.0.0.1', "::1");
		$REMOTE_ADDR = "";
		if(isset($_SERVER['REMOTE_ADDR'])){
			$REMOTE_ADDR = $_SERVER['REMOTE_ADDR'];
		}
		if(in_array($REMOTE_ADDR, $whitelist)){
			return true;
		}
		return false;
	}

	public function arrayToObj($arr){
		$object = new stdClass();
		foreach ($arr as $key => $value)
		{
			if(is_float($value) && strlen($value) <= 8) { $value = (float)$value;}

			if(is_int($value) && strlen($value) <= 8) { $value = (int)$value;}
			$object->$key = $value;
		}
		return $object;
	}

	public function arrayToArrayObj($arr){
		$arr2 = [];
		foreach ($arr as $key => $value){
			$value2 = $this->arrayToObj($value);
			array_push($arr2,$value2);
		}
		return $arr2;
	}

	public function isPostInputsEmpty($arrayInput){
		foreach($arrayInput as $item){
			if(!isset($_POST[$item]) || $_POST[$item] == null || $_POST[$item] == trim("")){
				return $item;
			}
		}
		return true;
	}

	public function validaData($dat){
		$data = explode("/","$dat"); // fatia a string $dat em pedados, usando / como referência
		if(count($data) != 3){
			return false;
		}

		$d = $data[0];
		$m = $data[1];
		$y = $data[2];

		// verifica se a data é válida!
		// 1 = true (válida)
		// 0 = false (inválida)
		$res = checkdate($m,$d,$y);
		if ($res == 1){
		   return true;
		} else {
		   return false;
		}
	}

	public function validaHora($string){
		return preg_match("/(2[0-3]|[01][0-9]):([0-5][0-9])/", $string);
	}

	public function validaEmail($email){
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
		  return false;
		}
		return true;
	}

	public function validaCPF($cpf = null) {

		// Verifica se um número foi informado
		if(empty($cpf)) {
			return false;
		}

		// Elimina possivel mascara
		//$cpf = ereg_replace('[^0-9]', '', $cpf);
		$cpf = str_replace('.', '', $cpf);
		$cpf = str_replace('-', '', $cpf);
		$cpf = str_pad($cpf, 11, '0', STR_PAD_LEFT);
		// Verifica se o numero de digitos informados é igual a 11
		if (strlen($cpf) != 11) {
			return false;
		}
		// Verifica se nenhuma das sequências invalidas abaixo
		// foi digitada. Caso afirmativo, retorna falso
		else if ($cpf == '00000000000' ||
			$cpf == '11111111111' ||
			$cpf == '22222222222' ||
			$cpf == '33333333333' ||
			$cpf == '44444444444' ||
			$cpf == '55555555555' ||
			$cpf == '66666666666' ||
			$cpf == '77777777777' ||
			$cpf == '88888888888' ||
			$cpf == '99999999999') {
			return false;
		 // Calcula os digitos verificadores para verificar se o
		 // CPF é válido
		 } else {

			for ($t = 9; $t < 11; $t++) {

				for ($d = 0, $c = 0; $c < $t; $c++) {
					$d += $cpf[$c] * (($t + 1) - $c);
				}
				$d = ((10 * $d) % 11) % 10;
				if ($cpf[$c] != $d) {
					return false;
				}
			}

			return true;
		}
	}

	public function toJsonArr($arr, $arrWords){
		$json = json_encode($arr);
		$json = str_replace('}',']',$json);
		$json = str_replace('{','[',$json);
		$json = str_replace('{','[',$json);
		foreach($arrWords as $item){
			$json = str_replace('"'.$item.'":','',$json);
		}

		$json = str_replace(']]',']',$json);
		$json = str_replace('[[','[',$json);
		$json = str_replace(']]',']',$json);
		$json = str_replace('[[','[',$json);


		return $json;
	}

	public function getAno(){
		$ano = date("Y");
		if(isset($_REQUEST['ano'])){
			if($_REQUEST['ano'] > date("Y")){
				$this->Flash->error(__('Ano não disponível: '.$_REQUEST['ano']));
			}else{
				$ano = $_REQUEST['ano'];
			}
		}
		return $ano;
	}

	public function getMes(){
		$mes = date('m');

		if(isset($_REQUEST['mes'])){
			if($_REQUEST['mes'] > 12){
				if($ano < date("Y")){
					$mes = 1;
					$ano = $ano +1;
				}else{
					$this->Flash->error(__('Ano não disponível'));
				}
			}else if($_REQUEST['mes'] < 1){
					$mes = 12;
					$ano = $ano - 1;
			}else{
				$mes = $_REQUEST['mes'];
			}
		}
		return $mes;
	}

	public function getDia(){
		$dia = date('d');
		return $dia;
	}

	function isValidDate($date, $format = 'Y-m-d H:i:s'){
		$d = DateTime::createFromFormat($format, $date);
		return $d && $d->format($format) == $date;
	}

	public function toFloat($number){
		if(is_numeric($number)){
			return number_format($number,2,",",".");
		}
		return 0;
	}

	public function formatData($data){
		$dataoriginal = $data;

		if ($data == null || trim($data) == "" || strtoupper($data) == "NULL"){
			return "";
		}

		if(count(explode(" ",$data)) > 1){
			$data = explode(" ",$data)[0];
		}

		$arrdate = explode('-',$data);

		if(count($arrdate)!=3){
			return $dataoriginal;
		}

		$d = $arrdate[2];
		$m = $arrdate[1];
		$y = $arrdate[0];

		return "$d/$m/$y";
	}

	public function formatDataToDatabase($data){
		if ($data == null || trim($data) == "" || strtoupper($data) == "NULL"){
			return "";
		}

		if(count(explode(" ",$data)) > 1){
			$data = explode(" ",$data)[0];
		}

		$arrdate = explode('/',$data);
		$d = $arrdate[0];
		$m = $arrdate[1];
		$y = $arrdate[2];
		return "$y-$m-$d";
	}

	public function formatDatetimeToDatabase($data){
		if ($data == null || trim($data) == "" || strtoupper($data) == "NULL"){
			return null;
		}

		 if(count(explode(" ",$data)) > 1){
            $data1 = explode(" ",$data)[0];
        }

         if(count(explode(" ",$data)) > 1){
            $hora = explode(" ",$data)[1];
        }

		$arrdate = explode('/',$data1);
		$d = $arrdate[0];
		$m = $arrdate[1];
		$y = $arrdate[2];

		return "$y-$m-$d $hora";
	}

	public function session(){
		return $this->request->getSession();
	}

	public function sessionread($value){
		return $this->request->getSession()->read($value);
	}

	public function sessionwrite($key,$value){
		return $this->request->getSession()->write($key,$value);
	}

	public function usuarioid(){
		return $this->sessionread('login.usuario')->idusuario;
	}
	
	public function medicoid()
	{
		$medico = $this->query("SELECT medicoid FROM medico as m
		INNER JOIN usuario as u ON m.usuarioid = u.idusuario WHERE u.idusuario = ".$this->usuarioid())[0];
		return $medico->medicoid;
	}

	public function perfilid(){
		$session = $this->request->session();
		if($session->read('login.perfilcrm') != null ){
			$perfil = $session->read('login.perfilcrm');
		}
	
		return $perfil->idperfil_crm;
	}

	public function empresaid(){
		$session = $this->request->session();
		$usuario = $session->read('login.usuario');
		$usuario_crm = $this->get('usuario_crm','usuarioid',$usuario->idusuario);
		return $usuario_crm->empresaid;
	}

	public function pessoaid(){
		$session = $this->request->session();
		$usuario = $session->read('login.usuario');
		$usuario_crm = $this->get('usuario_crm','usuarioid',$usuario->idusuario);
		return $usuario_crm->pessoaid;
	}
	
	public function vendedorid(){
		$empresaid = $this->empresaid();
		$pessoaid = $this->pessoaid();
		$vendedor = $this->getAllTableWhere('vendedor',[
														'pessoaid'=>$pessoaid
														,'idempresa_crm'=>$empresaid
														],[]);								
		if($vendedor->count() == 0){
			return null;
		}
		return $vendedor->first()->idvendedor;
	}

	public function possuiacesso($empresa){
		$modulos = $this->getInnerJoin('modulo','modulousuario',['modulousuario.moduloid = modulo.idmodulo'],['modulo.ativo'=> 1
		,'modulousuario.usuarioid'=>$this->usuarioid()],['ordem'=>'asc']);

		$acesso = false;
		foreach ($modulos as $modulo) {
			if ($modulo->nome == $empresa) {
				$acesso = true;
				break;
			}
		}
		
		return $acesso;
	}
	public function cpfRandom($mascara = "1") {
	    $n1 = rand(0, 9);
	    $n2 = rand(0, 9);
	    $n3 = rand(0, 9);
	    $n4 = rand(0, 9);
	    $n5 = rand(0, 9);
	    $n6 = rand(0, 9);
	    $n7 = rand(0, 9);
	    $n8 = rand(0, 9);
	    $n9 = rand(0, 9);
	    $d1 = $n9 * 2 + $n8 * 3 + $n7 * 4 + $n6 * 5 + $n5 * 6 + $n4 * 7 + $n3 * 8 + $n2 * 9 + $n1 * 10;
	    $d1 = 11 - (self::mod($d1, 11) );
	    if ($d1 >= 10) {
	        $d1 = 0;
	    }
	    $d2 = $d1 * 2 + $n9 * 3 + $n8 * 4 + $n7 * 5 + $n6 * 6 + $n5 * 7 + $n4 * 8 + $n3 * 9 + $n2 * 10 + $n1 * 11;
	    $d2 = 11 - (self::mod($d2, 11) );
	    if ($d2 >= 10) {
	        $d2 = 0;
	    }
	    $retorno = '';
	    if ($mascara == 1) {
	        $retorno = '' . $n1 . $n2 . $n3 . "." . $n4 . $n5 . $n6 . "." . $n7 . $n8 . $n9 . "-" . $d1 . $d2;
	    } else {
	        $retorno = '' . $n1 . $n2 . $n3 . $n4 . $n5 . $n6 . $n7 . $n8 . $n9 . $d1 . $d2;
	    }
	    return $retorno;
	}

	public function mod($dividendo, $divisor) {
        return round($dividendo - (floor($dividendo / $divisor) * $divisor));
    }

    public function toPerc($number,$total){
		if($number == "" || $number == null || $number == 0){
			return "0%";
		}
		if($total == "" || $total == null || $total == 0){
			return "0%";
		}
		return str_replace('.',',',round(($number/$total*100),2))."%";
	}

	public function datatableQuerytojson(TableRegistry $Objects,$data){
		
		foreach($Objects as $Object){
			array_push($Objects,array([$Object]));
		}
		$this->$Objects->find('all',[
			'order'=>$data['order'][0]['column']." ". $data['order'][0]['dir']
			,'limit'=> $data['start'].', '.$data['length']
	]);
		
		$datatablejson = array(
			'draw'=>intval($data["draw"])
			,'recordsTotal'=>count($Object)
			,'recordsFiltered'=>count($Object)
			,'data'=> (array) [$Object]
		);

		return json_encode($datatablejson);


	}

	public function datatableQueryjsontojson($Objects,$data){
		if($Objects == null){
			return null;
		}
		$recordsTotal = count($Objects);
		$recordsFiltered = count($Objects);

		$arr = array($Objects);	

		$resultarr = array();
			if($data['search']['value'] != null){
				$input = strtoupper($data['search']['value']);
				$count_colunas = count($data['columns']);
				$count_linhas = count($arr[0]);
				$colunas = [];
				for ($i=0; $i < $count_colunas; $i++) { 
					$colunas[$i] =  $data['columns'][$i]['data'];
				}

				for ($i=0; $i < $count_linhas; $i++) { 
					for ($j=0; $j < $count_colunas; $j++) {
						if(strpos($arr[0][$i]->{$colunas[$j]},$input) !== false){
							$resultarr[$i] = $arr[0][$i];
						}
					}
					
					
				}

				$Objects = $resultarr;
				$recordsFiltered = count($Objects);
			}		
			if(isset($data['order'][0]['column'])){
				$coluna = $data['columns'][$data['order'][0]['column']]['data'];
				$arr = array();
				foreach($Objects as $Object){
					foreach($Object as $key => $value){
						if(!isset($arr[$key])){
							$arr[$key] = array();
						}
						$arr[$key][] = $value;
					}
				}
				
				if($data['order'][0]['dir'] == 'asc'){
					$dir = SORT_ASC;
				}else{
					$dir = SORT_DESC;
				}

				array_multisort($arr[$coluna],$dir,$Objects);

			}
		$Object = $Objects;
		$Object = array_slice($Object,$data['start'],$data['length']);
		
		$datatablejson = array(
			'draw'=> intval($data["draw"])
			,'recordsTotal'=>intval($recordsTotal)
			,'recordsFiltered'=>intval($recordsFiltered)
			,'data'=> $Object
		);

		return json_encode($datatablejson);


	}

	function searchArray($array, $key, $value) { 
		$results = array(); 
		  
		// if it is array 
		if (is_array($array)) { 
			  
			// if array has required key and value 
			// matched store result  
			if (isset($array[$key]) && $array[$key] == $value) { 
				$results[] = $array; 
			} 
			  
			// Iterate for each element in array 
			foreach ($array as $subarray) { 
				  
				// recur through each element and append result  
				$results = array_merge($results,  
						search($subarray, $key, $value)); 
			} 
		} 
	  
		return $results; 
	} 

	

}
