<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Grauinteressecontato Controller
 *
 * @property \App\Model\Table\GrauinteressecontatoTable $Grauinteressecontato
 *
 * @method \App\Model\Entity\Grauinteressecontato[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class GrauinteressecontatoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $grauinteressecontato = $this->paginate($this->Grauinteressecontato);

        $this->set(compact('grauinteressecontato'));
    }

    /**
     * View method
     *
     * @param string|null $id Grauinteressecontato id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $grauinteressecontato = $this->Grauinteressecontato->get($id, [
            'contain' => []
        ]);

        $this->set('grauinteressecontato', $grauinteressecontato);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $grauinteressecontato = $this->Grauinteressecontato->newEntity();
        if ($this->request->is('post')) {
            $grauinteressecontato = $this->Grauinteressecontato->patchEntity($grauinteressecontato, $this->request->getData());
            if ($this->Grauinteressecontato->save($grauinteressecontato)) {
                $this->Flash->success(__('The grauinteressecontato has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The grauinteressecontato could not be saved. Please, try again.'));
        }
        $this->set(compact('grauinteressecontato'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Grauinteressecontato id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $grauinteressecontato = $this->Grauinteressecontato->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $grauinteressecontato = $this->Grauinteressecontato->patchEntity($grauinteressecontato, $this->request->getData());
            if ($this->Grauinteressecontato->save($grauinteressecontato)) {
                $this->Flash->success(__('The grauinteressecontato has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The grauinteressecontato could not be saved. Please, try again.'));
        }
        $this->set(compact('grauinteressecontato'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Grauinteressecontato id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $grauinteressecontato = $this->Grauinteressecontato->get($id);
        if ($this->Grauinteressecontato->delete($grauinteressecontato)) {
            $this->Flash->success(__('The grauinteressecontato has been deleted.'));
        } else {
            $this->Flash->error(__('The grauinteressecontato could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
