<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Origemlead Controller
 *
 * @property \App\Model\Table\OrigemleadTable $Origemlead
 *
 * @method \App\Model\Entity\Origemlead[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class OrigemleadController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $origemlead = $this->paginate($this->Origemlead);

        $this->set(compact('origemlead'));
    }

    /**
     * View method
     *
     * @param string|null $id Origemlead id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $origemlead = $this->Origemlead->get($id, [
            'contain' => []
        ]);

        $this->set('origemlead', $origemlead);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $origemlead = $this->Origemlead->newEntity();
        if ($this->request->is('post')) {
            $origemlead = $this->Origemlead->patchEntity($origemlead, $this->request->getData());
			$origemlead->empresaid = 1;
			$origemlead->pessoaidcadastro = 1;
            if ($this->Origemlead->save($origemlead)) {
                $this->Flash->success(__('The origemlead has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The origemlead could not be saved. Please, try again.'));
        }
        $this->set(compact('origemlead'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Origemlead id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $origemlead = $this->Origemlead->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $origemlead = $this->Origemlead->patchEntity($origemlead, $this->request->getData());
            if ($this->Origemlead->save($origemlead)) {
                $this->Flash->success(__('The origemlead has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The origemlead could not be saved. Please, try again.'));
        }
        $this->set(compact('origemlead'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Origemlead id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $origemlead = $this->Origemlead->get($id);
        if ($this->Origemlead->delete($origemlead)) {
            $this->Flash->success(__('The origemlead has been deleted.'));
        } else {
            $this->Flash->error(__('The origemlead could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
