<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Parametro Controller
 *
 * @property \App\Model\Table\ParametroTable $Parametro
 *
 * @method \App\Model\Entity\Parametro[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ParametroController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $parametro = $this->paginate($this->Parametro);

        $this->set(compact('parametro'));
    }

    /**
     * View method
     *
     * @param string|null $id Parametro id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $parametro = $this->Parametro->get($id, [
            'contain' => []
        ]);

        $this->set('parametro', $parametro);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $parametro = $this->Parametro->newEntity();
        if ($this->request->is('post')) {
            $parametro = $this->Parametro->patchEntity($parametro, $this->request->getData());
            if ($this->Parametro->save($parametro)) {
                $this->Flash->success(__('The parametro has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The parametro could not be saved. Please, try again.'));
        }
        $this->set(compact('parametro'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Parametro id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $parametro = $this->Parametro->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $parametro = $this->Parametro->patchEntity($parametro, $this->request->getData());
            if ($this->Parametro->save($parametro)) {
                $this->Flash->success(__('The parametro has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The parametro could not be saved. Please, try again.'));
        }
        $this->set(compact('parametro'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Parametro id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $parametro = $this->Parametro->get($id);
        if ($this->Parametro->delete($parametro)) {
            $this->Flash->success(__('The parametro has been deleted.'));
        } else {
            $this->Flash->error(__('The parametro could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
