<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Statuscontato Controller
 *
 * @property \App\Model\Table\StatuscontatoTable $Statuscontato
 *
 * @method \App\Model\Entity\Statuscontato[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class StatuscontatoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $statuscontato = $this->paginate($this->Statuscontato);

        $this->set(compact('statuscontato'));
    }

    /**
     * View method
     *
     * @param string|null $id Statuscontato id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $statuscontato = $this->Statuscontato->get($id, [
            'contain' => []
        ]);

        $this->set('statuscontato', $statuscontato);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $statuscontato = $this->Statuscontato->newEntity();
        if ($this->request->is('post')) {
            $statuscontato = $this->Statuscontato->patchEntity($statuscontato, $this->request->getData());
            if ($this->Statuscontato->save($statuscontato)) {
                $this->Flash->success(__('The statuscontato has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The statuscontato could not be saved. Please, try again.'));
        }
        $this->set(compact('statuscontato'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Statuscontato id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $statuscontato = $this->Statuscontato->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $statuscontato = $this->Statuscontato->patchEntity($statuscontato, $this->request->getData());
            if ($this->Statuscontato->save($statuscontato)) {
                $this->Flash->success(__('The statuscontato has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The statuscontato could not be saved. Please, try again.'));
        }
        $this->set(compact('statuscontato'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Statuscontato id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $statuscontato = $this->Statuscontato->get($id);
        if ($this->Statuscontato->delete($statuscontato)) {
            $this->Flash->success(__('The statuscontato has been deleted.'));
        } else {
            $this->Flash->error(__('The statuscontato could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
