<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Tipocliente Controller
 *
 * @property \App\Model\Table\TipoclienteTable $Tipocliente
 *
 * @method \App\Model\Entity\Tipocliente[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TipoclienteController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $tipocliente = $this->paginate($this->Tipocliente);

        $this->set(compact('tipocliente'));
    }

    /**
     * View method
     *
     * @param string|null $id Tipocliente id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tipocliente = $this->Tipocliente->get($id, [
            'contain' => []
        ]);

        $this->set('tipocliente', $tipocliente);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tipocliente = $this->Tipocliente->newEntity();
        if ($this->request->is('post')) {
            $tipocliente = $this->Tipocliente->patchEntity($tipocliente, $this->request->getData());
            if ($this->Tipocliente->save($tipocliente)) {
                $this->Flash->success(__('The tipocliente has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipocliente could not be saved. Please, try again.'));
        }
        $this->set(compact('tipocliente'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Tipocliente id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tipocliente = $this->Tipocliente->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tipocliente = $this->Tipocliente->patchEntity($tipocliente, $this->request->getData());
            if ($this->Tipocliente->save($tipocliente)) {
                $this->Flash->success(__('The tipocliente has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipocliente could not be saved. Please, try again.'));
        }
        $this->set(compact('tipocliente'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Tipocliente id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tipocliente = $this->Tipocliente->get($id);
        if ($this->Tipocliente->delete($tipocliente)) {
            $this->Flash->success(__('The tipocliente has been deleted.'));
        } else {
            $this->Flash->error(__('The tipocliente could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
