<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Tipocontratacao Controller
 *
 * @property \App\Model\Table\TipocontratacaoTable $Tipocontratacao
 *
 * @method \App\Model\Entity\Tipocontratacao[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TipocontratacaoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $tipocontratacao = $this->paginate($this->Tipocontratacao);

        $this->set(compact('tipocontratacao'));
    }

    /**
     * View method
     *
     * @param string|null $id Tipocontratacao id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tipocontratacao = $this->Tipocontratacao->get($id, [
            'contain' => []
        ]);

        $this->set('tipocontratacao', $tipocontratacao);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tipocontratacao = $this->Tipocontratacao->newEntity();
        if ($this->request->is('post')) {
            $tipocontratacao = $this->Tipocontratacao->patchEntity($tipocontratacao, $this->request->getData());
			$tipocontratacao->pessoaidcadastro = $this->pessoaid();
			$tipocontratacao->empresaid        = $this->empresaid();
            if ($this->Tipocontratacao->save($tipocontratacao)) {
                $this->Flash->success(__('The tipocontratacao has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipocontratacao could not be saved. Please, try again.'));
        }
        $this->set(compact('tipocontratacao'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Tipocontratacao id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tipocontratacao = $this->Tipocontratacao->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tipocontratacao = $this->Tipocontratacao->patchEntity($tipocontratacao, $this->request->getData());
            if ($this->Tipocontratacao->save($tipocontratacao)) {
                $this->Flash->success(__('The tipocontratacao has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipocontratacao could not be saved. Please, try again.'));
        }
        $this->set(compact('tipocontratacao'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Tipocontratacao id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tipocontratacao = $this->Tipocontratacao->get($id);
        if ($this->Tipocontratacao->delete($tipocontratacao)) {
            $this->Flash->success(__('The tipocontratacao has been deleted.'));
        } else {
            $this->Flash->error(__('The tipocontratacao could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
