<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Tipoendereco Controller
 *
 * @property \App\Model\Table\TipoenderecoTable $Tipoendereco
 *
 * @method \App\Model\Entity\Tipoendereco[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TipoenderecoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $tipoendereco = $this->paginate($this->Tipoendereco);

        $this->set(compact('tipoendereco'));
    }

    /**
     * View method
     *
     * @param string|null $id Tipoendereco id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tipoendereco = $this->Tipoendereco->get($id, [
            'contain' => []
        ]);

        $this->set('tipoendereco', $tipoendereco);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tipoendereco = $this->Tipoendereco->newEntity();
        if ($this->request->is('post')) {
            $tipoendereco = $this->Tipoendereco->patchEntity($tipoendereco, $this->request->getData());
            if ($this->Tipoendereco->save($tipoendereco)) {
                $this->Flash->success(__('The tipoendereco has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipoendereco could not be saved. Please, try again.'));
        }
        $this->set(compact('tipoendereco'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Tipoendereco id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tipoendereco = $this->Tipoendereco->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tipoendereco = $this->Tipoendereco->patchEntity($tipoendereco, $this->request->getData());
            if ($this->Tipoendereco->save($tipoendereco)) {
                $this->Flash->success(__('The tipoendereco has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipoendereco could not be saved. Please, try again.'));
        }
        $this->set(compact('tipoendereco'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Tipoendereco id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tipoendereco = $this->Tipoendereco->get($id);
        if ($this->Tipoendereco->delete($tipoendereco)) {
            $this->Flash->success(__('The tipoendereco has been deleted.'));
        } else {
            $this->Flash->error(__('The tipoendereco could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
