<?php
namespace App\Controller\Cfg;

use App\Controller\AppController;

/**
 * Tipotelefone Controller
 *
 * @property \App\Model\Table\TipotelefoneTable $Tipotelefone
 *
 * @method \App\Model\Entity\Tipotelefone[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TipotelefoneController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $tipotelefone = $this->paginate($this->Tipotelefone);

        $this->set(compact('tipotelefone'));
    }

    /**
     * View method
     *
     * @param string|null $id Tipotelefone id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tipotelefone = $this->Tipotelefone->get($id, [
            'contain' => []
        ]);

        $this->set('tipotelefone', $tipotelefone);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tipotelefone = $this->Tipotelefone->newEntity();
        if ($this->request->is('post')) {
            $tipotelefone = $this->Tipotelefone->patchEntity($tipotelefone, $this->request->getData());
            if ($this->Tipotelefone->save($tipotelefone)) {
                $this->Flash->success(__('The tipotelefone has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipotelefone could not be saved. Please, try again.'));
        }
        $this->set(compact('tipotelefone'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Tipotelefone id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tipotelefone = $this->Tipotelefone->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tipotelefone = $this->Tipotelefone->patchEntity($tipotelefone, $this->request->getData());
            if ($this->Tipotelefone->save($tipotelefone)) {
                $this->Flash->success(__('The tipotelefone has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The tipotelefone could not be saved. Please, try again.'));
        }
        $this->set(compact('tipotelefone'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Tipotelefone id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tipotelefone = $this->Tipotelefone->get($id);
        if ($this->Tipotelefone->delete($tipotelefone)) {
            $this->Flash->success(__('The tipotelefone has been deleted.'));
        } else {
            $this->Flash->error(__('The tipotelefone could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
