<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Bloqueiousuariofilial Controller
 *
 * @property \App\Model\Table\BloqueiousuariofilialTable $Bloqueiousuariofilial
 *
 * @method \App\Model\Entity\Bloqueiousuariofilial[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class BloqueiousuariofilialController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $bloqueiousuariofilial = $this->paginate($this->Bloqueiousuariofilial);

        $this->set(compact('bloqueiousuariofilial'));
    }

    /**
     * View method
     *
     * @param string|null $id Bloqueiousuariofilial id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $bloqueiousuariofilial = $this->Bloqueiousuariofilial->get($id, [
            'contain' => []
        ]);

        $this->set('bloqueiousuariofilial', $bloqueiousuariofilial);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null)
    {
        $bloqueiousuariofilial = $this->Bloqueiousuariofilial->newEntity();
		
        if ($this->request->is('post')) {
			
            $bloqueiousuariofilial = $this->Bloqueiousuariofilial->patchEntity($bloqueiousuariofilial, $this->request->getData());
			
            if ($this->Bloqueiousuariofilial->save($bloqueiousuariofilial)) {
                $this->Flash->success(__('bloqueiousuariofilial foi salvo com sucesso.'));

                return $this->redirect($this->referer());
            }
            $this->Flash->error(__('bloqueiousuariofilial não pode ser salvo. Favor, tentar novamente.'));
        }
		
		$usuario = $this->get('usuario','idusuario',$id);
		$empresa = $this->get('empresa','idempresa',$usuario->idempresa);
			
        $this->set(compact('bloqueiousuariofilial'));
		$this->set([
			'usuario'=>$usuario
			,'empresa'=>$empresa
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Bloqueiousuariofilial id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $bloqueiousuariofilial = $this->Bloqueiousuariofilial->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $bloqueiousuariofilial = $this->Bloqueiousuariofilial->patchEntity($bloqueiousuariofilial, $this->request->getData());
            if ($this->Bloqueiousuariofilial->save($bloqueiousuariofilial)) {
                $this->Flash->success(__('bloqueiousuariofilial salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('bloqueiousuariofilial não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('bloqueiousuariofilial'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Bloqueiousuariofilial id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $bloqueiousuariofilial = $this->Bloqueiousuariofilial->get($id);
        if ($this->Bloqueiousuariofilial->delete($bloqueiousuariofilial)) {
            $this->Flash->success(__('bloqueiousuariofilial deletado com sucesso.'));
        } else {
            $this->Flash->error(__('bloqueiousuariofilial não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect($this->referer());
    }
}
