<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;
use \stdClass;
use Cake\ORM\TableRegistry;

/**
 * Chamado Controller
 *
 * @property \App\Model\Table\ChamadoTable $Chamado
 *
 * @method \App\Model\Entity\Chamado[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ChamadoController extends AppController
{

	public function getUploadDir($id=null){
		$uploaddir = "../../arquivos/flygestor/$id/";
		if($this->isLocalhost()){
				$uploaddir = "..\\..\\arquivos\\flygestor\\$id\\";
		}
		if (!file_exists($uploaddir)) {
			mkdir($uploaddir, 0755, true);
		}
		return $uploaddir;
	}

	public function extensoesPermitidas(){
		return ['jpg','jpeg','png','gif','JPG','JPEG','PNG','GIF'];
	}

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $chamado = $this->getAllTableWhereLimit('chamado',[],['data_criacao'=>'desc'],1000);
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
		$projetos = $this->getAllTableWhere('projeto',[],['nome'=>'asc']);


		$idusuario_atendimento = "-1";
		if(isset($_POST['idusuario_atendimento'])){
			$idusuario_atendimento = $_POST['idusuario_atendimento'];
		}else{
			$session = $this->request->session();
			$idusuario_atendimento = $session->read('login.usuario')->idusuario;
		}

		$idempresa = "-1";
		if(isset($_POST['idempresa'])){
			$idempresa = $_POST['idempresa'];
		}

		$tipoprojeto = "";
		$idprojeto = '-1';
		if(isset($_POST['idprojeto']) && $_POST['idprojeto'] != '-1') {
			$idprojeto ="c.idprojeto =".$_POST['idprojeto'];
		} else{
			if(isset($_POST['tipoprojeto'])){
				$tipoprojeto = $_POST['tipoprojeto'];
				if ($tipoprojeto == 'SLA') {
					$idprojeto ="c.idprojeto IS NULL";
				} else if ($tipoprojeto == 'SLR'){
					$idprojeto ="c.idprojeto IS NOT NULL";
				} else{
					$idprojeto = "-1 = -1";
				}

			}
		}

		$situacaoprojeto = "3 - Aprovado";
		if(isset($_POST['situacaoprojeto'])){
			$situacaoprojeto = $_POST['situacaoprojeto'];
		}


		//$this->d($idprojeto);

		// //Chamados pendentes
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 1
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
			order by c.prioridade desc,c.data_criacao asc limit 20";

		$pendentes = $this->query($sql);
		 //$this->d($pendentes);



		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 1
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalpendentes = $this->query($sql)[0]->total;

		//Chamados planejados
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 2
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
		order by c.prioridade desc,c.data_criacao asc limit 20";
		$planejados = $this->query($sql);

		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 2
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalplanejados = $this->query($sql)[0]->total;

		//chamados em atendimento
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 3
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
		order by c.prioridade desc,c.data_criacao asc limit 20";
		$ematendimento = $this->query($sql);

		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 3
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalematendimento = $this->query($sql)[0]->total;

		//chamados em homologação
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 4
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
		order by c.prioridade desc,c.data_criacao asc limit 20";
		$homologacao = $this->query($sql);

		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 4
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalhomologacao = $this->query($sql)[0]->total;

		//chamados entregues
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 5
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
		order by c.prioridade desc,c.data_criacao asc limit 20";
		$entregues = $this->query($sql);

		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 5
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalentregues = $this->query($sql)[0]->total;

		//chamados suspensos
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 6
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
		order by c.prioridade desc,c.data_criacao asc limit 20";
		$suspensos = $this->query($sql);

		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 6
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalsuspensos = $this->query($sql)[0]->total;

		//chamados cancelados
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 7
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
		order by c.prioridade desc,c.data_criacao asc limit 20";
		$cancelados = $this->query($sql);

		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 7
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalcancelados = $this->query($sql)[0]->total;

		//chamados finalizados
		$sql = "select c.*
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 8
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
		order by c.prioridade desc,c.data_criacao asc limit 20";
		$finalizados = $this->query($sql);

		$sql = "select count(1) as total
		from chamado c
		left join projeto p on p.idprojeto = c.idprojeto
		where
			c.idchamadostatus = 8
			and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
			and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
			and ($idprojeto)
			and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
		$totalfinalizados = $this->query($sql)[0]->total;

		//$chamado = $this->paginate($this->Chamado,['order'=>['idchamado'=>'desc']]);

		if ($this->request->is('post') && isset($_POST['observacao'])) {
            $session = $this->request->getSession();

			$chamadoobsTable = TableRegistry::get('chamadoobs');
			$chamadoobs = $chamadoobsTable->newEntity();

			$chamadoobs->idchamado = $_POST['chamadoidmodal'];
			$chamadoobs->idusuario = $session->read('login.usuario')->idusuario;
			$chamadoobs->observacao = $_POST['observacao'];
			$chamadoobs->horastrabalhadas = $_POST['horastrabalhadas'];

			$arquivo = null;
			if(strlen($_FILES['arquivo']['name']) > 0){
				$extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
				$temp = explode(".", $_FILES["arquivo"]["name"]);
				$arquivo = $_FILES['arquivo']['name'];
				move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($_POST['chamadoidmodal']) . $arquivo);
			}

			$chamadoobs->arquivo = $arquivo;

            if ($chamadoobsTable->save($chamadoobs)) {
                $this->Flash->success(__('observação foi salva com sucesso.'));

                //return $this->redirect(['action' => 'view',$id]);
            } else{
            $this->Flash->error(__('observação não pode ser salva. Favor, tentar novamente.'));
        	}
        }

        $this->set(compact('chamado'));
		$this->set([
			'pendentes'=>$pendentes
			,'totalpendentes'=>$totalpendentes
			,'planejados'=>$planejados
			,'totalplanejados'=>$totalplanejados
			,'ematendimento'=>$ematendimento
			,'totalematendimento'=>$totalematendimento
			,'homologacao'=>$homologacao
			,'totalhomologacao'=>$totalhomologacao
			,'entregues'=>$entregues
			,'totalentregues'=>$totalentregues
			,'suspensos'=>$suspensos
			,'totalsuspensos'=>$totalsuspensos
			,'cancelados'=>$cancelados
			,'totalcancelados'=>$totalcancelados
			,'finalizados'=>$finalizados
			,'totalfinalizados'=>$totalfinalizados
			,'idusuario_atendimento'=>$idusuario_atendimento
			,'idempresa'=>$idempresa
			,'idprojeto'=>$idprojeto
			,'situacaoprojeto'=>$situacaoprojeto
			,'tipoprojeto'=>$tipoprojeto
			,'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
		]);
    }

    /**
     * View method
     *
     * @param string|null $id Chamado id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {

        $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $sql = "SELECT coalesce(sum(horastrabalhadas),0) as totalhoras
				from chamadoobs
				WHERE idchamado = $id";

		$totalhoras = $this->query($sql)[0]->totalhoras;

		if ($this->request->is('post')) {
            $session = $this->request->getSession();

			$chamadoobsTable = TableRegistry::get('chamadoobs');
			$chamadoobs = $chamadoobsTable->newEntity();

			$chamadoobs->idchamado = $id;
			$chamadoobs->idusuario = $session->read('login.usuario')->idusuario;
			$chamadoobs->observacao = $_POST['observacao'];
			$chamadoobs->horastrabalhadas = $_POST['horastrabalhadas'];

			$arquivo = null;
			if(strlen($_FILES['arquivo']['name']) > 0){
				$extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
				$temp = explode(".", $_FILES["arquivo"]["name"]);
				$arquivo = $_FILES['arquivo']['name'];
				move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($id) . $arquivo);
			}

			$chamadoobs->arquivo = $arquivo;

            if ($chamadoobsTable->save($chamadoobs)) {
                $this->Flash->success(__('observação foi salva com sucesso.'));

                return $this->redirect(['action' => 'view',$id]);
            }
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
        }
		$chamadoobs = $this->getAllTableWhere('chamadoobs',['idchamado'=>$id],['data_criacao'=>'desc']);

		$sql = "Select * from chamado where idchamadopai = $id";
		$chamadosfilhos = $this->query($sql);

        $this->set([
			'chamado'=>$chamado
			,'chamadoobs'=>$chamadoobs
			,'totalhoras'=>$totalhoras
			,'chamadosfilhos'=>$chamadosfilhos
		]);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {

    	$session = $this->request->session();
        $idperfil = $session->read('login.usuario')->idperfil;



		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
		$projetos = $this->getAllTableWhere('projeto',['1'=>1],['nome'=>'asc']);
		$produtos = $this->getAllTableWhere('produto',[],['grupo'=>'asc','subgrupo'=>'asc','nome'=>'asc']);
		$chamadostatus = $this->getAllTableWhere('chamadostatus',[],[]);
		$chamadolog = $this->getAllTableWhere('chamadolog',[],[]);

		$idusuario_atendimento = "-1";
		if(isset($_POST['idusuario_atendimento'])){
			$idusuario_atendimento = $_POST['idusuario_atendimento'];
		}else{
			$session = $this->request->session();
			$idusuario_atendimento = $session->read('login.usuario')->idusuario;
		}

        $chamado = $this->Chamado->newEntity();
        if ($this->request->is('post')) {
            $chamado = $this->Chamado->patchEntity($chamado, $this->request->getData());
			$session = $this->request->getSession();
			$chamado->idusuario_criacao = $session->read('login.usuario')->idusuario;

			if($this->validaData($_POST['data_prevista'])){
				$chamado->data_prevista = $this->formatDataToDatabase($_POST['data_prevista']);
			}else{
				$chamado->data_prevista = null;
			}



            if ($this->Chamado->save($chamado)) {

            	//Cria log de chamado aberto
	             $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

                $this->Flash->success(__('chamado foi salvo com sucesso.'));

                if( $idperfil == 17){
                	return $this->redirect(['action' => 'suporteavancado']);
                } else {
                return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('chamado não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamado'));
       // $this->d($projetos->toArray());
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
			,'produtos'=>$produtos
			,'idusuario_atendimento'=>$idusuario_atendimento
			,'chamadostatus'=>$chamadostatus
			,'chamadolog'=>$chamadolog
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Chamado id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
		$projetos = $this->getAllTableWhere('projeto',[],['nome'=>'asc']);
		$produtos = $this->getAllTableWhere('produto',[],['grupo'=>'asc','subgrupo'=>'asc','nome'=>'asc']);
		$chamadostatus = $this->getAllTableWhere('chamadostatus',[],[]);
		$chamadolog = $this->getAllTableWhere('chamadolog',[],[]);
		$releases = $this->getAllTableWhere('releases',[],['numero'=>'asc']);

        $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $prioridade1 = $chamado->prioridade;
        $horasprevistas1 = $chamado->horasprevistas;
        $idchamadostatus1= $chamado->idchamadostatus;

        //$this->d($prioridade1);


        if ($this->request->is(['patch', 'post', 'put'])) {
	        $chamado = $this->Chamado->patchEntity($chamado, $this->request->getData());

	        $sql = "select descricao from chamadostatus where idchamadostatus = $chamado->idchamadostatus";
	        $query = $this->query($sql);
	        $nomestatus = $query[0]->descricao;

			//$this->d($nomestatus);

        	//Altera todos
        	if($idchamadostatus1 != $_POST['idchamadostatus'] || $prioridade1 != $_POST['prioridade'] || $horasprevistas1 != $_POST['horasprevistas']){
	            $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'observacao'=>"<spam>Prioridadde: <i>$chamado->prioridade</i>
	                                      Horas Previstas: <i>$chamado->horasprevistas</i>
	                                      Status: <i>$chamado->idchamadostatus - $nomestatus</i></spam>"
					]);
            }

            //Altera status
        	if($idchamadostatus1 != $_POST['idchamadostatus']){
	            $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);
            }

             //data fechamento
        	if($_POST['idchamadostatus'] == 5 || $_POST['idchamadostatus'] == 8){
	            $chamado->data_fechamento = date('Y-m-d H:i:s');
            }

            if ($this->Chamado->save($chamado)) {
                $this->Flash->success(__('chamado salvo com sucesso.'));

                return $this->redirect(['action' => 'view',$id]);
            }
            $this->Flash->error(__('chamado não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamado'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
			,'produtos'=>$produtos
			,'chamadostatus'=>$chamadostatus
			,'chamadolog'=>$chamadolog
			,'releases'=>$releases
		]);
    }

    /**
     * Delete method
     *
     * @param string|null $id Chamado id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $chamado = $this->Chamado->get($id);
        if ($this->Chamado->delete($chamado)) {
            $this->Flash->success(__('chamado deletado com sucesso.'));
        } else {
            $this->Flash->error(__('chamado não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

     public function ematendimento($id = null){
        $this->update('chamado',[
            'status'=>'3 - Em atendimento'
            ,'idchamadostatus'=>3
        ],[
            'idchamado'=>$id
        ]);

        $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"<spam>Status: <i>$chamado->status</i></spam>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());

    }

     public function cancelar($id = null){
        $this->update('chamado',[
            'status'=>'7 - Cancelado'
            ,'idchamadostatus'=>7
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"<spam>Status: <i>$chamado->status</i></spam>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

     public function pendente($id = null){
        $this->update('chamado',[
            'status'=>'1 - Pendente'
            ,'idchamadostatus'=>1
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"<spam>Status: <i>$chamado->status</i></spam>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());

    }

    public function planejado($id = null){
        $this->update('chamado',[
            'status'=>'2 - Planejado'
            ,'idchamadostatus'=>2
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

    public function homologacao($id = null){
        $this->update('chamado',[
            'status'=>'4 - Homologação'
            ,'idchamadostatus'=>4
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

    public function suspenso($id = null){
        $this->update('chamado',[
            'status'=>'6 - Suspenso'
            ,'idchamadostatus'=>6
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

      public function entregue($id = null){
        $this->update('chamado',[
            'status'=>'5 - Entregue'
            ,'idchamadostatus'=>5
            ,'data_fechamento'=>date('Y-m-d H:i:s')
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());

    }

    public function finalizado($id = null){
        $this->update('chamado',[
            'status'=>'8 - Finalizado'
            ,'idchamadostatus'=>8
            ,'data_fechamento'=>date('Y-m-d H:i:s')
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->Chamado->get($id, [
            'contain' => []
        ]);

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

    public function suporte()
    {
        $chamado = $this->getAllTableWhereLimit('chamado',["idprojeto is null and idchamadostatus <> 8 and idproduto <> 11"],['data_criacao'=>'desc'],500);
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
		$projetos = $this->getAllTableWhere('projeto',[],['nome'=>'asc']);




		if ($this->request->is('post') && isset($_POST['observacao'])) {
            $session = $this->request->getSession();

			$chamadoobsTable = TableRegistry::get('chamadoobs');
			$chamadoobs = $chamadoobsTable->newEntity();

			$chamadoobs->idchamado = $_POST['chamadoidmodal'];
			$chamadoobs->idusuario = $session->read('login.usuario')->idusuario;
			$chamadoobs->observacao = $_POST['observacao'];
			$chamadoobs->horastrabalhadas = $_POST['horastrabalhadas'];

			$arquivo = null;
			if(strlen($_FILES['arquivo']['name']) > 0){
				$extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
				$temp = explode(".", $_FILES["arquivo"]["name"]);
				$arquivo = $_FILES['arquivo']['name'];
				move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($_POST['chamadoidmodal']) . $arquivo);
			}

			$chamadoobs->arquivo = $arquivo;
			$this->ematendimento($_POST['chamadoidmodal']);

            if ($chamadoobsTable->save($chamadoobs)) {
                $this->Flash->success(__('observação foi salva com sucesso.'));

                //return $this->redirect(['action' => 'view',$id]);
            } else{
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
        	}
        }

        $this->set(compact('chamado'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
		]);
		}

		public function suporteavancado()
    {
			$session = $this->request->getSession();
			$idusuario = $session->read('login.usuario')->idusuario;

			$chamado = $this->getAllTableWhereLimit('chamado',["idusuario_atendimento = $idusuario"],['data_criacao'=>'desc'],500);
			$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
            $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
			$projetos = $this->getAllTableWhere('projeto',[],['nome'=>'asc']);




		if ($this->request->is('post') && isset($_POST['observacao'])) {


			$chamadoobsTable = TableRegistry::get('chamadoobs');
			$chamadoobs = $chamadoobsTable->newEntity();

			$chamadoobs->idchamado = $_POST['chamadoidmodal'];
			$chamadoobs->idusuario = $idusuario;
			$chamadoobs->observacao = $_POST['observacao'];
			$chamadoobs->horastrabalhadas = $_POST['horastrabalhadas'];

			$arquivo = null;
			if(strlen($_FILES['arquivo']['name']) > 0){
				$extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
				$temp = explode(".", $_FILES["arquivo"]["name"]);
				$arquivo = $_FILES['arquivo']['name'];
				move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($_POST['chamadoidmodal']) . $arquivo);
			}

			$chamadoobs->arquivo = $arquivo;
			$this->ematendimento($_POST['chamadoidmodal']);

            if ($chamadoobsTable->save($chamadoobs)) {
                $this->Flash->success(__('observação foi salva com sucesso.'));

                //return $this->redirect(['action' => 'view',$id]);
            } else{
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
        	}
        }

        $this->set(compact('chamado'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
		]);
    }

    public function intercorrencia()
    {

    	$session = $this->request->session();
        $idperfil = $session->read('login.usuario')->idperfil;



		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
		$projetos = $this->getAllTableWhere('projeto',[],['nome'=>'asc']);
		$produtos = $this->getAllTableWhere('produto',[],['grupo'=>'asc','subgrupo'=>'asc','nome'=>'asc']);

		$idusuario_atendimento = "-1";
		if(isset($_POST['idusuario_atendimento'])){
			$idusuario_atendimento = $_POST['idusuario_atendimento'];
		}else{
			$session = $this->request->session();
			$idusuario_atendimento = $session->read('login.usuario')->idusuario;
		}

        $chamado = $this->Chamado->newEntity();

        $chamadoobsTable = TableRegistry::get('chamadoobs');
		$chamadoobs = $chamadoobsTable->newEntity();

        if ($this->request->is('post')) {

            $chamado = $this->Chamado->patchEntity($chamado, $this->request->getData());
			$session = $this->request->getSession();
			$chamado->idusuario_criacao = $session->read('login.usuario')->idusuario;
			$chamado->idempresa = 1;
			$chamado->tipo = '8 - Intercorrência';
			$chamado->status = '8 - Finalizado';
			$chamado->idchamadostatus = 8;
			$chamado->assunto = 'Intercorrência';

			if($this->validaData($_POST['data_prevista'])){
				$chamado->data_prevista = $this->formatDataToDatabase($_POST['data_prevista']);
			}else{
				$chamado->data_prevista = null;
			}

			//$this->d($_POST['data_prevista']);

            if ($this->Chamado->save($chamado)) {

            	$this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'horastrabalhadas'=>$chamado->horasprevistas
						,'observacao'=>"$chamadoobs->horastrabalhadas"
					]);

                $this->Flash->success(__('chamado foi salvo com sucesso.'));

                if( $idperfil == 16){
                	return $this->redirect(['action' => 'suporte']);
                } elseif( $idperfil == 17){
                	return $this->redirect(['action' => 'suporteavancado']);
                } else {
                return $this->redirect(['action' => 'index']);
                }
            }
            $this->Flash->error(__('chamado não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamado'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
			,'produtos'=>$produtos
			,'idusuario_atendimento'=>$idusuario_atendimento
		]);
    }

    public function addsuporte()
    {

    	$session = $this->request->session();
        $idperfil = $session->read('login.usuario')->idperfil;

		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
		$projetos = $this->getAllTableWhere('projeto',[],['nome'=>'asc']);
		$produtos = $this->getAllTableWhere('produto',[],['grupo'=>'asc','subgrupo'=>'asc','nome'=>'asc']);

		$idusuario_atendimento = "-1";
		if(isset($_POST['idusuario_atendimento'])){
			$idusuario_atendimento = $_POST['idusuario_atendimento'];
		}else{
			$session = $this->request->session();
			$idusuario_atendimento = $session->read('login.usuario')->idusuario;
		}

        $chamado = $this->Chamado->newEntity();

        if ($this->request->is('post')) {

            $chamado = $this->Chamado->patchEntity($chamado, $this->request->getData());
			$session = $this->request->getSession();
			$chamado->idusuario_criacao = $session->read('login.usuario')->idusuario;
			$chamado->idempresa = 1;
			$chamado->status = '1 - Pendente';
			$chamado->idchamadostatus = 1;

            if ($this->Chamado->save($chamado)) {


                $this->Flash->success(__('chamado foi salvo com sucesso.'));

                	return $this->redirect(['action' => 'suporte']);
            }
            $this->Flash->error(__('chamado não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamado'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
			,'produtos'=>$produtos
			,'idusuario_atendimento'=>$idusuario_atendimento
		]);
    }

    public function addchamadoprojeto($id = null)
    {

    	$session = $this->request->session();
        $idperfil = $session->read('login.usuario')->idperfil;

        $chamadostatus = $this->getAllTableWhere('chamadostatus',[],[]);
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
		$projetos = $this->get('projeto','idprojeto', $id);
        $empresas = $this->getAllTableWhere('empresa',['idempresa'=>$projetos->idempresa],['nome'=>'asc']);
		$produtos = $this->getAllTableWhere('produto',[],['grupo'=>'asc','subgrupo'=>'asc','nome'=>'asc']);

		$idusuario_atendimento = "-1";
		if(isset($_POST['idusuario_atendimento'])){
			$idusuario_atendimento = $_POST['idusuario_atendimento'];
		}else{
			$session = $this->request->session();
			$idusuario_atendimento = $session->read('login.usuario')->idusuario;
		}

        $chamado = $this->Chamado->newEntity();


        if ($this->request->is('post')) {

            $chamado = $this->Chamado->patchEntity($chamado, $this->request->getData());
			$session = $this->request->getSession();
			$chamado->idusuario_criacao = $session->read('login.usuario')->idusuario;

			if($this->validaData($_POST['data_prevista'])){
				$chamado->data_prevista = $this->formatDataToDatabase($_POST['data_prevista']);
			}else{
				$chamado->data_prevista = null;
			}

            if ($this->Chamado->save($chamado)) {


                $this->Flash->success(__('chamado foi salvo com sucesso.'));

                	return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('chamado não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamado'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
			,'projetos'=>$projetos
			,'produtos'=>$produtos
			,'chamadostatus'=>$chamadostatus
			,'idusuario_atendimento'=>$idusuario_atendimento
		]);
    }

    public function addchamadofilho($id = null)
    {

    	$session = $this->request->session();
        $idperfil = $session->read('login.usuario')->idperfil;
        $chamadostatus = $this->getAllTableWhere('chamadostatus',[],[]);
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
		$chamadopai = $this->get('chamado','idchamado', $id);

		//$this->d($chamadopai->idproduto);

		$idusuario_atendimento = "-1";
		if(isset($_POST['idusuario_atendimento'])){
			$idusuario_atendimento = $_POST['idusuario_atendimento'];
		}else{
			$session = $this->request->session();
			$idusuario_atendimento = $session->read('login.usuario')->idusuario;
		}

        $chamado = $this->Chamado->newEntity();


        if ($this->request->is('post')) {

            $chamado = $this->Chamado->patchEntity($chamado, $this->request->getData());
			$session = $this->request->getSession();
			$chamado->idusuario_criacao = $session->read('login.usuario')->idusuario;
			$chamado->idempresa = $chamadopai->idempresa;
			$chamado->solicitante = $chamadopai->solicitante;
			$chamado->idusuario_atendimento = $chamadopai->idusuario_atendimento;
			$chamado->idchamadopai = $chamadopai->idchamado;
			$chamado->idprojeto = $chamadopai->idprojeto;
			$chamado->idproduto = $chamadopai->idproduto;

			if($this->validaData($_POST['data_prevista'])){
				$chamado->data_prevista = $this->formatDataToDatabase($_POST['data_prevista']);
			}else{
				$chamado->data_prevista = null;
			}

            if ($this->Chamado->save($chamado)) {


                $this->Flash->success(__('chamado foi salvo com sucesso.'));

                	return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('chamado não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamado'));
		$this->set([
			'usuarios'=>$usuarios
			,'chamadopai'=>$chamadopai
			,'chamadostatus'=>$chamadostatus
			,'idusuario_atendimento'=>$idusuario_atendimento
		]);
    }





}
