<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Chamadoobs Controller
 *
 * @property \App\Model\Table\ChamadoobsTable $Chamadoobs
 *
 * @method \App\Model\Entity\Chamadoob[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ChamadoobsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $chamadoobs = $this->paginate($this->Chamadoobs);

        $this->set(compact('chamadoobs'));
    }

    /**
     * View method
     *
     * @param string|null $id Chamadoob id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $chamadoob = $this->Chamadoobs->get($id, [
            'contain' => []
        ]);

        $this->set('chamadoob', $chamadoob);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $chamadoob = $this->Chamadoobs->newEntity();
        if ($this->request->is('post')) {
            $chamadoob = $this->Chamadoobs->patchEntity($chamadoob, $this->request->getData());
            if ($this->Chamadoobs->save($chamadoob)) {
                $this->Flash->success(__('chamadoob foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamadoob'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Chamadoob id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $chamadoob = $this->Chamadoobs->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $chamadoob = $this->Chamadoobs->patchEntity($chamadoob, $this->request->getData());
            if ($this->Chamadoobs->save($chamadoob)) {
                $this->Flash->success(__('salvo com sucesso.'));

                return $this->redirect(['controller'=>'chamado','action' => 'view',$chamadoob->idchamado]);
            }
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('chamadoob'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Chamadoob id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $chamadoob = $this->Chamadoobs->get($id);
        if ($this->Chamadoobs->delete($chamadoob)) {
            $this->Flash->success(__('deletado com sucesso.'));
        } else {
            $this->Flash->error(__('chamadoob não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['controller'=>'chamado','action' => 'view',$chamadoob->idchamado]);
    }
}
