<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;
use stdClass;
use Cake\ORM\TableRegistry;
/**
 * Empresa Controller
 *
 * @property \App\Model\Table\EmpresaTable $Empresa
 *
 * @method \App\Model\Entity\Empresa[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class EmpresaController extends AppController
{
	public function script($id = null){

		$sql = "";
		$result = [];

		$empresa = $this->get('empresa','idempresa',$id);

		if ($this->request->is(['patch', 'post', 'put'])) {
			$sql = $_POST['sql'];

			$key 	= $empresa->conexao_key;
			$ip 	= $empresa->conexao_ip;
			$porta 	= $empresa->conexao_porta;
			$erp 	= $empresa->erp;
			$pathfileservice = $empresa->conexao_path;

			$encripted_sql = $this->cryptdata($sql,'e');
			$encripted_key = $this->cryptdata($key,'e');
			$data          = ["key"=>$encripted_key, "sql"=>$encripted_sql];
			$url           = "http://$ip:$porta/$pathfileservice";

			$json = $this->httpPost($url,$data);
			if(!$this->isJson($json)){
				$obj = new stdClass;
				$obj->erro = $json;
				$json = json_encode([$obj]);
			}


			$result = json_decode($json);
			if($_POST['formato'] == "csv" && count($result)>0){
				$output = fopen("php://output",'w') or die("Can't open php://output");
				header("Content-Type:application/csv");
				header("Content-Disposition:attachment;filename=flygestor.csv");
				$properties = array_keys((array)$result[0]);
				fputcsv($output, $properties);
				foreach($result as $item) {
					fputcsv($output, (array) $item);
				}
				fclose($output) or die("Can't close php://output");
				$result = [];
				exit();
			}

		}

		$this->set([
			'sql'=>$sql
			,'result'=>$result
			,'empresa'=>$empresa
		]);
	}
    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $empresa = $this->Empresa->find('all')->order(['idempresa'=>'desc']);

        $this->set(compact('empresa'));
    }

    /**
     * View method
     *
     * @param string|null $id Empresa id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $empresa = $this->Empresa->get($id, [
            'contain' => []
        ]);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $session = $this->request->session();
            $idusuario = $session->read('login.usuario')->idusuario;

            $this->insert('empresaobs',[
                'idempresa'=>$id
                ,'idusuario'=>$idusuario
                ,'observacao'=>$_POST['observacao']
            ],[]);
        }

		$empresaobs = $this->getAllTableWhere('empresaobs',['idempresa'=>$id]);
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>$id]);
        $usuariosresponsaveis = $this->getAllTableWhere('usuario',['idempresa'=>$id, 'responsavel'=>'1']);
        //$this->d($usuarios);

        $this->set([
			'empresa'=>$empresa
			,'empresaobs'=>$empresaobs
			,'usuarios'=>$usuarios
            ,'usuariosresponsaveis'=>$usuariosresponsaveis
		]);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $empresa = $this->Empresa->newEntity();
        if ($this->request->is('post')) {
            $empresa = $this->Empresa->patchEntity($empresa, $this->request->getData());
            if ($this->Empresa->save($empresa)) {
                $this->Flash->success(__('The empresa has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The empresa could not be saved. Please, try again.'));
        }

		$erps = $this->getAllTableWhere('erp',['1'=>1],['nome'=>'asc']);

        $this->set(compact('empresa'));
		$this->set([
			'erps'=>$erps
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Empresa id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $empresa = $this->Empresa->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $empresa = $this->Empresa->patchEntity($empresa, $this->request->getData());
            if ($this->Empresa->save($empresa)) {
                $this->Flash->success(__('The empresa has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The empresa could not be saved. Please, try again.'));
        }
        $erps = $this->getAllTableWhere('erp',['1'=>1],['nome'=>'asc']);

        $this->set(compact('empresa'));
		$this->set([
			'erps'=>$erps
		]);
    }

    /**
     * Delete method
     *
     * @param string|null $id Empresa id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $empresa = $this->Empresa->get($id);
        if ($this->Empresa->delete($empresa)) {
            $this->Flash->success(__('The empresa has been deleted.'));
        } else {
            $this->Flash->error(__('The empresa could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function addempresarapido()
    {
        $empresa = $this->Empresa->newEntity();
        $usuario = $this->getAllTableWhere('usuario',[],[]);
        $modulousuario = $this->getAllTableWhere('modulousuario',[],[]);

        $cpf = $this->cpfRandom(0);



        if ($this->request->is('post')) {
            $contexto = $_POST['contexto'];
            $bancoflygestor = $_POST['bancoflygestor'];
            $empresa->razaosocial = $_POST['nome'];
            $empresa->logo = "logos/logo-$contexto.png";
            $empresa->conexao_ip = "191.252.58.196";
            $empresa->conexao_porta = "8080";
            $empresa->conexao_key = "MArie*Loki@2017";
            $empresa->conexao_path = "flygestorservice-$contexto/query.php";
            $empresa->bancoflygestor = "corpstek_flygestor_".$bancoflygestor."_".$contexto;
            $empresa->bancoflygestor_usuario = "corpstek_fly";
            $empresa->bancoflygestor_senha = "flygestor2018#";
            $empresa->bancoflygestor_porta = "3306";
            $empresa->bancoflygestor_host = "localhost";

            $empresa = $this->Empresa->patchEntity($empresa, $this->request->getData());
            if ($this->Empresa->save($empresa)) {

                $this->insert('usuario',[
                        'idempresa'=>$empresa->idempresa
                        ,'nome'=>"admin"
                        ,'cpf'=>$cpf
                        ,'senha'=>$cpf
                        ,'email'=>"admin@$contexto.com.br"
                        ,'idperfil'=>2
                        ,'usuario_criacao'=>$this->usuarioid()
                        ,'ativo'=>1
                        ,'responsavel'=>0
                    ]);

                $usuario = $this->get('Usuario','cpf',$cpf);

                //$this->d($usuario);

                 $this->insert('modulousuario',[
                        'idmodulo'=>1
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>2
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>3
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>5
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>6
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                $this->Flash->success(__('The empresa has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The empresa could not be saved. Please, try again.'));
        }

        $erps = $this->getAllTableWhere('erp',['1'=>1],['nome'=>'asc']);

        $this->set(compact('empresa'));
        $this->set([
            'erps'=>$erps
            ,'usuario'=>$usuario
            ,'modulousuario'=>$modulousuario
            ,'cpf'=>$cpf
        ]);
    }
}
