<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Empresaobs Controller
 *
 * @property \App\Model\Table\EmpresaobsTable $Empresaobs
 *
 * @method \App\Model\Entity\Empresaob[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class EmpresaobsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $empresaobs = $this->paginate($this->Empresaobs);

        $this->set(compact('empresaobs'));
    }

    /**
     * View method
     *
     * @param string|null $id Empresaob id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $empresaob = $this->Empresaobs->get($id, [
            'contain' => []
        ]);

        $this->set('empresaob', $empresaob);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $empresaob = $this->Empresaobs->newEntity();
        if ($this->request->is('post')) {
            $empresaob = $this->Empresaobs->patchEntity($empresaob, $this->request->getData());
            if ($this->Empresaobs->save($empresaob)) {
                $this->Flash->success(__('empresaob foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('empresaob não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('empresaob'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Empresaob id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $empresaob = $this->Empresaobs->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $empresaob = $this->Empresaobs->patchEntity($empresaob, $this->request->getData());
            if ($this->Empresaobs->save($empresaob)) {
                $this->Flash->success(__('empresaob salvo com sucesso.'));

                return $this->redirect(['controller'=>'empresa','action' => 'view',$empresaob->idempresa]);
            }
            $this->Flash->error(__('empresaob não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('empresaob'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Empresaob id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $empresaob = $this->Empresaobs->get($id);
        if ($this->Empresaobs->delete($empresaob)) {
            $this->Flash->success(__('empresaob deletado com sucesso.'));
        } else {
            $this->Flash->error(__('empresaob não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['controller'=>'empresa','action' => 'view',$empresaob->idempresa]);
    }
}
