<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Erp Controller
 *
 * @property \App\Model\Table\ErpTable $Erp
 *
 * @method \App\Model\Entity\Erp[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ErpController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $erp = $this->paginate($this->Erp);

        $this->set(compact('erp'));
    }

    /**
     * View method
     *
     * @param string|null $id Erp id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $erp = $this->Erp->get($id, [
            'contain' => []
        ]);

        $this->set('erp', $erp);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $erp = $this->Erp->newEntity();
        if ($this->request->is('post')) {
            $erp = $this->Erp->patchEntity($erp, $this->request->getData());
            if ($this->Erp->save($erp)) {
                $this->Flash->success(__('erp foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('erp não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('erp'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Erp id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $erp = $this->Erp->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $erp = $this->Erp->patchEntity($erp, $this->request->getData());
            if ($this->Erp->save($erp)) {
                $this->Flash->success(__('erp salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('erp não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('erp'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Erp id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $erp = $this->Erp->get($id);
        if ($this->Erp->delete($erp)) {
            $this->Flash->success(__('erp deletado com sucesso.'));
        } else {
            $this->Flash->error(__('erp não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
