<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;
use \stdClass;
use Cake\ORM\TableRegistry;


class KanbanController extends AppController
{
    public function getUploadDir($id=null){
		$uploaddir = "../../arquivos/flygestor/$id/";
		if($this->isLocalhost()){
				$uploaddir = "..\\..\\arquivos\\flygestor\\$id\\";
		}
		if (!file_exists($uploaddir)) {
			mkdir($uploaddir, 0755, true);
		}
		return $uploaddir;
	}

	public function extensoesPermitidas(){
		return ['jpg','jpeg','png','gif','JPG','JPEG','PNG','GIF'];
    }

    public function index(){

    $session = $this->request->getSession();
    $idusuario = $session->read('login.usuario')->idusuario;
    $chamado = $this->getAllTableWhereLimit('chamado',["idusuario_atendimento = $idusuario"],['data_criacao'=>'desc'],500);
    $usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
    $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
    $projetos = $this->getAllTableWhere('projeto',[],['nome'=>'asc']);

    $idusuario_atendimento = "-1";
    if(isset($_POST['idusuario_atendimento'])){
        $idusuario_atendimento = $_POST['idusuario_atendimento'];
    }else{
        $session = $this->request->session();
        $idusuario_atendimento = $session->read('login.usuario')->idusuario;
    }


    $idempresa = "-1";
    if(isset($_POST['idempresa'])){
        $idempresa = $_POST['idempresa'];
    }

    $tipoprojeto = "";
    $idprojeto = '-1';
    if(isset($_POST['idprojeto']) && $_POST['idprojeto'] != '-1') {
        $idprojeto ="c.idprojeto =".$_POST['idprojeto'];
    } else{
        if(isset($_POST['tipoprojeto'])){
            $tipoprojeto = $_POST['tipoprojeto'];
            if ($tipoprojeto == 'SLA') {
                $idprojeto ="c.idprojeto IS NULL";
            } else if ($tipoprojeto == 'SLR'){
                $idprojeto ="c.idprojeto IS NOT NULL";
            } else{
                $idprojeto = "-1 = -1";
            }

        }
    }

    $situacaoprojeto = "3 - Aprovado";
    if(isset($_POST['situacaoprojeto'])){
        $situacaoprojeto = $_POST['situacaoprojeto'];
    }

    // //Chamados pendentes
    $sql = "select c.*, u.nome, u.foto
    from chamado c
    left join projeto p on p.idprojeto = c.idprojeto
    left join usuario u on u.idusuario = c.idusuario_atendimento
    where
        c.idchamadostatus = 1
        and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
        and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
        and ($idprojeto)
        and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
        order by c.prioridade desc,c.data_criacao asc limit 20";

    $pendentes = $this->query($sql);
    //$this->d($pendentes);

    $sql = "select count(1) as total
    from chamado c
    left join projeto p on p.idprojeto = c.idprojeto
    where
        c.idchamadostatus = 1
        and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
        and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
        and ($idprojeto)
        and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
    $totalpendentes = $this->query($sql)[0]->total;

    //chamados em atendimento
    $sql = "select c.*, u.nome, u.foto
    from chamado c
    left join projeto p on p.idprojeto = c.idprojeto
    left join usuario u on u.idusuario = c.idusuario_atendimento
    where
        c.idchamadostatus = 3
        and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
        and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
        and ($idprojeto)
        and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
    order by c.prioridade desc,c.data_criacao asc limit 20";
    $ematendimento = $this->query($sql);

    $sql = "select count(1) as total
    from chamado c
    left join projeto p on p.idprojeto = c.idprojeto
    where
        c.idchamadostatus = 3
        and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
        and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
        and ($idprojeto)
        and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
    $totalematendimento = $this->query($sql)[0]->total;

    //chamados entregues
    $sql = "select c.*, u.nome, u.foto
    from chamado c
    left join projeto p on p.idprojeto = c.idprojeto
    left join usuario u on u.idusuario = c.idusuario_atendimento
    where
        c.idchamadostatus = 5
        and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
        and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
        and ($idprojeto)
        and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))
    order by c.data_criacao desc limit 20";
    $entregues = $this->query($sql);

    $sql = "select count(1) as total
    from chamado c
    left join projeto p on p.idprojeto = c.idprojeto
    where
        c.idchamadostatus = 5
        and ('-1' = '$idusuario_atendimento' OR c.idusuario_atendimento = $idusuario_atendimento)
        and ('-1' = '$idempresa' OR c.idempresa = $idempresa)
        and ($idprojeto)
        and ('' = '$situacaoprojeto' OR ((p.situacao = '$situacaoprojeto') and (p.idprojeto is not null)) OR (p.idprojeto is null))";
    $totalentregues = $this->query($sql)[0]->total;

    if ($this->request->is('post') && isset($_POST['observacao'])) {
        $session = $this->request->getSession();

        $chamadoobsTable = TableRegistry::get('chamadoobs');
        $chamadoobs = $chamadoobsTable->newEntity();

        $chamadoobs->idchamado = $_POST['chamadoidmodal'];
        $chamadoobs->idusuario = $session->read('login.usuario')->idusuario;
        $chamadoobs->observacao = $_POST['observacao'];
        $chamadoobs->horastrabalhadas = $_POST['horastrabalhadas'];

        $arquivo = null;
        if(strlen($_FILES['arquivo']['name']) > 0){
            $extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
            $temp = explode(".", $_FILES["arquivo"]["name"]);
            $arquivo = $_FILES['arquivo']['name'];
            move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($_POST['chamadoidmodal']) . $arquivo);
        }

        $chamadoobs->arquivo = $arquivo;

        if ($chamadoobsTable->save($chamadoobs)) {
            $this->Flash->success(__('observação foi salva com sucesso.'));

            //return $this->redirect(['action' => 'view',$id]);
        } else{
        $this->Flash->error(__('observação não pode ser salva. Favor, tentar novamente.'));
        }
    }

    $this->set(compact('chamado'
    ,'pendentes'
    ,'totalpendentes'
    ,'ematendimento'
    ,'totalematendimento'
    ,'entregues'
    ,'totalentregues'
    ,'usuarios'
    ,'empresas'
    ,'projetos'
    ,'tipoprojeto'
    ,'idusuario_atendimento'
    ,'situacaoprojeto'
));

    }

    public function ematendimento($id = null){
        $this->update('chamado',[
            'status'=>'3 - Em atendimento'
            ,'idchamadostatus'=>3
        ],[
            'idchamado'=>$id
        ]);

        $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"<spam>Status: <i>$chamado->status</i></spam>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        //$this->redirect($this->referer());
        $this->response->body("ok");
        return $this->response;
        exit();
    }

     public function cancelar($id = null){
        $this->update('chamado',[
            'status'=>'7 - Cancelado'
            ,'idchamadostatus'=>7
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"<spam>Status: <i>$chamado->status</i></spam>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

     public function pendente($id = null){
        $this->update('chamado',[
            'status'=>'1 - Pendente'
            ,'idchamadostatus'=>1
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"<spam>Status: <i>$chamado->status</i></spam>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        //$this->redirect($this->referer());
        $this->response->body("ok");
            return $this->response;
            exit();
    }

    public function planejado($id = null){
        $this->update('chamado',[
            'status'=>'2 - Planejado'
            ,'idchamadostatus'=>2
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

    public function homologacao($id = null){
        $this->update('chamado',[
            'status'=>'4 - Homologação'
            ,'idchamadostatus'=>4
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

    public function suspenso($id = null){
        $this->update('chamado',[
            'status'=>'6 - Suspenso'
            ,'idchamadostatus'=>6
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }

      public function entregue($id = null){
        $this->update('chamado',[
            'status'=>'5 - Entregue'
            ,'idchamadostatus'=>5
            ,'data_fechamento'=>date('Y-m-d H:i:s')
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        //$this->redirect($this->referer());
        $this->response->body("ok");
            return $this->response;
            exit();
    }

    public function finalizado($id = null){
        $this->update('chamado',[
            'status'=>'8 - Finalizado'
            ,'idchamadostatus'=>8
            ,'data_fechamento'=>date('Y-m-d H:i:s')
        ],[
            'idchamado'=>$id
        ]);

         $chamado = $this->query("SELECT * FROM chamado WHERE idchamado = $id")[0];

        $this->insert('chamadoobs',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'log'=>1
						,'idchamadostatus'=>$chamado->idchamadostatus
						,'observacao'=>"Status: <i>$chamado->status</i>"
					]);

        $this->insert('chamadolog',[
						'idchamado'=>$chamado->idchamado
						,'idusuario'=>$this->usuarioid()
						,'idchamadostatus'=>$chamado->idchamadostatus
					]);

        $this->redirect($this->referer());
    }
}
