<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;
use \stdClass;
use Cake\ORM\TableRegistry;


class KanbanprojetoController  extends AppController
{
    public function getUploadDir($id=null){
		$uploaddir = "../../arquivos/flygestor/$id/";
		if($this->isLocalhost()){
				$uploaddir = "..\\..\\arquivos\\flygestor\\$id\\";
		}
		if (!file_exists($uploaddir)) {
			mkdir($uploaddir, 0755, true);
		}
		return $uploaddir;
	}

	public function extensoesPermitidas(){
		return ['jpg','jpeg','png','gif','JPG','JPEG','PNG','GIF'];
    }

    public function index(){

        $session = $this->request->session();
        $idusuariolider = $session->read('login.usuario')->idusuario;

        $projeto = $this->getAllTableWhereLimit('projeto',["idusuariolider = $idusuariolider"],['data_criacao'=>'desc'],500);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
        $usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);

        $idusuariolider = "-1";
        if(isset($_POST['idusuariolider'])){
            $idusuariolider = $_POST['idusuariolider'];
        }else{
            $session = $this->request->session();
            $idusuariolider = $session->read('login.usuario')->idusuario;
        }


        $idempresa = "-1";
        if(isset($_POST['idempresa'])){
            $idempresa = $_POST['idempresa'];
        }

         //Projetos em orçamentação
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '1 - Orçamentação'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $orcamentacao = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '1 - Orçamentação'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalorcamentacao = $this->query($sql)[0]->total;

         //Projetos pendentes
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '2 - Pendente'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $pendentes = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '2 - Pendente'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalpendentes = $this->query($sql)[0]->total;

        //Projetos em iniciação
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '3 - Iniciação'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $iniciacao = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '3 - Iniciação'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totaliniciacao = $this->query($sql)[0]->total;

         //Projetos em Planejamento
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '4 - Planejamento'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $planejamento = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '4 - Planejamento'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalplanejamento = $this->query($sql)[0]->total;

        //Projetos em execução
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '5 - Execução'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $execucao = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '5 - Execução'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalexecucao = $this->query($sql)[0]->total;

         //Projetos em Monitoramento
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '6 - Monitoramento e Controle'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $monitoramento = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '6 - Monitoramento e Controle'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalmonitoramento = $this->query($sql)[0]->total;

        //Projetos Encerramento
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '7 - Encerramento'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $encerramento = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '7 - Encerramento'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalencerramento = $this->query($sql)[0]->total;

        //Projetos Pausados
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '8 - Pausado'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $pausados = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '8 - Pausado'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalpausados = $this->query($sql)[0]->total;


        $projeto = $this->getAllTableWhereLimit('projeto',[],['data_criacao'=>'desc'],500);

        if ($this->request->is('post') && isset($_POST['observacao'])) {
            $session = $this->request->getSession();

            $projetoobsTable = TableRegistry::get('projetoobs');
            $projetoobs = $projetoobsTable->newEntity();

            $projetoobs->idprojeto = $_POST['projetoidmodal'];
            $projetoobs->idusuario = $session->read('login.usuario')->idusuario;
            $projetoobs->observacao = $_POST['observacao'];
            $projetoobs->horastrabalhadas = $_POST['horastrabalhadas'];

            $arquivo = null;
            if(strlen($_FILES['arquivo']['name']) > 0){
                $extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
                $temp = explode(".", $_FILES["arquivo"]["name"]);
                $arquivo = $_FILES['arquivo']['name'];
                move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($_POST['projetoidmodal']) . $arquivo);
            }

            $projetoobs->arquivo = $arquivo;

            if ($projetoobsTable->save($projetoobs)) {
                $this->Flash->success(__('observação foi salva com sucesso.'));

                //return $this->redirect(['action' => 'view',$id]);
            } else{
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
            }
        }

        $this->set(compact('projeto'));

        $this->set([
            'iniciacao'=>$iniciacao
            ,'totaliniciacao'=>$totaliniciacao
            ,'pendentes'=>$pendentes
            ,'totalpendentes'=>$totalpendentes
            ,'execucao'=>$execucao
            ,'totalexecucao'=>$totalexecucao
            ,'encerramento'=>$encerramento
            ,'totalencerramento'=>$totalencerramento
            ,'empresas'=>$empresas
            ,'projeto' =>$projeto
            ,'idempresa'=>$idempresa
            ,'orcamentacao'=>$orcamentacao
            ,'totalorcamentacao'=>$totalorcamentacao
            ,'planejamento'=>$planejamento
            ,'totalplanejamento'=>$totalplanejamento
            ,'monitoramento'=>$monitoramento
            ,'totalmonitoramento'=>$totalmonitoramento
            ,'pausados'=>$pausados
            ,'totalpausados'=>$totalpausados
            ,'usuarios'=>$usuarios
            ,'idusuariolider'=>$idusuariolider
        ]);
    }

    public function faseorcamentacao($id = null){
        $this->update('projeto',[
            'fase'=>'1 - Orçamentação'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }

        public function fasependente($id = null){
        $this->update('projeto',[
            'fase'=>'2 - Pendente'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }

    public function faseiniciacao($id = null){
        $this->update('projeto',[
            'fase'=>'3 - Iniciação'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }

    public function faseplanejamento($id = null){
        $this->update('projeto',[
            'fase'=>'4 - Planejamento'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }

    public function faseexecucao($id = null){
        $this->update('projeto',[
            'fase'=>'5 - Execução'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }

    public function fasemonitoramento($id = null){
        $this->update('projeto',[
            'fase'=>'6 - Monitoramento e Controle'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }

      public function faseencerramento($id = null){
        $this->update('projeto',[
            'fase'=>'7 - Encerramento'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }

     public function fasepausado($id = null){
        $this->update('projeto',[
            'fase'=>'8 - Pausado'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->response->body("ok");
        return $this->response;
        exit();
        //$this->redirect($this->referer());
    }
}
