<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * LogAcesso Controller
 *
 * @property \App\Model\Table\LogAcessoTable $LogAcesso
 *
 * @method \App\Model\Entity\LogAcesso[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class LogAcessoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $logAcesso = $this->paginate($this->LogAcesso);

        $this->set(compact('logAcesso'));
    }

    /**
     * View method
     *
     * @param string|null $id Log Acesso id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $logAcesso = $this->LogAcesso->get($id, [
            'contain' => []
        ]);

        $this->set('logAcesso', $logAcesso);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $logAcesso = $this->LogAcesso->newEntity();
        if ($this->request->is('post')) {
            $logAcesso = $this->LogAcesso->patchEntity($logAcesso, $this->request->getData());
            if ($this->LogAcesso->save($logAcesso)) {
                $this->Flash->success(__('log acesso foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('log acesso não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('logAcesso'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Log Acesso id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $logAcesso = $this->LogAcesso->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $logAcesso = $this->LogAcesso->patchEntity($logAcesso, $this->request->getData());
            if ($this->LogAcesso->save($logAcesso)) {
                $this->Flash->success(__('log acesso salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('log acesso não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('logAcesso'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Log Acesso id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $logAcesso = $this->LogAcesso->get($id);
        if ($this->LogAcesso->delete($logAcesso)) {
            $this->Flash->success(__('log acesso deletado com sucesso.'));
        } else {
            $this->Flash->error(__('log acesso não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
