<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;

/**
 * Telefone Controller
 *
 * @property \App\Model\Table\TelefoneTable $Telefone
 *
 * @method \App\Model\Entity\Telefone[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class MinhacontaController extends AppController
{
    public function getUploadDir($id=null){
        $uploaddir = WWW_ROOT."files/foto_usuario/$id/";
        if($this->isLocalhost()){
                $uploaddir = WWW_ROOT."files\\foto_usuario\\$id\\";
        }
        if (!file_exists($uploaddir)) {
            mkdir($uploaddir, 0755, true);
        }
        return $uploaddir;
    }
    
    public function extensoesPermitidas(){
        return ['jpg','jpeg','png','gif','JPG','JPEG','PNG','GIF'];
    }

    function apagaDir($dir) {
  if($objs = glob($dir."/*")){
    foreach($objs as $obj) {
      is_dir($obj)? apagaDir($obj) : unlink($obj);
    }
  }
  rmdir($dir);
} 
    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index($id = null)
    {
		$usuariologin = $this->sessionread('login.usuario');
        $usuariologin2 = $usuariologin->cpf;

        $usuarioTable = TableRegistry::get('Usuario');
        $usuario = $usuarioTable->newEntity();

        if ($this->request->is(['patch', 'post', 'put'])) {
            $data =  $this->request->getData();

           

            if($data['senhaatual'] == $usuariologin->senha){

                if(isset($data['novasenha']) && strlen($data['novasenha']) > 0){
                    
                    $this->update('usuario',['senha'=>$data['novasenha']],['cpf'=>$usuariologin2]);

                    $usuariologin->senha = $data['novasenha'];

                    $this->sessionwrite('login.usuario',$usuariologin);

                    $this->Flash->success(__('Senha atualizada com sucesso.'));
                }else{
                     $this->Flash->error(__('Senha não pode ser vazia'));
                }
            } else {
                $this->Flash->error(__('Senha atual incorreta')); 
            }

            return $this->redirect(['action' => 'index']);

        }


		$this->set([
			'usuariologin'=>$usuariologin
            ,'usuariologin2'=>$usuariologin2
            ,'usuario'=>$usuario
		]);
    }

    public function foto(){
        $usuariologin = $this->sessionread('login.usuario');
        
        $id = $usuariologin->idusuario;
       
        $caminho = WWW_ROOT."files/foto_usuario/$id/";
        if($this->isLocalhost()){
                $caminho = WWW_ROOT."files\\foto_usuario\\$id\\";
        }

       //$this->d($caminho);

        if ($this->request->is(['patch', 'post', 'put'])) {
            
            
            $usuarioTable = TableRegistry::getTableLocator()->get('Usuario');
            $usuarioform = $usuarioTable->get($id); 

           $this->apagaDir($caminho);
           mkdir($caminho);

            $arquivo = null;
            if(strlen($_FILES['arquivo']['name']) > 0){
                $extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
                $temp = explode(".", $_FILES["arquivo"]["name"]);
                $arquivo = $_FILES['arquivo']['name'];
                move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($id) . $arquivo);
            }

          
            $usuarioform->foto = $arquivo;

     
             if ($usuarioTable->save($usuarioform)) {

                $usuariologin->foto = $arquivo;
                $this->sessionwrite('login.usuario',$usuariologin);
                $this->Flash->success(__('foto foi salva com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('foto não pode ser salvo. Favor, tentar novamente.'));
        }
        

        $this->set(compact('usuariologin','usuariologin2'));

    }

 
}
