<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Modulo Controller
 *
 * @property \App\Model\Table\ModuloTable $Modulo
 *
 * @method \App\Model\Entity\Modulo[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ModuloController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $modulo = $this->paginate($this->Modulo);

        $this->set(compact('modulo'));
    }

    /**
     * View method
     *
     * @param string|null $id Modulo id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $modulo = $this->Modulo->get($id, [
            'contain' => []
        ]);

        $this->set('modulo', $modulo);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $modulo = $this->Modulo->newEntity();
        if ($this->request->is('post')) {
            $modulo = $this->Modulo->patchEntity($modulo, $this->request->getData());
            if ($this->Modulo->save($modulo)) {
                $this->Flash->success(__('modulo foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('modulo não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('modulo'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Modulo id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $modulo = $this->Modulo->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $modulo = $this->Modulo->patchEntity($modulo, $this->request->getData());
            if ($this->Modulo->save($modulo)) {
                $this->Flash->success(__('modulo salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('modulo não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('modulo'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Modulo id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $modulo = $this->Modulo->get($id);
        if ($this->Modulo->delete($modulo)) {
            $this->Flash->success(__('modulo deletado com sucesso.'));
        } else {
            $this->Flash->error(__('modulo não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
