<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Modulousuario Controller
 *
 * @property \App\Model\Table\ModulousuarioTable $Modulousuario
 *
 * @method \App\Model\Entity\Modulousuario[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ModulousuarioController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $modulousuario = $this->paginate($this->Modulousuario);

        $this->set(compact('modulousuario'));
    }

    /**
     * View method
     *
     * @param string|null $id Modulousuario id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $modulousuario = $this->Modulousuario->get($id, [
            'contain' => []
        ]);

        $this->set('modulousuario', $modulousuario);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null)
    {
		$idusuario = "";
		if($id != null){
			$idusuario = $id;
		}
        $modulousuario = $this->Modulousuario->newEntity();
        if ($this->request->is('post')) {
            $modulousuario = $this->Modulousuario->patchEntity($modulousuario, $this->request->getData());
			$idusuario = $modulousuario->idusuario;
			$session = $this->request->session();
			$modulousuario->usuario_criacao = $session->read('login.usuario')->idusuario;
            if ($this->Modulousuario->save($modulousuario)) {
                $this->Flash->success(__('modulousuario foi salvo com sucesso.'));

                return $this->redirect($this->referer());
            }
            $this->Flash->error(__('modulousuario não pode ser salvo. Favor, tentar novamente.'));
        }
		$modulos = $this->getAllTableWhere('modulo',['1'=>1],['ordem_menu'=>'asc']);
		$this->set([
			'modulos'=>$modulos
			,'idusuario'=>$idusuario
		]);
        $this->set(compact('modulousuario'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Modulousuario id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $modulousuario = $this->Modulousuario->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $modulousuario = $this->Modulousuario->patchEntity($modulousuario, $this->request->getData());
            if ($this->Modulousuario->save($modulousuario)) {
                $this->Flash->success(__('modulousuario salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('modulousuario não pode ser salvo. Favor, tentar novamente.'));
        }
		$modulos = $this->getAllTableWhere('modulo',['1'=>1],['nome'=>'asc']);
		$this->set([
			'modulos'=>$modulos
		]);
        $this->set(compact('modulousuario'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Modulousuario id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $modulousuario = $this->Modulousuario->get($id);
        if ($this->Modulousuario->delete($modulousuario)) {
            $this->Flash->success(__('modulousuario deletado com sucesso.'));
        } else {
            $this->Flash->error(__('modulousuario não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect($this->referer());
    }
}
