<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;
use \stdClass;
use Cake\ORM\TableRegistry;

/**
 * Projeto Controller
 *
 * @property \App\Model\Table\ProjetoTable $Projeto
 *
 * @method \App\Model\Entity\Projeto[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ProjetoController extends AppController
{
    public function getUploadDir($id=null){
        $uploaddir = "../../arquivos/flygestor/$id/";
        if($this->isLocalhost()){
                $uploaddir = "..\\..\\arquivos\\flygestor\\$id\\";
        }
        if (!file_exists($uploaddir)) {
            mkdir($uploaddir, 0755, true);
        }
        return $uploaddir;
    }

    public function extensoesPermitidas(){
        return ['jpg','jpeg','png','gif','JPG','JPEG','PNG','GIF'];
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $projeto = $this->paginate($this->Projeto);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
        $usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);

        $idusuariolider = "-1";
        if(isset($_POST['idusuariolider'])){
            $idusuariolider = $_POST['idusuariolider'];
        }else{
            $session = $this->request->session();
            $idusuariolider = $session->read('login.usuario')->idusuario;
        }


        $idempresa = "-1";
        if(isset($_POST['idempresa'])){
            $idempresa = $_POST['idempresa'];
        }

         //Projetos em orçamentação
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '1 - Orçamentação'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $orcamentacao = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '1 - Orçamentação'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalorcamentacao = $this->query($sql)[0]->total;

         //Projetos pendentes
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '2 - Pendente'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $pendentes = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '2 - Pendente'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalpendentes = $this->query($sql)[0]->total;

        //Projetos em iniciação
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '3 - Iniciação'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $iniciacao = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '3 - Iniciação'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totaliniciacao = $this->query($sql)[0]->total;

         //Projetos em Planejamento
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '4 - Planejamento'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $planejamento = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '4 - Planejamento'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalplanejamento = $this->query($sql)[0]->total;

        //Projetos em execução
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '5 - Execução'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $execucao = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '5 - Execução'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalexecucao = $this->query($sql)[0]->total;

         //Projetos em Monitoramento
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '6 - Monitoramento e Controle'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $monitoramento = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '6 - Monitoramento e Controle'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalmonitoramento = $this->query($sql)[0]->total;

        //Projetos Encerramento
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '7 - Encerramento'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $encerramento = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '7 - Encerramento'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalencerramento = $this->query($sql)[0]->total;

        //Projetos Pausados
        $sql = "select p.idprojeto, p.nome,p.data_criacao,p.descricao,p.patrocinador,p.idempresa,p.idusuariolider,p.status,COUNT(c.idchamado) as qtdchamados
        from projeto p
        left join chamado c on c.idprojeto = p.idprojeto
        where
            p.fase = '8 - Pausado'
            and p.situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR p.idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)
            group by p.idprojeto
        order by 1 desc limit 20";
        $pausados = $this->query($sql);

        $sql = "select count(1) as total
        from projeto
        where
            fase = '8 - Pausado'
            and situacao <> '5 - Cancelado'
            and ('-1' = '$idempresa' OR idempresa = $idempresa)
            and ('-1' = '$idusuariolider' OR idusuariolider = $idusuariolider)";
        $totalpausados = $this->query($sql)[0]->total;


        $projeto = $this->paginate($this->Projeto,['order'=>['idprojeto'=>'desc']]);

        if ($this->request->is('post') && isset($_POST['observacao'])) {
            $session = $this->request->getSession();

            $projetoobsTable = TableRegistry::get('projetoobs');
            $projetoobs = $projetoobsTable->newEntity();

            $projetoobs->idprojeto = $_POST['projetoidmodal'];
            $projetoobs->idusuario = $session->read('login.usuario')->idusuario;
            $projetoobs->observacao = $_POST['observacao'];
            $projetoobs->horastrabalhadas = $_POST['horastrabalhadas'];

            $arquivo = null;
            if(strlen($_FILES['arquivo']['name']) > 0){
                $extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
                $temp = explode(".", $_FILES["arquivo"]["name"]);
                $arquivo = $_FILES['arquivo']['name'];
                move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($_POST['projetoidmodal']) . $arquivo);
            }

            $projetoobs->arquivo = $arquivo;

            if ($projetoobsTable->save($projetoobs)) {
                $this->Flash->success(__('observação foi salva com sucesso.'));

                //return $this->redirect(['action' => 'view',$id]);
            } else{
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
            }
        }

        $this->set(compact('projeto'));

        $this->set([
            'iniciacao'=>$iniciacao
            ,'totaliniciacao'=>$totaliniciacao
            ,'pendentes'=>$pendentes
            ,'totalpendentes'=>$totalpendentes
            ,'execucao'=>$execucao
            ,'totalexecucao'=>$totalexecucao
            ,'encerramento'=>$encerramento
            ,'totalencerramento'=>$totalencerramento
            ,'empresas'=>$empresas
            ,'projeto' =>$projeto
            ,'idempresa'=>$idempresa
            ,'orcamentacao'=>$orcamentacao
            ,'totalorcamentacao'=>$totalorcamentacao
            ,'planejamento'=>$planejamento
            ,'totalplanejamento'=>$totalplanejamento
            ,'monitoramento'=>$monitoramento
            ,'totalmonitoramento'=>$totalmonitoramento
            ,'pausados'=>$pausados
            ,'totalpausados'=>$totalpausados
            ,'usuarios'=>$usuarios
            ,'idusuariolider'=>$idusuariolider
        ]);
    }

    /**
     * View method
     *
     * @param string|null $id Projeto id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $sql = "SELECT SUM(co.horastrabalhadas) as totalhoras FROM chamadoobs co
                inner JOIN chamado c on c.idchamado = co.idchamado
                WHERE c.idprojeto = $id";

        $totalhoras = $this->query($sql)[0]->totalhoras;

        $sql = "SELECT
                CASE WHEN COUNT(idchamado) = 0 THEN 1 ELSE COUNT(idchamado) END as qtdchamados
                ,(SELECT COUNT(idchamado) from chamado where idchamadostatus in (5,8) and idprojeto = $id) as qtdfinalizados
                from chamado where idprojeto = $id";

        $percentual = $this->query($sql)[0];
        $totpercentual = ($percentual->qtdfinalizados/$percentual->qtdchamados)*100;

        $sql = "SELECT COALESCE(sum(horasprevistas),0) as horasprevistaschamados FROM chamado WHERE idprojeto = $id";
        $horasprevistaschamados = $this->query($sql)[0]->horasprevistaschamados;

        $sql = "SELECT COUNT(idchamado) as qtdchamados from chamado where idprojeto = $id";
        $qtdchamados = $this->query($sql)[0]->qtdchamados;

        //$this->d($qtdchamados);

		if ($this->request->is('post')) {
            $session = $this->request->getSession();

			$projetoobsTable = TableRegistry::get('projetoobs');
			$projetoobs = $projetoobsTable->newEntity();

			$projetoobs->idprojeto = $id;
			$projetoobs->idusuario = $session->read('login.usuario')->idusuario;
			$projetoobs->observacao = $_POST['observacao'];
            $projetoobs->horastrabalhadas = $_POST['horastrabalhadas'];

            $arquivo = null;
            if(strlen($_FILES['arquivo']['name']) > 0){
                $extensao = pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION);
                $temp = explode(".", $_FILES["arquivo"]["name"]);
                $arquivo = $_FILES['arquivo']['name'];
                move_uploaded_file($_FILES["arquivo"]["tmp_name"], $this->getUploadDir($id) . $arquivo);
            }

            $projetoobs->arquivo = $arquivo;

            if ($projetoobsTable->save($projetoobs)) {
                $this->Flash->success(__('observação foi salva com sucesso.'));

                return $this->redirect(['action' => 'view',$id]);
            }
            $this->Flash->error(__('chamadoob não pode ser salvo. Favor, tentar novamente.'));
        }
		$chamado = $this->getAllTableWhere('chamado',['idprojeto'=>$id],[]);
		$projetoobs = $this->getAllTableWhere('projetoobs',['idprojeto'=>$id],['data_criacao'=>'desc']);
        $this->set([
			'projeto'=>$projeto
			,'chamado'=>$chamado
			,'projetoobs'=>$projetoobs
            ,'totalhoras'=>$totalhoras
            ,'totpercentual'=>$totpercentual
            ,'horasprevistaschamados'=>$horasprevistaschamados
            ,'qtdchamados'=>$qtdchamados
		]);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);

        $projeto = $this->Projeto->newEntity();
        if ($this->request->is('post')) {
            $projeto = $this->Projeto->patchEntity($projeto, $this->request->getData());

            if($this->validaData($_POST['data_inicio'])){
                $projeto->data_inicio = $this->formatDataToDatabase($_POST['data_inicio']);
            }else{
                $projeto->data_inicio = null;
            }

             if($this->validaData($_POST['data_fim'])){
                $projeto->data_fim = $this->formatDataToDatabase($_POST['data_fim']);
            }else{
                $projeto->data_fim = null;
            }

            if ($this->Projeto->save($projeto)) {
                $this->Flash->success(__('projeto foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('projeto não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('projeto'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Projeto id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);
		$usuarios = $this->getAllTableWhere('usuario',['idempresa'=>1],['nome'=>'asc']);
        $empresas = $this->getAllTableWhere('empresa',[],['nome'=>'asc']);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $projeto = $this->Projeto->patchEntity($projeto, $this->request->getData());

            $projetoobsTable = TableRegistry::get('Projetoobs');
            $projetoob = $projetoobsTable->newEntity();
            $projetoob->idprojeto = $projeto->idprojeto;
            $session = $this->request->getSession();
            $projetoob->idusuario = $session->read('login.usuario')->idusuario;
            $projetoob->log = 1;
            $projetoob->observacao = "<spam>Situação: <i>$projeto->situacao</i>
                                      Fase: <i>$projeto->fase</i>
                                      Horas Previstas: <i>$projeto->horasprevistas</i>
                                      Concluído: <i>$projeto->status%</i></spam>";
            $projetoobsTable->save($projetoob);
            if ($this->Projeto->save($projeto)) {
                $this->Flash->success(__('projeto salvo com sucesso.'));

               return $this->redirect(['action' => 'view',$id]);
            }
            $this->Flash->error(__('projeto não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('projeto'));
		$this->set([
			'usuarios'=>$usuarios
			,'empresas'=>$empresas
		]);
    }

    /**
     * Delete method
     *
     * @param string|null $id Projeto id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $projeto = $this->Projeto->get($id);
        if ($this->Projeto->delete($projeto)) {
            $this->Flash->success(__('projeto deletado com sucesso.'));
        } else {
            $this->Flash->error(__('projeto não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

     public function faseorcamentacao($id = null){
        $this->update('projeto',[
            'fase'=>'1 - Orçamentação'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

        public function fasependente($id = null){
        $this->update('projeto',[
            'fase'=>'2 - Pendente'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

    public function faseiniciacao($id = null){
        $this->update('projeto',[
            'fase'=>'3 - Iniciação'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

    public function faseplanejamento($id = null){
        $this->update('projeto',[
            'fase'=>'4 - Planejamento'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

    public function faseexecucao($id = null){
        $this->update('projeto',[
            'fase'=>'5 - Execução'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

    public function fasemonitoramento($id = null){
        $this->update('projeto',[
            'fase'=>'6 - Monitoramento e Controle'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

      public function faseencerramento($id = null){
        $this->update('projeto',[
            'fase'=>'7 - Encerramento'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

     public function fasepausado($id = null){
        $this->update('projeto',[
            'fase'=>'8 - Pausado'
        ],[
            'idprojeto'=>$id
        ]);

        $projeto = $this->Projeto->get($id, [
            'contain' => []
        ]);

        $this->insert('projetoobs',[
                        'idprojeto'=>$projeto->idprojeto
                        ,'idusuario'=>$this->usuarioid()
                        ,'log'=>1
                        ,'observacao'=>"<p>Fase: <i>$projeto->fase</i></p>"
                    ]);

        $this->redirect($this->referer());
    }

}
