<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Projetomembro Controller
 *
 * @property \App\Model\Table\ProjetomembroTable $Projetomembro
 *
 * @method \App\Model\Entity\Projetomembro[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ProjetomembroController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $projetomembro = $this->paginate($this->Projetomembro);

        $this->set(compact('projetomembro'));
    }

    /**
     * View method
     *
     * @param string|null $id Projetomembro id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $projetomembro = $this->Projetomembro->get($id, [
            'contain' => []
        ]);

        $this->set('projetomembro', $projetomembro);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $projetomembro = $this->Projetomembro->newEntity();
        if ($this->request->is('post')) {
            $projetomembro = $this->Projetomembro->patchEntity($projetomembro, $this->request->getData());
            if ($this->Projetomembro->save($projetomembro)) {
                $this->Flash->success(__('projetomembro foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('projetomembro não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('projetomembro'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Projetomembro id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $projetomembro = $this->Projetomembro->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $projetomembro = $this->Projetomembro->patchEntity($projetomembro, $this->request->getData());
            if ($this->Projetomembro->save($projetomembro)) {
                $this->Flash->success(__('projetomembro salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('projetomembro não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('projetomembro'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Projetomembro id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $projetomembro = $this->Projetomembro->get($id);
        if ($this->Projetomembro->delete($projetomembro)) {
            $this->Flash->success(__('projetomembro deletado com sucesso.'));
        } else {
            $this->Flash->error(__('projetomembro não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
