<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Projetoobs Controller
 *
 * @property \App\Model\Table\ProjetoobsTable $Projetoobs
 *
 * @method \App\Model\Entity\Projetoob[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ProjetoobsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $projetoobs = $this->paginate($this->Projetoobs);

        $this->set(compact('projetoobs'));
    }

    /**
     * View method
     *
     * @param string|null $id Projetoob id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $projetoob = $this->Projetoobs->get($id, [
            'contain' => []
        ]);

        $this->set('projetoob', $projetoob);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $projetoob = $this->Projetoobs->newEntity();
        if ($this->request->is('post')) {
            $projetoob = $this->Projetoobs->patchEntity($projetoob, $this->request->getData());
            if ($this->Projetoobs->save($projetoob)) {
                $this->Flash->success(__('projetoob foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('projetoob não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('projetoob'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Projetoob id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $projetoob = $this->Projetoobs->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $projetoob = $this->Projetoobs->patchEntity($projetoob, $this->request->getData());
            if ($this->Projetoobs->save($projetoob)) {
                $this->Flash->success(__('salvo com sucesso.'));

                return $this->redirect(['controller'=>'chamado','action' => 'view',$projetoob->idprojeto]);
            }
            $this->Flash->error(__('projetoob não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('projetoob'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Projetoob id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $projetoob = $this->Projetoobs->get($id);
        if ($this->Projetoobs->delete($projetoob)) {
            $this->Flash->success(__('deletado com sucesso.'));
        } else {
            $this->Flash->error(__('projetoob não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['controller'=>'projeto','action' => 'view',$projetoob->idprojeto]);
    }
}
